/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class WorkbenchPart
implements IWorkbenchPart2,
IExecutableExtension {
    private String title = "";
    private ImageDescriptor imageDescriptor;
    private Image titleImage;
    private String toolTip = "";
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private ListenerList propChangeListeners = new ListenerList(2);
    private String partName = "";
    private String contentDescription = "";

    protected WorkbenchPart() {
    }

    public void addPropertyListener(IPropertyListener l) {
        this.propChangeListeners.add((Object)l);
    }

    public abstract void createPartControl(Composite var1);

    public void dispose() {
        int count;
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        Image image = (Image)imageCache.get(this.imageDescriptor);
        if (image != null && (count = imageCache.removeRef(this.imageDescriptor)) <= 0) {
            image.dispose();
        }
        if (!this.propChangeListeners.isEmpty()) {
            this.propChangeListeners = new ListenerList(1);
        }
    }

    protected void firePropertyChange(final int propertyId) {
        Object[] array = this.propChangeListeners.getListeners();
        for (int nX = 0; nX < array.length; ++nX) {
            final IPropertyListener l = (IPropertyListener)array[nX];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.propertyChanged(WorkbenchPart.this, propertyId);
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    public String getTitle() {
        return this.title;
    }

    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    public String getTitleToolTip() {
        return this.toolTip;
    }

    public void removePropertyListener(IPropertyListener l) {
        this.propChangeListeners.remove((Object)l);
    }

    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
        this.title = this.partName = Util.safeString(cfig.getAttribute("name"));
        String strIcon = cfig.getAttribute("icon");
        if (strIcon == null) {
            return;
        }
        this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(this.configElement.getDeclaringExtension().getNamespace(), strIcon);
        if (this.imageDescriptor == null) {
            return;
        }
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        Image image = (Image)imageCache.get(this.imageDescriptor);
        if (image != null) {
            imageCache.addRef(this.imageDescriptor);
        } else {
            image = this.imageDescriptor.createImage();
            imageCache.put(this.imageDescriptor, image);
        }
        this.titleImage = image;
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.partSite = site;
    }

    protected void setTitle(String title) {
        if (Util.equals(this.title, title = Util.safeString(title))) {
            return;
        }
        this.title = title;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image titleImage) {
        Assert.isTrue(titleImage == null || !titleImage.isDisposed());
        if (this.titleImage == titleImage) {
            return;
        }
        this.titleImage = titleImage;
        this.firePropertyChange(1);
    }

    protected void setTitleToolTip(String toolTip) {
        if (Util.equals(this.toolTip, toolTip = Util.safeString(toolTip))) {
            return;
        }
        this.toolTip = toolTip;
        this.firePropertyChange(1);
    }

    public void showBusy(boolean busy) {
    }

    public String getPartName() {
        return this.partName;
    }

    protected void setPartName(String partName) {
        this.internalSetPartName(partName);
        this.setDefaultTitle();
    }

    void setDefaultTitle() {
        String name;
        String description = this.getContentDescription();
        String newTitle = name = this.getPartName();
        if (!Util.equals(description, "")) {
            newTitle = MessageFormat.format(WorkbenchMessages.getString("WorkbenchPart.AutoTitleFormat"), name, description);
        }
        this.setTitle(newTitle);
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    protected void setContentDescription(String description) {
        this.internalSetContentDescription(description);
        this.setDefaultTitle();
    }

    void internalSetContentDescription(String description) {
        Assert.isNotNull(description);
        if (Util.equals(this.contentDescription, description)) {
            return;
        }
        this.contentDescription = description;
        this.firePropertyChange(261);
    }

    void internalSetPartName(String partName) {
        partName = Util.safeString(partName);
        Assert.isNotNull(partName);
        if (Util.equals(this.partName, partName)) {
            return;
        }
        this.partName = partName;
        this.firePropertyChange(260);
    }
}

