/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.InclusivePositionUpdater;
import org.eclipse.jface.text.templates.JFaceTextTemplateMessages;
import org.eclipse.jface.text.templates.PositionBasedCompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private final IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;
    private InclusivePositionUpdater fUpdater;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        this(template, context, region, image, 0);
    }

    public TemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)region);
        this.fTemplate = template;
        this.fContext = context;
        this.fImage = image;
        this.fRegion = region;
        this.fDisplayString = null;
        this.fRelevance = relevance;
    }

    public final void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException e1) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int start = this.getReplaceOffset();
            int end = Math.max(this.getReplaceEndOffset(), offset);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedModeModel model = new LinkedModeModel();
            TemplateVariable[] variables = templateBuffer.getVariables();
            boolean hasPositions = false;
            for (int i = 0; i != variables.length; ++i) {
                int j;
                TemplateVariable variable = variables[i];
                if (variable.isUnambiguous()) continue;
                LinkedPositionGroup group = new LinkedPositionGroup();
                int[] offsets = variable.getOffsets();
                int length = variable.getLength();
                String[] values = variable.getValues();
                ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                for (j = 0; j < values.length; ++j) {
                    this.ensurePositionCategoryInstalled(document, model);
                    Position pos = new Position(offsets[0] + start, length);
                    document.addPosition(this.getCategory(), pos);
                    proposals[j] = new PositionBasedCompletionProposal(values[j], pos, length);
                }
                for (j = 0; j != offsets.length; ++j) {
                    if (j == 0 && proposals.length > 1) {
                        group.addPosition((LinkedPosition)new ProposalPosition(document, offsets[j] + start, length, proposals));
                        continue;
                    }
                    group.addPosition(new LinkedPosition(document, offsets[j] + start, length));
                }
                model.addGroup(group);
                hasPositions = true;
            }
            if (hasPositions) {
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getCaretOffset(templateBuffer) + start, 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + start, 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.ensurePositionCategoryRemoved(document);
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    TemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        for (int i = 0; i != variables.length; ++i) {
            TemplateVariable variable = variables[i];
            if (!variable.getType().equals("cursor")) continue;
            return variable.getOffsets()[0];
        }
        return buffer.getString().length();
    }

    private int getReplaceOffset() {
        int start;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            start = docContext.getStart();
        } else {
            start = this.fRegion.getOffset();
        }
        return start;
    }

    private int getReplaceEndOffset() {
        int end;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            end = docContext.getEnd();
        } else {
            end = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return end;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException e) {
                return null;
            }
            return templateBuffer.getString();
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = this.fTemplate.getName() + JFaceTextTemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
        }
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)JFaceTextTemplateMessages.getString("TemplateProposal.errorDialog.title"), (String)e.getMessage());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.fTemplate.getName().startsWith(content);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    public int getContextInformationPosition() {
        return this.fRegion.getOffset();
    }
}

