/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class ImportsStructure
implements IImportsStructure {
    private ICompilationUnit fCompilationUnit;
    private ArrayList fPackageEntries;
    private int fImportOnDemandThreshold;
    private boolean fFilterImplicitImports;
    private boolean fFindAmbiguousImports;
    private int fNumberOfImportsCreated;
    private boolean fHasChanges = false;
    private IRegion fReplaceRange;
    private static final String JAVA_LANG = "java.lang";

    public ImportsStructure(ICompilationUnit cu, String[] preferenceOrder, int importThreshold, boolean restoreExistingImports) throws CoreException {
        this.fCompilationUnit = cu;
        JavaModelUtil.reconcile(cu);
        IImportContainer container = cu.getImportContainer();
        this.fImportOnDemandThreshold = importThreshold;
        this.fFilterImplicitImports = true;
        this.fFindAmbiguousImports = !restoreExistingImports;
        this.fPackageEntries = new ArrayList(20);
        NullProgressMonitor monitor = new NullProgressMonitor();
        IDocument document = null;
        try {
            document = this.aquireDocument((IProgressMonitor)monitor);
            if (restoreExistingImports && container.exists()) {
                this.addExistingImports(document, cu.getImports());
            }
            this.fReplaceRange = this.evaluateReplaceRange(document);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
        finally {
            if (document != null) {
                this.releaseDocument(document, (IProgressMonitor)monitor);
            }
        }
        this.addPreferenceOrderHolders(preferenceOrder);
        this.fNumberOfImportsCreated = 0;
        this.fHasChanges = false;
    }

    private void addPreferenceOrderHolders(String[] preferenceOrder) {
        if (this.fPackageEntries.isEmpty()) {
            for (int i = 0; i < preferenceOrder.length; ++i) {
                PackageEntry entry = new PackageEntry(preferenceOrder[i]);
                this.fPackageEntries.add(entry);
            }
        } else {
            PackageEntry[] lastAssigned = new PackageEntry[preferenceOrder.length];
            for (int k = 0; k < this.fPackageEntries.size(); ++k) {
                PackageEntry entry = (PackageEntry)this.fPackageEntries.get(k);
                if (entry.isComment()) continue;
                String currName = entry.getName();
                int currNameLen = currName.length();
                int bestGroupIndex = -1;
                int bestGroupLen = -1;
                for (int i = 0; i < preferenceOrder.length; ++i) {
                    String currPrefEntry = preferenceOrder[i];
                    int currPrefLen = currPrefEntry.length();
                    if (!currName.startsWith(currPrefEntry) || currPrefLen < bestGroupLen || currPrefLen != currNameLen && currName.charAt(currPrefLen) != '.' || bestGroupIndex != -1 && currPrefLen <= bestGroupLen) continue;
                    bestGroupLen = currPrefLen;
                    bestGroupIndex = i;
                }
                if (bestGroupIndex == -1) continue;
                entry.setGroupID(preferenceOrder[bestGroupIndex]);
                lastAssigned[bestGroupIndex] = entry;
            }
            int currAppendIndex = 0;
            for (int i = 0; i < lastAssigned.length; ++i) {
                PackageEntry entry = lastAssigned[i];
                if (entry == null) {
                    PackageEntry newEntry = new PackageEntry(preferenceOrder[i]);
                    this.fPackageEntries.add(currAppendIndex, newEntry);
                    ++currAppendIndex;
                    continue;
                }
                currAppendIndex = this.fPackageEntries.indexOf(entry) + 1;
            }
        }
    }

    private void addExistingImports(IDocument document, IImportDeclaration[] decls) throws JavaModelException, BadLocationException {
        if (decls.length == 0) {
            return;
        }
        PackageEntry currPackage = null;
        IImportDeclaration curr = decls[0];
        ISourceRange sourceRange = curr.getSourceRange();
        int currOffset = sourceRange.getOffset();
        int currLength = sourceRange.getLength();
        int currEndLine = document.getLineOfOffset(currOffset + currLength);
        for (int i = 1; i < decls.length; ++i) {
            String name = curr.getElementName();
            String packName = Signature.getQualifier((String)name);
            if (currPackage == null || !packName.equals(currPackage.getName())) {
                currPackage = new PackageEntry(packName, null);
                this.fPackageEntries.add(currPackage);
            }
            IImportDeclaration next = decls[i];
            sourceRange = next.getSourceRange();
            int nextOffset = sourceRange.getOffset();
            int nextLength = sourceRange.getLength();
            int nextOffsetLine = document.getLineOfOffset(nextOffset);
            if (currEndLine < nextOffsetLine) {
                nextOffset = document.getLineInformation(++currEndLine).getOffset();
            }
            currPackage.add(new ImportDeclEntry(name, document.get(currOffset, nextOffset - currOffset)));
            currOffset = nextOffset;
            curr = next;
            if (currEndLine < nextOffsetLine) {
                nextOffset = document.getLineInformation(nextOffsetLine).getOffset();
                currPackage = new PackageEntry();
                this.fPackageEntries.add(currPackage);
                currPackage.add(new ImportDeclEntry(null, document.get(currOffset, nextOffset - currOffset)));
                currOffset = nextOffset;
            }
            currEndLine = document.getLineOfOffset(nextOffset + nextLength);
        }
        String name = curr.getElementName();
        String packName = Signature.getQualifier((String)name);
        if (currPackage == null || !packName.equals(currPackage.getName())) {
            currPackage = new PackageEntry(packName, null);
            this.fPackageEntries.add(currPackage);
        }
        ISourceRange range = curr.getSourceRange();
        int endOffset = range.getOffset() + range.getLength();
        String content = document.get(currOffset, endOffset - currOffset) + TextUtilities.getDefaultLineDelimiter((IDocument)document);
        currPackage.add(new ImportDeclEntry(name, content));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fFilterImplicitImports = filterImplicitImports;
    }

    public void setFindAmbiguousImports(boolean findAmbiguousImports) {
        this.fFindAmbiguousImports = findAmbiguousImports;
    }

    private static int getCommonPrefixLength(String s, String t) {
        int len = Math.min(s.length(), t.length());
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return i;
        }
        return len;
    }

    private static char getCharAt(String str, int index) {
        if (str.length() > index) {
            return str.charAt(index);
        }
        return '\u0000';
    }

    private PackageEntry findBestMatch(String newName) {
        if (this.fPackageEntries.isEmpty()) {
            return null;
        }
        String groupId = null;
        int longestPrefix = -1;
        for (int i = 0; i < this.fPackageEntries.size(); ++i) {
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i);
            String currGroup = curr.getGroupID();
            if (currGroup == null || !newName.startsWith(currGroup)) continue;
            int prefixLen = currGroup.length();
            if (prefixLen == newName.length()) {
                return curr;
            }
            if (newName.charAt(prefixLen) != '.' || prefixLen <= longestPrefix) continue;
            longestPrefix = prefixLen;
            groupId = currGroup;
        }
        PackageEntry bestMatch = null;
        PackageMatcher matcher = new PackageMatcher();
        matcher.initialize(newName, "");
        for (int i = 0; i < this.fPackageEntries.size(); ++i) {
            boolean preferrCurr;
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i);
            if (curr.isComment() || groupId != null && !groupId.equals(curr.getGroupID())) continue;
            boolean bl = preferrCurr = bestMatch == null || curr.getNumberOfImports() > bestMatch.getNumberOfImports();
            if (!matcher.isBetterMatch(curr.getName(), preferrCurr)) continue;
            bestMatch = curr;
        }
        return bestMatch;
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if (JAVA_LANG.equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String mainTypeName = JavaModelUtil.concatenateName(packageName, Signature.getQualifier((String)cu.getElementName()));
        return qualifier.equals(mainTypeName);
    }

    public String addImport(ITypeBinding binding) {
        ITypeBinding normalizedBinding = Bindings.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return binding.getName();
        }
        String qualifiedName = normalizedBinding.getQualifiedName();
        if (qualifiedName.length() > 0) {
            return this.addImport(qualifiedName);
        }
        return normalizedBinding.getName();
    }

    public String addImport(String typeContainerName, String typeName) {
        return this.addImport(JavaModelUtil.concatenateName(typeContainerName, typeName));
    }

    public String addImport(String qualifiedTypeName) {
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            return this.internalAddImport(qualifiedTypeName.substring(0, bracketOffset)) + qualifiedTypeName.substring(bracketOffset);
        }
        return this.internalAddImport(qualifiedTypeName);
    }

    private String internalAddImport(String fullTypeName) {
        String typeContainerName = Signature.getQualifier((String)fullTypeName);
        String typeName = Signature.getSimpleName((String)fullTypeName);
        if (typeContainerName.length() == 0 && PrimitiveType.toCode((String)typeName) != null) {
            return fullTypeName;
        }
        if (!"*".equals(typeName)) {
            String topLevelTypeName = Signature.getQualifier((String)this.fCompilationUnit.getElementName());
            if (typeName.equals(topLevelTypeName)) {
                if (!typeContainerName.equals(this.fCompilationUnit.getParent().getElementName())) {
                    return fullTypeName;
                }
                return typeName;
            }
            String existing = this.findImport(typeName);
            if (existing != null) {
                if (fullTypeName.equals(existing)) {
                    return typeName;
                }
                return fullTypeName;
            }
        }
        ImportDeclEntry decl = new ImportDeclEntry(fullTypeName, null);
        PackageEntry bestMatch = this.findBestMatch(typeContainerName);
        if (bestMatch == null) {
            PackageEntry packEntry = new PackageEntry(typeContainerName, null);
            packEntry.add(decl);
            this.fPackageEntries.add(0, packEntry);
        } else {
            int cmp = typeContainerName.compareTo(bestMatch.getName());
            if (cmp == 0) {
                bestMatch.sortIn(decl);
            } else {
                String group = bestMatch.getGroupID();
                if (group != null && !typeContainerName.startsWith(group)) {
                    group = null;
                }
                PackageEntry packEntry = new PackageEntry(typeContainerName, group);
                packEntry.add(decl);
                int index = this.fPackageEntries.indexOf(bestMatch);
                if (cmp < 0) {
                    this.fPackageEntries.add(index, packEntry);
                } else {
                    this.fPackageEntries.add(index + 1, packEntry);
                }
            }
        }
        this.fHasChanges = true;
        return typeName;
    }

    public boolean removeImport(String qualifiedTypeName) {
        String typeContainerName = Signature.getQualifier((String)qualifiedTypeName);
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            qualifiedTypeName = qualifiedTypeName.substring(0, bracketOffset);
        }
        int nPackages = this.fPackageEntries.size();
        for (int i = 0; i < nPackages; ++i) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (!entry.getName().equals(typeContainerName) || !entry.remove(qualifiedTypeName)) continue;
            this.fHasChanges = true;
            return true;
        }
        return false;
    }

    public boolean removeImport(ITypeBinding binding) {
        if ((binding = Bindings.normalizeTypeBinding(binding)) == null) {
            return false;
        }
        String qualifiedName = binding.getQualifiedName();
        if (qualifiedName.length() > 0) {
            return this.removeImport(qualifiedName);
        }
        return false;
    }

    public String findImport(String simpleName) {
        int nPackages = this.fPackageEntries.size();
        for (int i = 0; i < nPackages; ++i) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            ImportDeclEntry found = entry.find(simpleName);
            if (found == null) continue;
            return found.getElementName();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(boolean save, IProgressMonitor monitor) throws CoreException {
        block9: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CodeGenerationMessages.getString("ImportsStructure.operation.description"), 4);
            IDocument document = null;
            try {
                block8: {
                    try {
                        document = this.aquireDocument((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        MultiTextEdit edit = this.getResultingEdits(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (!edit.hasChildren()) break block8;
                        edit.apply(document);
                        if (save) {
                            this.commitDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (BadLocationException e) {
                        throw new CoreException(JavaUIStatus.createError(4, e));
                    }
                }
                Object var6_6 = null;
                if (document == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (document != null) {
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.done();
                throw throwable;
            }
            this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    private IDocument aquireDocument(IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = this.fCompilationUnit.getPath();
            bufferManager.connect(path, monitor);
            return bufferManager.getTextFileBuffer(path).getDocument();
        }
        monitor.done();
        return new Document(this.fCompilationUnit.getSource());
    }

    private void releaseDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.disconnect(file.getFullPath(), monitor);
            return;
        }
        this.fCompilationUnit.getBuffer().setContents(document.get());
        monitor.done();
    }

    private void commitDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)this.fCompilationUnit.getResource()).exists()) {
            IStatus status = Resources.makeCommittable((IResource)file, null);
            if (!status.isOK()) {
                throw new ValidateEditException(status);
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.getTextFileBuffer(file.getFullPath()).commit(monitor, true);
        }
    }

    private IRegion evaluateReplaceRange(IDocument document) throws JavaModelException, BadLocationException {
        JavaModelUtil.reconcile(this.fCompilationUnit);
        IImportContainer container = this.fCompilationUnit.getImportContainer();
        if (container.exists()) {
            int nextLine;
            ISourceRange importSourceRange = container.getSourceRange();
            int startPos = importSourceRange.getOffset();
            int endPos = startPos + importSourceRange.getLength();
            if (!Strings.isLineDelimiterChar(document.getChar(endPos - 1)) && (nextLine = document.getLineOfOffset(endPos) + 1) < document.getNumberOfLines()) {
                int stopPos = document.getLineInformation(nextLine).getOffset();
                while (endPos < stopPos && Character.isWhitespace(document.getChar(endPos))) {
                    ++endPos;
                }
            }
            return new Region(startPos, endPos - startPos);
        }
        int start = this.getPackageStatementEndPos(document);
        return new Region(start, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiTextEdit getResultingEdits(IDocument document, IProgressMonitor monitor) throws JavaModelException, BadLocationException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int importsStart = this.fReplaceRange.getOffset();
            int importsLen = this.fReplaceRange.getLength();
            String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            boolean useSpaceBetween = this.useSpaceBetweenGroups();
            StringBuffer buf = new StringBuffer();
            int nCreated = 0;
            PackageEntry lastPackage = null;
            Set onDemandConflicts = null;
            if (this.fFindAmbiguousImports) {
                onDemandConflicts = this.evaluateStarImportConflicts(monitor);
            }
            int nPackageEntries = this.fPackageEntries.size();
            for (int i = 0; i < nPackageEntries; ++i) {
                PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i);
                int nImports = pack.getNumberOfImports();
                if (this.fFilterImplicitImports && ImportsStructure.isImplicitImport(pack.getName(), this.fCompilationUnit)) {
                    pack.removeAllNew();
                    nImports = pack.getNumberOfImports();
                }
                if (nImports == 0) continue;
                if (useSpaceBetween && lastPackage != null && !pack.isComment() && !pack.isSameGroup(lastPackage)) {
                    ImportDeclEntry last = lastPackage.getImportAt(lastPackage.getNumberOfImports() - 1);
                    ImportDeclEntry first = pack.getImportAt(0);
                    if (!lastPackage.isComment() && (last.isNew() || first.isNew())) {
                        buf.append(lineDelim);
                    }
                }
                lastPackage = pack;
                boolean doStarImport = pack.hasStarImport(this.fImportOnDemandThreshold, onDemandConflicts);
                if (doStarImport && pack.find("*") == null) {
                    String starImportString = pack.getName() + ".*";
                    this.appendImportToBuffer(buf, starImportString, lineDelim);
                    ++nCreated;
                }
                for (int k = 0; k < nImports; ++k) {
                    ImportDeclEntry currDecl = pack.getImportAt(k);
                    String content = currDecl.getContent();
                    if (content == null) {
                        if (doStarImport && !currDecl.isOnDemand() && (onDemandConflicts == null || !onDemandConflicts.contains(currDecl.getSimpleName()))) continue;
                        this.appendImportToBuffer(buf, currDecl.getElementName(), lineDelim);
                        ++nCreated;
                        continue;
                    }
                    buf.append(content);
                }
            }
            if (importsLen == 0 && nCreated > 0) {
                IType[] types;
                if (this.fCompilationUnit.getPackageDeclarations().length > 0) {
                    buf.insert(0, lineDelim);
                }
                if ((types = this.fCompilationUnit.getTypes()).length > 0 && types[0].getSourceRange().getOffset() == importsStart) {
                    buf.append(lineDelim);
                }
            }
            this.fNumberOfImportsCreated = nCreated;
            String newContent = buf.toString();
            String oldContent = document.get(importsStart, importsLen);
            MultiTextEdit multiTextEdit = this.getTextEdit(oldContent, importsStart, newContent);
            return multiTextEdit;
        }
        finally {
            monitor.done();
        }
    }

    private MultiTextEdit getTextEdit(String oldContent, int offset, String newContent) {
        MultiTextEdit edit = new MultiTextEdit();
        JavaTokenComparator leftSide = new JavaTokenComparator(newContent, false);
        JavaTokenComparator rightSide = new JavaTokenComparator(oldContent, false);
        RangeDifference[] differences = RangeDifferencer.findRanges((IRangeComparator)leftSide, (IRangeComparator)rightSide);
        for (int i = 0; i < differences.length; ++i) {
            RangeDifference curr = differences[i];
            if (curr.kind() != 2) continue;
            int oldStart = rightSide.getTokenStart(curr.rightStart());
            int oldEnd = rightSide.getTokenStart(curr.rightEnd());
            int newStart = leftSide.getTokenStart(curr.leftStart());
            int newEnd = leftSide.getTokenStart(curr.leftEnd());
            String newString = newContent.substring(newStart, newEnd);
            edit.addChild((TextEdit)new ReplaceEdit(offset + oldStart, oldEnd - oldStart, newString));
        }
        return edit;
    }

    private boolean useSpaceBetweenGroups() {
        try {
            String sample = "import a.A;\n\n import b.B;\nclass C {}";
            TextEdit res = CodeFormatterUtil.format2(8, sample, 0, String.valueOf('\n'), this.fCompilationUnit.getJavaProject().getOptions(true));
            Document doc = new Document(sample);
            res.apply((IDocument)doc);
            int idx1 = doc.search(0, "import", true, true, false);
            int line1 = doc.getLineOfOffset(idx1);
            int idx2 = doc.search(idx1 + 1, "import", true, true, false);
            int line2 = doc.getLineOfOffset(idx2);
            return line2 - line1 > 1;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    private Set evaluateStarImportConflicts(IProgressMonitor monitor) {
        int i;
        int nPackageEntries = this.fPackageEntries.size();
        HashSet<String> starImportPackages = new HashSet<String>(nPackageEntries);
        for (int i2 = 0; i2 < nPackageEntries; ++i2) {
            PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i2);
            if (!pack.hasStarImport(this.fImportOnDemandThreshold, null)) continue;
            starImportPackages.add(pack.getName());
        }
        if (starImportPackages.isEmpty()) {
            return null;
        }
        starImportPackages.add(this.fCompilationUnit.getParent().getElementName());
        starImportPackages.add(JAVA_LANG);
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        if (allTypes.length < 2) {
            return null;
        }
        HashSet<String> onDemandConflicts = new HashSet<String>();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fCompilationUnit.getJavaProject()});
        String curr = allTypes[0].getTypeName();
        int offset = 0;
        for (i = 1; i < allTypes.length; ++i) {
            String name = allTypes[i].getTypeName();
            if (name.equals(curr)) continue;
            if (i - offset > 1 && this.isConflictingTypeName(allTypes, offset, i, starImportPackages, scope)) {
                onDemandConflicts.add(curr);
            }
            curr = name;
            offset = i;
        }
        if (i - offset > 1 && this.isConflictingTypeName(allTypes, offset, i, starImportPackages, scope)) {
            onDemandConflicts.add(curr);
        }
        return onDemandConflicts;
    }

    private boolean isConflictingTypeName(TypeInfo[] allTypes, int start, int end, HashSet starImportPackages, IJavaSearchScope scope) {
        String conflictingContainer = null;
        for (int i = start; i < end; ++i) {
            TypeInfo curr = allTypes[i];
            String containerName = curr.getTypeContainerName();
            if (containerName.equals(conflictingContainer) || !starImportPackages.contains(containerName) || !curr.isEnclosed(scope)) continue;
            if (conflictingContainer != null) {
                return true;
            }
            conflictingContainer = containerName;
        }
        return false;
    }

    private void appendImportToBuffer(StringBuffer buf, String importName, String lineDelim) {
        String str = "import " + importName + ';' + lineDelim;
        buf.append(str);
    }

    private int getPackageStatementEndPos(IDocument document) throws JavaModelException, BadLocationException {
        ISourceRange range;
        int line;
        IRegion region;
        IPackageDeclaration[] packDecls = this.fCompilationUnit.getPackageDeclarations();
        if (packDecls != null && packDecls.length > 0 && (region = document.getLineInformation((line = document.getLineOfOffset((range = packDecls[0].getSourceRange()).getOffset() + range.getLength())) + 1)) != null) {
            IType[] types = this.fCompilationUnit.getTypes();
            if (types.length > 0) {
                return Math.min(types[0].getSourceRange().getOffset(), region.getOffset());
            }
            return region.getOffset();
        }
        return 0;
    }

    public String toString() {
        int nPackages = this.fPackageEntries.size();
        StringBuffer buf = new StringBuffer("\n-----------------------\n");
        for (int i = 0; i < nPackages; ++i) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            buf.append(entry.toString());
        }
        return buf.toString();
    }

    public int getNumberOfImportsCreated() {
        return this.fNumberOfImportsCreated;
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    private static final class PackageEntry {
        private String fName;
        private ArrayList fImportEntries;
        private String fGroup;

        public PackageEntry() {
            this("!", null);
        }

        public PackageEntry(String name) {
            this(name, name);
        }

        public PackageEntry(String name, String group) {
            this.fName = name;
            this.fImportEntries = new ArrayList(5);
            this.fGroup = group;
        }

        public int findInsertPosition(String fullImportName) {
            int nInports = this.fImportEntries.size();
            for (int i = 0; i < nInports; ++i) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isComment() || fullImportName.compareTo(curr.getElementName()) > 0) continue;
                return i;
            }
            return nInports;
        }

        public void sortIn(ImportDeclEntry imp) {
            String fullImportName = imp.getElementName();
            int insertPosition = -1;
            int nInports = this.fImportEntries.size();
            for (int i = 0; i < nInports; ++i) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isComment()) continue;
                int cmp = fullImportName.compareTo(curr.getElementName());
                if (cmp == 0) {
                    return;
                }
                if (cmp >= 0 || insertPosition != -1) continue;
                insertPosition = i;
            }
            if (insertPosition == -1) {
                this.fImportEntries.add(imp);
            } else {
                this.fImportEntries.add(insertPosition, imp);
            }
        }

        public void add(ImportDeclEntry imp) {
            this.fImportEntries.add(imp);
        }

        public ImportDeclEntry find(String simpleName) {
            int nInports = this.fImportEntries.size();
            for (int i = 0; i < nInports; ++i) {
                int dotPos;
                String name;
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isComment() || !(name = curr.getElementName()).endsWith(simpleName) || (dotPos = name.length() - simpleName.length() - 1) != -1 && (dotPos <= 0 || name.charAt(dotPos) != '.')) continue;
                return curr;
            }
            return null;
        }

        public boolean remove(String fullName) {
            int nInports = this.fImportEntries.size();
            for (int i = 0; i < nInports; ++i) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isComment() || !fullName.equals(curr.getElementName())) continue;
                this.fImportEntries.remove(i);
                return true;
            }
            return false;
        }

        public void removeAllNew() {
            int nInports = this.fImportEntries.size();
            for (int i = nInports - 1; i >= 0; --i) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isNew()) continue;
                this.fImportEntries.remove(i);
            }
        }

        public ImportDeclEntry getImportAt(int index) {
            return (ImportDeclEntry)this.fImportEntries.get(index);
        }

        public boolean hasStarImport(int threshold, Set explicitImports) {
            if (this.isComment() || this.isDefaultPackage()) {
                return false;
            }
            int nImports = this.getNumberOfImports();
            int count = 0;
            boolean containsNew = false;
            for (int i = 0; i < nImports; ++i) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isOnDemand()) {
                    return true;
                }
                if (curr.isComment()) continue;
                ++count;
                boolean isExplicit = explicitImports != null && explicitImports.contains(curr.getSimpleName());
                containsNew |= curr.isNew() && !isExplicit;
            }
            return count >= threshold && containsNew;
        }

        public int getNumberOfImports() {
            return this.fImportEntries.size();
        }

        public String getName() {
            return this.fName;
        }

        public String getGroupID() {
            return this.fGroup;
        }

        public void setGroupID(String groupID) {
            this.fGroup = groupID;
        }

        public boolean isSameGroup(PackageEntry other) {
            if (this.fGroup == null) {
                return other.getGroupID() == null;
            }
            return this.fGroup.equals(other.getGroupID());
        }

        public ImportDeclEntry getLast() {
            int nImports = this.getNumberOfImports();
            if (nImports > 0) {
                return this.getImportAt(nImports - 1);
            }
            return null;
        }

        public boolean isComment() {
            return "!".equals(this.fName);
        }

        public boolean isDefaultPackage() {
            return this.fName.length() == 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.isComment()) {
                buf.append("comment\n");
            } else {
                buf.append(this.fName);
                buf.append(", groupId: ");
                buf.append(this.fGroup);
                buf.append("\n");
                int nImports = this.getNumberOfImports();
                for (int i = 0; i < nImports; ++i) {
                    ImportDeclEntry curr = this.getImportAt(i);
                    buf.append("  ");
                    buf.append(curr.getSimpleName());
                    if (curr.isNew()) {
                        buf.append(" (new)");
                    }
                    buf.append("\n");
                }
            }
            return buf.toString();
        }
    }

    private static final class ImportDeclEntry {
        private String fElementName;
        private String fContent;

        public ImportDeclEntry(String elementName, String existingContent) {
            this.fElementName = elementName;
            this.fContent = existingContent;
        }

        public String getElementName() {
            return this.fElementName;
        }

        public String getSimpleName() {
            return Signature.getSimpleName((String)this.fElementName);
        }

        public boolean isOnDemand() {
            return this.fElementName != null && this.fElementName.endsWith(".*");
        }

        public boolean isNew() {
            return this.fContent == null;
        }

        public boolean isComment() {
            return this.fElementName == null;
        }

        public String getContent() {
            return this.fContent;
        }
    }

    public static class PackageMatcher {
        private String fNewName;
        private String fBestName;
        private int fBestMatchLen;

        public void initialize(String newName, String bestName) {
            this.fNewName = newName;
            this.fBestName = bestName;
            this.fBestMatchLen = ImportsStructure.getCommonPrefixLength(bestName, this.fNewName);
        }

        public boolean isBetterMatch(String currName, boolean preferCurr) {
            boolean isBetter;
            int currMatchLen = ImportsStructure.getCommonPrefixLength(currName, this.fNewName);
            int matchDiff = currMatchLen - this.fBestMatchLen;
            if (matchDiff == 0) {
                isBetter = currMatchLen == this.fNewName.length() && currMatchLen == currName.length() && currMatchLen == this.fBestName.length() ? preferCurr : this.sameMatchLenTest(currName);
            } else {
                boolean bl = isBetter = matchDiff > 0;
            }
            if (isBetter) {
                this.fBestName = currName;
                this.fBestMatchLen = currMatchLen;
            }
            return isBetter;
        }

        private boolean sameMatchLenTest(String currName) {
            int matchLen = this.fBestMatchLen;
            char newChar = ImportsStructure.getCharAt(this.fNewName, matchLen);
            char currChar = ImportsStructure.getCharAt(currName, matchLen);
            char bestChar = ImportsStructure.getCharAt(this.fBestName, matchLen);
            if (newChar < currChar) {
                if (bestChar < newChar) {
                    return currChar - newChar < newChar - bestChar;
                }
                if (currChar == bestChar) {
                    return false;
                }
                return currChar < bestChar;
            }
            if (bestChar > newChar) {
                return newChar - currChar < bestChar - newChar;
            }
            if (currChar == bestChar) {
                return true;
            }
            return currChar > bestChar;
        }
    }
}

