/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.Change;

abstract class PackageReorgChange
extends JDTChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;

    PackageReorgChange(IPackageFragment pack, IPackageFragmentRoot dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaModelException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 1);
        try {
            Change change = this.doPerformReorg(pm);
            return change;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IPackageFragmentRoot getDestination() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fDestinationHandle);
    }

    IPackageFragment getPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fPackageHandle);
    }

    String getNewName() {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }
}

