/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class TextChangeCompatibility {
    public static void addTextEdit(TextChange change, String name, TextEdit edit) {
        Assert.isNotNull(change);
        Assert.isNotNull(name);
        Assert.isNotNull(edit);
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        TextChangeCompatibility.insert(root, edit);
        change.addTextEditGroup(new TextEditGroup(name, edit));
    }

    public static void addTextEdit(TextChange change, String name, TextEdit[] edits) {
        Assert.isNotNull(change);
        Assert.isNotNull(name);
        Assert.isNotNull(edits);
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        for (int i = 0; i < edits.length; ++i) {
            TextChangeCompatibility.insert(root, edits[i]);
        }
        change.addTextEditGroup(new TextEditGroup(name, edits));
    }

    private static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        int i;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!TextChangeCompatibility.covers(child, edit)) continue;
            TextChangeCompatibility.insert(child, edit);
            return;
        }
        for (i = children.length - 1; i >= 0; --i) {
            child = children[i];
            if (!TextChangeCompatibility.covers(edit, child)) continue;
            parent.removeChild(i);
            edit.addChild(child);
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

