/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.JavaElementCommentFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.RefactoringWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractInterfaceRefactoring
extends Refactoring {
    public static final boolean DEFAULT_DECLARE_METHODS_PUBLIC = true;
    public static final boolean DEFAULT_DECLARE_METHODS_ABSTRACT = true;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private IType fInputType;
    private String fNewInterfaceName;
    private IMember[] fExtractedMembers;
    private boolean fReplaceOccurrences = false;
    private boolean fMarkInterfaceMethodsAsPublic = true;
    private boolean fMarkInterfaceMethodsAsAbstract = true;
    private TextChangeManager fChangeManager;
    private final WorkingCopyOwner fWorkingCopyOwner;
    private String fSource;

    private ExtractInterfaceRefactoring(IType type, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(type);
        Assert.isNotNull(codeGenerationSettings);
        this.fInputType = type;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fExtractedMembers = new IMember[0];
        this.fWorkingCopyOwner = new RefactoringWorkingCopyOwner();
    }

    public static ExtractInterfaceRefactoring create(IType type, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        if (!ExtractInterfaceRefactoring.isAvailable(type)) {
            return null;
        }
        return new ExtractInterfaceRefactoring(type, codeGenerationSettings);
    }

    public static boolean isAvailable(IType type) throws JavaModelException {
        if (!Checks.isAvailable((IJavaElement)type)) {
            return false;
        }
        return Checks.isTopLevel(type);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.name");
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public String getNewInterfaceName() {
        return this.fNewInterfaceName;
    }

    public boolean isReplaceOccurrences() {
        return this.fReplaceOccurrences;
    }

    public boolean getMarkInterfaceMethodsAsPublic() {
        return this.fMarkInterfaceMethodsAsPublic;
    }

    public boolean getMarkInterfaceMethodsAsAbstract() {
        return this.fMarkInterfaceMethodsAsAbstract;
    }

    public void setNewInterfaceName(String newInterfaceName) {
        Assert.isNotNull(newInterfaceName);
        this.fNewInterfaceName = newInterfaceName;
    }

    public void setReplaceOccurrences(boolean replaceOccurrences) {
        this.fReplaceOccurrences = replaceOccurrences;
    }

    public void setMarkInterfaceMethodsAsPublic(boolean mark) {
        this.fMarkInterfaceMethodsAsPublic = mark;
    }

    public void setMarkInterfaceMethodsAsAbstract(boolean mark) {
        this.fMarkInterfaceMethodsAsAbstract = mark;
    }

    public void setExtractedMembers(IMember[] extractedMembers) throws JavaModelException {
        Assert.isTrue(this.areAllExtractableMembersOfClass(extractedMembers));
        this.fExtractedMembers = extractedMembers;
    }

    public IMember[] getExtractableMembers() throws JavaModelException {
        ArrayList<IJavaElement> members = new ArrayList<IJavaElement>();
        IJavaElement[] children = this.fInputType.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IMember) || !ExtractInterfaceRefactoring.isExtractableMember((IMember)children[i])) continue;
            members.add(children[i]);
        }
        return members.toArray(new IMember[members.size()]);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fInputType);
        if (orig == null || !orig.exists()) {
            String[] keys = new String[]{this.getInputTypeCU().getElementName()};
            String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.deleted", keys);
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        if (Checks.isException(this.fInputType, pm)) {
            String message = RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.no_Throwable");
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return Checks.checkIfCuBroken((IMember)this.fInputType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkNewInterfaceName(this.fNewInterfaceName));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.validateModifiesFiles());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInterfaceTypeName() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.getInputClassPackage(), this.fNewInterfaceName);
        if (type == null || !type.exists()) {
            return null;
        }
        String[] keys = new String[]{this.fNewInterfaceName, this.getInputClassPackage().getElementName()};
        String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.type_exists", keys);
        return RefactoringStatus.createFatalErrorStatus((String)message);
    }

    public RefactoringStatus checkNewInterfaceName(String newName) {
        try {
            RefactoringStatus result = Checks.checkTypeName(newName);
            if (result.hasFatalError()) {
                return result;
            }
            result.merge(Checks.checkCompilationUnitName(newName + ".java"));
            if (result.hasFatalError()) {
                return result;
            }
            if (this.getInputClassPackage().getCompilationUnit(this.getCuNameForNewInterface()).exists()) {
                String[] keys = new String[]{this.getCuNameForNewInterface(), this.getInputClassPackage().getElementName()};
                String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.compilation_Unit_exists", keys);
                result.addFatalError(message);
                return result;
            }
            result.merge(this.checkInterfaceTypeName());
            return result;
        }
        catch (JavaModelException e) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.internal_Error"));
        }
    }

    private IFile[] getAllFilesToModify() {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.name"));
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            result.add(this.createExtractedInterface((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextChangeManager createChangeManager(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        TextChangeManager textChangeManager;
        ICompilationUnit typeCu;
        block14: {
            CompilationUnitRange[] updatedRanges;
            TextChange change;
            TextEditGroup description;
            TextChangeManager manager;
            ICompilationUnit newCuWC;
            block12: {
                TextChangeManager textChangeManager2;
                block13: {
                    IType theType;
                    block10: {
                        TextChangeManager textChangeManager3;
                        block11: {
                            newCuWC = null;
                            typeCu = null;
                            pm.beginTask("", 10);
                            pm.setTaskName(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.analyzing..."));
                            manager = new TextChangeManager(true);
                            typeCu = WorkingCopyUtil.getNewWorkingCopy(this.getInputTypeCU(), this.fWorkingCopyOwner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            ASTParser p = ASTParser.newParser((int)2);
                            p.setSource(typeCu);
                            p.setResolveBindings(true);
                            p.setWorkingCopyOwner(this.fWorkingCopyOwner);
                            p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)typeCu));
                            CompilationUnit typeCuNode = (CompilationUnit)p.createAST(null);
                            OldASTRewrite typeCuRewrite = new OldASTRewrite((ASTNode)typeCuNode);
                            theType = (IType)JavaModelUtil.findInCompilationUnit(typeCu, (IJavaElement)this.fInputType);
                            TypeDeclaration td = ASTNodeSearchUtil.getTypeDeclarationNode(theType, typeCuNode);
                            this.modifyInputTypeCu(typeCu, typeCuNode, typeCuRewrite, td);
                            description = this.trackReferenceNodes(typeCuNode, typeCuRewrite, td);
                            change = ExtractInterfaceRefactoring.addTextEditFromRewrite(manager, typeCu, typeCuRewrite);
                            if (this.fReplaceOccurrences) break block10;
                            textChangeManager3 = manager;
                            Object var25_15 = null;
                            if (newCuWC == null) break block11;
                            newCuWC.discardWorkingCopy();
                        }
                        if (typeCu != null) {
                            typeCu.discardWorkingCopy();
                        }
                        pm.done();
                        return textChangeManager3;
                    }
                    ExtractInterfaceRefactoring.setContent(typeCu, change.getPreviewContent((IProgressMonitor)new NullProgressMonitor()));
                    newCuWC = WorkingCopyUtil.getNewWorkingCopy(this.getInputClassPackage(), this.getCuNameForNewInterface(), this.fWorkingCopyOwner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    ExtractInterfaceRefactoring.setContent(newCuWC, this.createExtractedInterfaceCUSource(newCuWC, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    IType theInterface = newCuWC.getType(this.fNewInterfaceName);
                    updatedRanges = ExtractInterfaceUtil.updateReferences(manager, theType, theInterface, this.fWorkingCopyOwner, false, (IProgressMonitor)new SubProgressMonitor(pm, 9), status, this.fCodeGenerationSettings);
                    if (!status.hasFatalError()) break block12;
                    textChangeManager2 = manager;
                    Object var25_16 = null;
                    if (newCuWC == null) break block13;
                    newCuWC.discardWorkingCopy();
                }
                if (typeCu != null) {
                    typeCu.discardWorkingCopy();
                }
                pm.done();
                return textChangeManager2;
            }
            try {
                TextEdit[] edits = description.getTextEdits();
                for (int i = 0; i < updatedRanges.length; ++i) {
                    CompilationUnitRange cuRange = updatedRanges[i];
                    ICompilationUnit cu = cuRange.getCompilationUnit();
                    if (!cu.equals(typeCu)) continue;
                    ISourceRange sourceRange = cuRange.getSourceRange();
                    IRegion oldRange = ExtractInterfaceRefactoring.getOldRange(edits, (IRegion)new Region(sourceRange.getOffset(), sourceRange.getLength()), change);
                    String typeName = this.fInputType.getElementName();
                    int offset = oldRange.getOffset() + oldRange.getLength() - typeName.length();
                    ReplaceEdit edit = new ReplaceEdit(offset, typeName.length(), this.fNewInterfaceName);
                    TextChangeCompatibility.addTextEdit(ExtractInterfaceUtil.getTextChange(manager, cu), RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.update_reference"), (TextEdit)edit);
                }
                this.fSource = ExtractInterfaceUtil.getTextChange(manager, newCuWC).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
                manager.remove(newCuWC);
                textChangeManager = manager;
                Object var25_17 = null;
                if (newCuWC == null) break block14;
            }
            catch (Throwable throwable) {
                Object var25_18 = null;
                if (newCuWC != null) {
                    newCuWC.discardWorkingCopy();
                }
                if (typeCu != null) {
                    typeCu.discardWorkingCopy();
                }
                pm.done();
                throw throwable;
            }
            newCuWC.discardWorkingCopy();
        }
        if (typeCu != null) {
            typeCu.discardWorkingCopy();
        }
        pm.done();
        return textChangeManager;
    }

    private void modifyInputTypeCu(ICompilationUnit typeCu, CompilationUnit typeCuNode, OldASTRewrite typeCuRewrite, TypeDeclaration td) throws CoreException, JavaModelException {
        this.deleteExtractedFields(typeCuNode, typeCu, typeCuRewrite);
        if (this.fInputType.isInterface()) {
            this.deleteExtractedMethods(typeCuNode, typeCu, typeCuRewrite);
        }
        SimpleName newInterfaceName = td.getAST().newSimpleName(this.fNewInterfaceName);
        td.superInterfaces().add(newInterfaceName);
        typeCuRewrite.markAsInserted((ASTNode)newInterfaceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setContent(ICompilationUnit cu, String newContent) throws JavaModelException {
        cu.getBuffer().setContents(newContent);
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile();
        }
    }

    private TextEditGroup trackReferenceNodes(CompilationUnit typeCuNode, OldASTRewrite typeCuRewrite, TypeDeclaration td) {
        ASTNode[] refs = ExtractInterfaceRefactoring.getReferencesToType(typeCuNode, td.resolveBinding());
        TextEditGroup description = new TextEditGroup("N.N");
        for (int i = 0; i < refs.length; ++i) {
            typeCuRewrite.markAsTracked(refs[i], description);
        }
        return description;
    }

    private static IRegion getOldRange(TextEdit[] edits, IRegion newRange, TextChange change) {
        for (int i = 0; i < edits.length; ++i) {
            TextEdit edit = edits[i];
            if (!change.getPreviewEdit(edit).getRegion().equals(newRange)) continue;
            return edit.getRegion();
        }
        Assert.isTrue(false, "original text range not found");
        return newRange;
    }

    private static ASTNode[] getReferencesToType(CompilationUnit typeCuNode, final ITypeBinding binding) {
        final HashSet result = new HashSet();
        typeCuNode.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (node.resolveBinding() == binding) {
                    result.add(node);
                }
                return super.visit(node);
            }
        });
        return result.toArray(new ASTNode[result.size()]);
    }

    private static TextChange addTextEditFromRewrite(TextChangeManager manager, ICompilationUnit cu, OldASTRewrite rewrite) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(cu.getBuffer().getContents());
        MultiTextEdit resultingEdits = new MultiTextEdit();
        rewrite.rewriteNode(textBuffer, (TextEdit)resultingEdits);
        TextChange textChange = manager.get(cu);
        TextChangeCompatibility.addTextEdit(textChange, RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.update_type_declaration"), (TextEdit)resultingEdits);
        rewrite.removeModifications();
        return textChange;
    }

    private void deleteExtractedMethods(CompilationUnit typeCuNode, ICompilationUnit cu, OldASTRewrite typeCuRewrite) throws CoreException {
        ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])this.getExtractedMethods(cu), typeCuNode, typeCuRewrite);
    }

    private void deleteExtractedFields(CompilationUnit typeCuNode, ICompilationUnit cu, OldASTRewrite typeCuRewrite) throws CoreException {
        ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])this.getExtractedFields(cu), typeCuNode, typeCuRewrite);
    }

    private boolean areAllExtractableMembersOfClass(IMember[] extractedMembers) throws JavaModelException {
        for (int i = 0; i < extractedMembers.length; ++i) {
            if (extractedMembers[i].getParent().equals(this.fInputType) && ExtractInterfaceRefactoring.isExtractableMember(extractedMembers[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isExtractableMember(IMember iMember) throws JavaModelException {
        switch (iMember.getElementType()) {
            case 9: {
                return ExtractInterfaceRefactoring.isExtractableMethod((IMethod)iMember);
            }
            case 8: {
                return ExtractInterfaceRefactoring.isExtractableField((IField)iMember);
            }
        }
        return false;
    }

    private static boolean isExtractableField(IField iField) throws JavaModelException {
        return JdtFlags.isPublic((IMember)iField) && JdtFlags.isStatic((IMember)iField) && JdtFlags.isFinal((IMember)iField);
    }

    private static boolean isExtractableMethod(IMethod iMethod) throws JavaModelException {
        return JdtFlags.isPublic((IMember)iMethod) && !JdtFlags.isStatic((IMember)iMethod) && !iMethod.isConstructor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Change createExtractedInterface(IProgressMonitor pm) throws CoreException {
        CreateTextFileChange createTextFileChange;
        block3: {
            pm.beginTask("", 1);
            IPath cuPath = ResourceUtil.getFile(this.getInputTypeCU()).getFullPath();
            IPath interfaceCuPath = cuPath.removeLastSegments(1).append(this.getCuNameForNewInterface());
            ICompilationUnit newCuWC = null;
            try {
                newCuWC = WorkingCopyUtil.getNewWorkingCopy(this.getInputClassPackage(), this.getCuNameForNewInterface(), this.fWorkingCopyOwner, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                Assert.isTrue(!this.fReplaceOccurrences || this.fSource != null);
                Assert.isTrue(this.fSource == null || this.fReplaceOccurrences);
                String formattedSource = this.fSource != null ? this.fSource : this.createExtractedInterfaceCUSource(newCuWC, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                createTextFileChange = new CreateTextFileChange(interfaceCuPath, formattedSource, null, "java");
                Object var8_7 = null;
                if (newCuWC == null) break block3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (newCuWC != null) {
                    newCuWC.discardWorkingCopy();
                }
                pm.done();
                throw throwable;
            }
            newCuWC.discardWorkingCopy();
        }
        pm.done();
        return createTextFileChange;
    }

    private String formatCuSource(String source) {
        return CodeFormatterUtil.format(8, source, 0, null, this.getLineSeperator(), this.fInputType.getJavaProject());
    }

    private String getCuNameForNewInterface() {
        return this.fNewInterfaceName + ".java";
    }

    private IPackageFragment getInputClassPackage() {
        return this.fInputType.getPackageFragment();
    }

    private String getLineSeperator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fInputType);
        }
        catch (JavaModelException e) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private String createExtractedInterfaceCUSource(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        CompilationUnit cuNode = new RefactoringASTParser(2).parse(this.getInputTypeCU(), true);
        String typeComment = CodeGeneration.getTypeComment(newCu, this.fNewInterfaceName, this.getLineSeperator());
        String compilationUnitContent = CodeGeneration.getCompilationUnitContent(newCu, typeComment, this.createInterfaceSource(cuNode), this.getLineSeperator());
        if (compilationUnitContent == null) {
            compilationUnitContent = "";
        }
        newCu.getBuffer().setContents(compilationUnitContent);
        this.addImportsToNewCu(newCu, pm, cuNode);
        return this.formatCuSource(newCu.getSource());
    }

    private void addImportsToNewCu(ICompilationUnit newCu, IProgressMonitor pm, CompilationUnit cuNode) throws CoreException {
        pm.beginTask("", 3);
        ImportsStructure is = new ImportsStructure(newCu, this.fCodeGenerationSettings.importOrder, this.fCodeGenerationSettings.importThreshold, true);
        this.addImportsToTypesReferencedInMethodDeclarations(is, (IProgressMonitor)new SubProgressMonitor(pm, 1), cuNode);
        this.addImportsToTypesReferencedInFieldDeclarations(is, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        is.create(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private String createInterfaceSource(CompilationUnit cuNode) throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.createInterfaceModifierString()).append("interface ").append(this.fNewInterfaceName).append(" {").append(this.getLineSeperator()).append(this.createInterfaceMemberDeclarationsSource(cuNode)).append("}");
        return buff.toString();
    }

    private String createInterfaceModifierString() throws JavaModelException {
        if (JdtFlags.isPublic((IMember)this.fInputType)) {
            return "public ";
        }
        return "";
    }

    private String createInterfaceMemberDeclarationsSource(CompilationUnit cuNode) throws JavaModelException {
        if (this.fExtractedMembers.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        ExtractInterfaceRefactoring.sortByOffset(this.fExtractedMembers);
        for (int i = 0; i < this.fExtractedMembers.length; ++i) {
            buff.append(this.createInterfaceMemberDeclarationsSource(this.fExtractedMembers[i], cuNode));
            if (i == this.fExtractedMembers.length - 1) continue;
            buff.append(this.getLineSeperator());
        }
        return buff.toString();
    }

    private static void sortByOffset(IMember[] members) {
        Arrays.sort(members, new Comparator(){

            public int compare(Object o1, Object o2) {
                ISourceReference sr1 = (ISourceReference)o1;
                ISourceReference sr2 = (ISourceReference)o2;
                try {
                    return sr1.getSourceRange().getOffset() - sr2.getSourceRange().getOffset();
                }
                catch (JavaModelException e) {
                    return o1.hashCode() - o2.hashCode();
                }
            }
        });
    }

    private String createInterfaceMemberDeclarationsSource(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        Assert.isTrue(iMember.getElementType() == 8 || iMember.getElementType() == 9);
        if (iMember.getElementType() == 8) {
            return this.createInterfaceFieldDeclarationSource((IField)iMember);
        }
        return this.createInterfaceMethodDeclarationsSource((IMethod)iMember, cuNode);
    }

    private String createInterfaceFieldDeclarationSource(IField iField) throws JavaModelException {
        return SourceRangeComputer.computeSource((ISourceReference)iField);
    }

    private String createInterfaceMethodDeclarationsSource(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        if (this.fInputType.isInterface()) {
            return SourceRangeComputer.computeSource((ISourceReference)iMethod);
        }
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, cuNode);
        if (methodDeclaration == null) {
            return "";
        }
        int methodDeclarationOffset = methodDeclaration.getReturnType().getStartPosition();
        int length = ExtractInterfaceRefactoring.getMethodDeclarationLength(iMethod, methodDeclaration);
        StringBuffer methodDeclarationSource = new StringBuffer();
        methodDeclarationSource.append(ExtractInterfaceRefactoring.getCommentContent(iMethod));
        if (this.fMarkInterfaceMethodsAsPublic) {
            methodDeclarationSource.append("public ");
        }
        if (this.fMarkInterfaceMethodsAsAbstract) {
            methodDeclarationSource.append("abstract ");
        }
        methodDeclarationSource.append(iMethod.getCompilationUnit().getBuffer().getText(methodDeclarationOffset, length));
        if (methodDeclaration.getBody() != null) {
            methodDeclarationSource.append(";");
        }
        return methodDeclarationSource.toString();
    }

    private static String getCommentContent(IMethod iMethod) throws JavaModelException {
        String rawContent = JavaElementCommentFinder.getCommentContent((IMember)iMethod);
        if (rawContent == null) {
            return "";
        }
        String[] lines = Strings.convertIntoLines(rawContent);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)iMethod));
    }

    private static int getMethodDeclarationLength(IMethod iMethod, MethodDeclaration methodDeclaration) throws JavaModelException {
        int preDeclarationSourceLength = methodDeclaration.getReturnType().getStartPosition() - iMethod.getSourceRange().getOffset();
        if (methodDeclaration.getBody() == null) {
            return iMethod.getSourceRange().getLength() - preDeclarationSourceLength;
        }
        return iMethod.getSourceRange().getLength() - methodDeclaration.getBody().getLength() - preDeclarationSourceLength;
    }

    private IField[] getExtractedFields(ICompilationUnit cu) {
        ArrayList<IJavaElement> fields = new ArrayList<IJavaElement>();
        for (int i = 0; i < this.fExtractedMembers.length; ++i) {
            IJavaElement element;
            if (!(this.fExtractedMembers[i] instanceof IField) || !((element = JavaModelUtil.findInCompilationUnit(cu, (IJavaElement)this.fExtractedMembers[i])) instanceof IField)) continue;
            fields.add(element);
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private IMethod[] getExtractedMethods(ICompilationUnit cu) {
        ArrayList<IJavaElement> methods = new ArrayList<IJavaElement>();
        for (int i = 0; i < this.fExtractedMembers.length; ++i) {
            IJavaElement element;
            if (!(this.fExtractedMembers[i] instanceof IMethod) || !((element = JavaModelUtil.findInCompilationUnit(cu, (IJavaElement)this.fExtractedMembers[i])) instanceof IMethod)) continue;
            methods.add(element);
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private void addImportsToTypesReferencedInFieldDeclarations(ImportsStructure is, IProgressMonitor pm) throws JavaModelException {
        IType[] referencedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.getExtractedFields(this.getInputTypeCU()), pm);
        for (int i = 0; i < referencedTypes.length; ++i) {
            is.addImport(JavaModelUtil.getFullyQualifiedName(referencedTypes[i]));
        }
    }

    private void addImportsToTypesReferencedInMethodDeclarations(ImportsStructure is, IProgressMonitor pm, CompilationUnit cuNode) throws JavaModelException {
        ITypeBinding[] typesUsed = this.getTypesUsedInExtractedMethodDeclarations(cuNode);
        pm.beginTask("", typesUsed.length);
        for (int i = 0; i < typesUsed.length; ++i) {
            is.addImport(typesUsed[i]);
            pm.worked(1);
        }
        pm.done();
    }

    private ITypeBinding[] getTypesUsedInExtractedMethodDeclarations(CompilationUnit cuNode) throws JavaModelException {
        return this.getTypesReferencedInDeclarations(this.getExtractedMethods(this.getInputTypeCU()), cuNode);
    }

    private ICompilationUnit getInputTypeCU() {
        return this.fInputType.getCompilationUnit();
    }

    public ITypeBinding[] getTypesReferencedInDeclarations(IMethod[] methods, CompilationUnit cuNode) throws JavaModelException {
        HashSet typesUsed = new HashSet();
        for (int i = 0; i < methods.length; ++i) {
            typesUsed.addAll(this.getTypesUsedInDeclaration(methods[i], cuNode));
        }
        return typesUsed.toArray(new ITypeBinding[typesUsed.size()]);
    }

    public Set getTypesUsedInDeclaration(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        return ReferenceFinderUtil.getTypesUsedInDeclaration(ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, cuNode));
    }
}

