/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;

public class TypeConstraintFactory
implements ITypeConstraintFactory {
    private Map fSimpleConstraints = new HashMap();
    private Map fOrConstraints = new HashMap();
    protected static final boolean PRINT_STATS = false;
    protected int fNrCreated = 0;
    protected int fNrFiltered = 0;
    protected int fNrRetrieved = 0;

    private SimpleTypeConstraint createSimpleTypeConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        if (this.fSimpleConstraints.containsKey(v1)) {
            Map m2 = (Map)this.fSimpleConstraints.get(v1);
            if (m2.containsKey(v2)) {
                Map m3 = (Map)m2.get(v2);
                if (m3.containsKey(operator)) {
                    return (SimpleTypeConstraint)m3.get(operator);
                }
                return this.storeConstraint(v1, v2, operator, m3);
            }
            HashMap m3 = new HashMap();
            m2.put(v2, m3);
            return this.storeConstraint(v1, v2, operator, m3);
        }
        HashMap m2 = new HashMap();
        this.fSimpleConstraints.put(v1, m2);
        HashMap m3 = new HashMap();
        m2.put(v2, m3);
        return this.storeConstraint(v1, v2, operator, m3);
    }

    private SimpleTypeConstraint storeConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator, Map m3) {
        SimpleTypeConstraint constraint = new SimpleTypeConstraint(v1, v2, operator);
        m3.put(operator, constraint);
        return constraint;
    }

    public ITypeConstraint[] createConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        if (this.filter(v1, v2, operator)) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{this.createSimpleTypeConstraint(v1, v2, operator)};
    }

    public ITypeConstraint[] createSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createSubTypeOperator());
    }

    public ITypeConstraint[] createStrictSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createStrictSubtypeOperator());
    }

    public ITypeConstraint[] createEqualsConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createEqualsOperator());
    }

    public ITypeConstraint[] createDefinesConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createDefinesOperator());
    }

    public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        return v1.getBinding() != null && v1.getBinding().isPrimitive() || v1 == v2;
    }

    public CompositeOrTypeConstraint createCompositeOrTypeConstraint(ITypeConstraint[] constraints) {
        CompositeOrTypeConstraint constraint;
        ConstraintVariable left = ((SimpleTypeConstraint)constraints[0]).getLeft();
        String bounds = "";
        for (int i = 0; i < constraints.length; ++i) {
            ConstraintVariable right = ((SimpleTypeConstraint)constraints[i]).getRight();
            ITypeBinding binding = right.getBinding();
            String typeName = binding.getQualifiedName();
            bounds = bounds + typeName + ",";
        }
        if (this.fOrConstraints.containsKey(left)) {
            Map m2 = (Map)this.fOrConstraints.get(left);
            if (m2.containsKey(bounds)) {
                return (CompositeOrTypeConstraint)m2.get(bounds);
            }
            constraint = new CompositeOrTypeConstraint(constraints);
            m2.put(bounds, constraint);
            return constraint;
        }
        HashMap<String, CompositeOrTypeConstraint> m2 = new HashMap<String, CompositeOrTypeConstraint>();
        this.fOrConstraints.put(left, m2);
        constraint = new CompositeOrTypeConstraint(constraints);
        m2.put(bounds, constraint);
        return constraint;
    }

    protected void dumpStats() {
        System.out.println("Constraints: " + this.fNrCreated + " created, " + this.fNrRetrieved + " retrieved, " + this.fNrFiltered + " filtered");
    }
}

