/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new StaticFinalFieldHighlighting(), new StaticFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new AbstractMethodInvocationHighlighting(), new InheritedMethodInvocationHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new ParameterVariableHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("semanticHighlighting.enabled", false);
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int n = semanticHighlightings.length;
        for (int i = 0; i < n; ++i) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), (RGB)semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
        }
    }

    private SemanticHighlightings() {
    }

    private static class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.parameterVariable");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            ASTNode parent = token.getNode().getParent();
            if (!(binding == null || binding.getKind() != 3 || ((IVariableBinding)binding).isField() || parent != null && parent.getNodeType() == 65)) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl != null && decl.getNodeType() == 44;
            }
            return false;
        }
    }

    private static class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.localVariable");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl != null && decl.getNodeType() != 44;
            }
            return false;
        }
    }

    private static class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.localVariableDeclaration");
        }

        public boolean consumes(SemanticToken token) {
            ASTNode parent = token.getNode().getParent();
            return parent != null && parent.getNodeType() == 59;
        }
    }

    private static class InheritedMethodInvocationHighlighting
    extends SemanticHighlighting {
        private InheritedMethodInvocationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.INHERITED_METHOD_INVOCATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.inheritedMethodInvocation");
        }

        public boolean consumes(SemanticToken token) {
            ITypeBinding declaringType;
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding == null || binding.getKind() != 4) {
                return false;
            }
            ITypeBinding currentType = Bindings.getBindingOfParentType((ASTNode)node);
            if (currentType == (declaringType = ((IMethodBinding)binding).getDeclaringClass())) {
                return false;
            }
            return Bindings.isSuperType(declaringType, currentType);
        }
    }

    private static class AbstractMethodInvocationHighlighting
    extends SemanticHighlighting {
        private AbstractMethodInvocationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.ABSTRACT_METHOD_INVOCATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.abstractMethodInvocation");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 4 && (binding.getModifiers() & 0x400) == 1024;
        }
    }

    private static class StaticMethodInvocationHighlighting
    extends SemanticHighlighting {
        private StaticMethodInvocationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_METHOD_INVOCATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.staticMethodInvocation");
        }

        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 4 && (binding.getModifiers() & 8) == 8;
        }
    }

    private static class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.methodDeclaration");
        }

        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            ASTNode parent = node.getParent();
            return parent != null && parent.getNodeType() == 31 && node.isDeclaration();
        }
    }

    private static class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.FIELD;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.field");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField();
        }
    }

    private static class StaticFieldHighlighting
    extends SemanticHighlighting {
        private StaticFieldHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FIELD;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.staticField");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 8) == 8;
        }
    }

    private static class StaticFinalFieldHighlighting
    extends SemanticHighlighting {
        private StaticFinalFieldHighlighting() {
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FINAL_FIELD;
        }

        public RGB getDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return false;
        }

        public boolean isItalicByDefault() {
            return false;
        }

        public boolean isEnabledByDefault() {
            return false;
        }

        public String getDisplayName() {
            return JavaEditorMessages.getString("SemanticHighlighting.staticFinalField");
        }

        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 0x18) == 24;
        }
    }
}

