/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class AppearancePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String SHOW_CU_CHILDREN = "org.eclipse.jdt.ui.packages.cuchildren";
    private static final String PREF_METHOD_RETURNTYPE = "org.eclipse.jdt.ui.methodreturntype";
    private static final String PREF_COMPRESS_PACKAGE_NAMES = "org.eclipse.jdt.ui.compresspackagenames";
    private static final String PREF_PKG_NAME_PATTERN_FOR_PKG_VIEW = "PackagesView.pkgNamePatternForPackagesView";
    private static final String STACK_BROWSING_VIEWS_VERTICALLY = "org.eclipse.jdt.ui.browsing.stackVertically";
    private static final String PREF_FOLD_PACKAGES_IN_PACKAGE_EXPLORER = "org.eclipse.jdt.ui.flatPackagesInPackageExplorer";
    private SelectionButtonDialogField fShowMethodReturnType;
    private SelectionButtonDialogField fCompressPackageNames;
    private SelectionButtonDialogField fStackBrowsingViewsVertically;
    private SelectionButtonDialogField fShowMembersInPackageView;
    private StringDialogField fPackageNamePattern;
    private SelectionButtonDialogField fFoldPackagesInPackageExplorer;

    public AppearancePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("AppearancePreferencePage.description"));
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AppearancePreferencePage.this.doDialogFieldChanged(field);
            }
        };
        this.fShowMethodReturnType = new SelectionButtonDialogField(32);
        this.fShowMethodReturnType.setDialogFieldListener(listener);
        this.fShowMethodReturnType.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.methodreturntype.label"));
        this.fShowMembersInPackageView = new SelectionButtonDialogField(32);
        this.fShowMembersInPackageView.setDialogFieldListener(listener);
        this.fShowMembersInPackageView.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.showMembersInPackagesView"));
        this.fStackBrowsingViewsVertically = new SelectionButtonDialogField(32);
        this.fStackBrowsingViewsVertically.setDialogFieldListener(listener);
        this.fStackBrowsingViewsVertically.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.stackViewsVerticallyInTheJavaBrowsingPerspective"));
        this.fFoldPackagesInPackageExplorer = new SelectionButtonDialogField(32);
        this.fFoldPackagesInPackageExplorer.setDialogFieldListener(listener);
        this.fFoldPackagesInPackageExplorer.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.foldEmptyPackages"));
        this.fCompressPackageNames = new SelectionButtonDialogField(32);
        this.fCompressPackageNames.setDialogFieldListener(listener);
        this.fCompressPackageNames.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.pkgNamePatternEnable.label"));
        this.fPackageNamePattern = new StringDialogField();
        this.fPackageNamePattern.setDialogFieldListener(listener);
        this.fPackageNamePattern.setLabelText(PreferencesMessages.getString("AppearancePreferencePage.pkgNamePattern.label"));
    }

    private void initFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowMethodReturnType.setSelection(prefs.getBoolean(PREF_METHOD_RETURNTYPE));
        this.fShowMembersInPackageView.setSelection(prefs.getBoolean(SHOW_CU_CHILDREN));
        this.fStackBrowsingViewsVertically.setSelection(prefs.getBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
        this.fPackageNamePattern.setText(prefs.getString(PREF_PKG_NAME_PATTERN_FOR_PKG_VIEW));
        this.fCompressPackageNames.setSelection(prefs.getBoolean(PREF_COMPRESS_PACKAGE_NAMES));
        this.fPackageNamePattern.setEnabled(this.fCompressPackageNames.isSelected());
        this.fFoldPackagesInPackageExplorer.setSelection(prefs.getBoolean(PREF_FOLD_PACKAGES_IN_PACKAGE_EXPLORER));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.appearance_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int nColumns = 1;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.numColumns = nColumns;
        result.setLayout((Layout)layout);
        this.fShowMethodReturnType.doFillIntoGrid(result, nColumns);
        this.fShowMembersInPackageView.doFillIntoGrid(result, nColumns);
        this.fFoldPackagesInPackageExplorer.doFillIntoGrid(result, nColumns);
        new Separator().doFillIntoGrid(result, nColumns);
        this.fCompressPackageNames.doFillIntoGrid(result, nColumns);
        this.fPackageNamePattern.doFillIntoGrid(result, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPackageNamePattern.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fPackageNamePattern.getLabelControl(null), this.convertWidthInCharsToPixels(65));
        new Separator().doFillIntoGrid(result, nColumns);
        this.fStackBrowsingViewsVertically.doFillIntoGrid(result, nColumns);
        String noteTitle = PreferencesMessages.getString("AppearancePreferencePage.note");
        String noteMessage = PreferencesMessages.getString("AppearancePreferencePage.preferenceOnlyEffectiveForNewPerspectives");
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), result, noteTitle, noteMessage);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        noteControl.setLayoutData((Object)gd);
        this.initFields();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fCompressPackageNames) {
            this.fPackageNamePattern.setEnabled(this.fCompressPackageNames.isSelected());
        }
        this.updateStatus(this.getValidationStatus());
    }

    private IStatus getValidationStatus() {
        if (this.fCompressPackageNames.isSelected() && this.fPackageNamePattern.getText().equals("")) {
            return new StatusInfo(4, PreferencesMessages.getString("AppearancePreferencePage.packageNameCompressionPattern.error.isEmpty"));
        }
        return new StatusInfo();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IPreferenceStore prefs = this.getPreferenceStore();
        prefs.setValue(PREF_METHOD_RETURNTYPE, this.fShowMethodReturnType.isSelected());
        prefs.setValue(SHOW_CU_CHILDREN, this.fShowMembersInPackageView.isSelected());
        prefs.setValue(STACK_BROWSING_VIEWS_VERTICALLY, this.fStackBrowsingViewsVertically.isSelected());
        prefs.setValue(PREF_PKG_NAME_PATTERN_FOR_PKG_VIEW, this.fPackageNamePattern.getText());
        prefs.setValue(PREF_COMPRESS_PACKAGE_NAMES, this.fCompressPackageNames.isSelected());
        prefs.setValue(PREF_FOLD_PACKAGES_IN_PACKAGE_EXPLORER, this.fFoldPackagesInPackageExplorer.isSelected());
        JavaPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fShowMethodReturnType.setSelection(prefs.getDefaultBoolean(PREF_METHOD_RETURNTYPE));
        this.fShowMembersInPackageView.setSelection(prefs.getDefaultBoolean(SHOW_CU_CHILDREN));
        this.fStackBrowsingViewsVertically.setSelection(prefs.getDefaultBoolean(STACK_BROWSING_VIEWS_VERTICALLY));
        this.fPackageNamePattern.setText(prefs.getDefaultString(PREF_PKG_NAME_PATTERN_FOR_PKG_VIEW));
        this.fCompressPackageNames.setSelection(prefs.getDefaultBoolean(PREF_COMPRESS_PACKAGE_NAMES));
        this.fFoldPackagesInPackageExplorer.setSelection(prefs.getDefaultBoolean(PREF_FOLD_PACKAGES_IN_PACKAGE_EXPLORER));
        super.performDefaults();
    }
}

