/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TypeFilterInputDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TypeFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_FILTER_ENABLED = "org.eclipse.jdt.ui.typefilter.enabled";
    private static final String PREF_FILTER_DISABLED = "org.eclipse.jdt.ui.typefilter.disabled";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_PACKAGE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_SELECT = 5;
    private static final int IDX_DESELECT = 6;
    private CheckedListDialogField fFilterListField;

    private static String[] unpackOrderList(String str) {
        StringTokenizer tok = new StringTokenizer(str, ";");
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            res[i] = tok.nextToken();
        }
        return res;
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < orderList.size(); ++i) {
            buf.append((String)orderList.get(i));
            buf.append(';');
        }
        return buf.toString();
    }

    public TypeFilterPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("TypeFilterPreferencePage.description"));
        String[] buttonLabels = new String[]{PreferencesMessages.getString("TypeFilterPreferencePage.add.button"), PreferencesMessages.getString("TypeFilterPreferencePage.addpackage.button"), PreferencesMessages.getString("TypeFilterPreferencePage.edit.button"), PreferencesMessages.getString("TypeFilterPreferencePage.remove.button"), null, PreferencesMessages.getString("TypeFilterPreferencePage.selectall.button"), PreferencesMessages.getString("TypeFilterPreferencePage.deselectall.button")};
        TypeFilterAdapter adapter = new TypeFilterAdapter();
        this.fFilterListField = new CheckedListDialogField(adapter, buttonLabels, (ILabelProvider)new LabelProvider());
        this.fFilterListField.setDialogFieldListener(adapter);
        this.fFilterListField.setLabelText(PreferencesMessages.getString("TypeFilterPreferencePage.list.label"));
        this.fFilterListField.setCheckAllButtonIndex(5);
        this.fFilterListField.setUncheckAllButtonIndex(6);
        this.fFilterListField.setRemoveButtonIndex(3);
        this.fFilterListField.enableButton(2, false);
        this.initialize(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fFilterListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fFilterListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fFilterListField.getLabelControl(null), this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fFilterListField.getListControl(null));
        this.fFilterListField.getTableViewer().setSorter(new ViewerSorter(){});
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initialize(boolean fromDefault) {
        IPreferenceStore store = this.getPreferenceStore();
        String enabled = fromDefault ? store.getDefaultString(PREF_FILTER_ENABLED) : store.getString(PREF_FILTER_ENABLED);
        String disabled = fromDefault ? store.getDefaultString(PREF_FILTER_DISABLED) : store.getString(PREF_FILTER_DISABLED);
        ArrayList<String> res = new ArrayList<String>();
        String[] enabledEntries = TypeFilterPreferencePage.unpackOrderList(enabled);
        for (int i = 0; i < enabledEntries.length; ++i) {
            res.add(enabledEntries[i]);
        }
        String[] disabledEntries = TypeFilterPreferencePage.unpackOrderList(disabled);
        for (int i = 0; i < disabledEntries.length; ++i) {
            res.add(disabledEntries[i]);
        }
        this.fFilterListField.setElements(res);
        this.fFilterListField.setCheckedElements(Arrays.asList(enabledEntries));
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            List existing = this.fFilterListField.getElements();
            TypeFilterInputDialog dialog = new TypeFilterInputDialog(this.getShell(), existing);
            if (dialog.open() == 0) {
                Object res = dialog.getResult();
                this.fFilterListField.addElement(res);
                this.fFilterListField.setChecked(res, true);
            }
        } else if (index == 1) {
            String[] res = this.choosePackage();
            if (res != null) {
                this.fFilterListField.addElements(Arrays.asList(res));
                for (int i = 0; i < res.length; ++i) {
                    this.fFilterListField.setChecked(res[i], true);
                }
            }
        } else if (index == 2) {
            List selected = this.fFilterListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            String editedEntry = (String)selected.get(0);
            List existing = this.fFilterListField.getElements();
            existing.remove(editedEntry);
            TypeFilterInputDialog dialog = new TypeFilterInputDialog(this.getShell(), existing);
            dialog.setInitialString(editedEntry);
            if (dialog.open() == 0) {
                this.fFilterListField.replaceElement(editedEntry, dialog.getResult());
            }
        }
    }

    private String[] choosePackage() {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        int flags = 7;
        PackageSelectionDialog dialog = new PackageSelectionDialog(this.getShell(), context, flags, scope);
        dialog.setTitle(PreferencesMessages.getString("TypeFilterPreferencePage.choosepackage.label"));
        dialog.setMessage(PreferencesMessages.getString("TypeFilterPreferencePage.choosepackage.description"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] fragments = dialog.getResult();
            String[] res = new String[fragments.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = ((IPackageFragment)fragments[i]).getElementName() + ".*";
            }
            return res;
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.initialize(true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        List checked = this.fFilterListField.getCheckedElements();
        List unchecked = this.fFilterListField.getElements();
        unchecked.removeAll(checked);
        prefs.setValue(PREF_FILTER_ENABLED, TypeFilterPreferencePage.packOrderList(checked));
        prefs.setValue(PREF_FILTER_DISABLED, TypeFilterPreferencePage.packOrderList(unchecked));
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private class TypeFilterAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private TypeFilterAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            return field.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            TypeFilterPreferencePage.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            TypeFilterPreferencePage.this.fFilterListField.enableButton(2, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                TypeFilterPreferencePage.this.doButtonPressed(2);
            }
        }
    }
}

