/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class PullUpTreeViewer
extends CheckboxTreeViewer {
    private Set fActiveElements = new HashSet();

    public PullUpTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(this.createCheckStateListener());
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                IMember element = (IMember)event.getElement();
                PullUpTreeViewer.this.initializeChildren(element);
            }
        });
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PullUpTreeViewer.this.setCheckState((IMember)event.getElement(), event.getChecked());
            }
        };
    }

    public void setCheckState(IMember element, boolean checked) {
        if (checked) {
            this.fActiveElements.add(element);
        } else {
            this.fActiveElements.remove(element);
        }
        this.setSubtreeChecked(element, checked);
        this.setSubtreeGrayed(element, false);
        IMember parent = this.getParent((IJavaElement)element);
        if (parent == null) {
            return;
        }
        while (parent != null) {
            this.setChecked(parent, checked);
            this.setGrayed(parent, this.isPartlyActive((IJavaElement)parent));
            parent = this.getParent((IJavaElement)parent);
        }
    }

    private ITypeHierarchy getTypeHierarchyInput() {
        return (ITypeHierarchy)this.getInput();
    }

    private boolean isPartlyActive(IJavaElement member) {
        if (member instanceof IMethod) {
            return false;
        }
        if (!(member instanceof IType)) {
            return false;
        }
        boolean checked = this.getChecked(member);
        Object[] children = this.getFilteredChildren(member);
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof IJavaElement)) continue;
            IJavaElement iJavaElement = (IJavaElement)children[i];
            if (checked) {
                if (!this.getChecked(iJavaElement)) {
                    return true;
                }
                if (this.isPartlyActive(iJavaElement)) {
                    return true;
                }
            }
            if (checked) continue;
            if (this.getChecked(iJavaElement)) {
                return true;
            }
            if (!this.isPartlyActive(iJavaElement)) continue;
            return true;
        }
        return false;
    }

    private IMember getParent(IJavaElement member) {
        if (member instanceof IType) {
            return this.getTypeHierarchyInput().getSuperclass((IType)member);
        }
        if (member instanceof IMethod) {
            return ((IMethod)member).getDeclaringType();
        }
        return null;
    }

    private IMember[] getChildren(IMember member) {
        if (member instanceof IType) {
            return this.getTypeHierarchyInput().getSubtypes((IType)member);
        }
        return null;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.initializeChildren((IMember)((ITypeHierarchy)input).getType());
    }

    public void expandToLevel(Object element, int level) {
        super.expandToLevel(element, level);
        if (element instanceof IMember) {
            this.initializeChildren((IMember)element);
        }
        if (element instanceof ITypeHierarchy) {
            this.initializeChildren((IMember)((ITypeHierarchy)element).getType());
        }
    }

    private void initializeChildren(IMember element) {
        if (element == null) {
            return;
        }
        IMember[] children = this.getChildren(element);
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            boolean grayed;
            IMember child = children[i];
            boolean checked = this.fActiveElements.contains(child);
            if (checked) {
                this.setChecked(child, checked);
            }
            if (!(grayed = this.isPartlyActive((IJavaElement)child))) continue;
            this.setGrayed(child, grayed);
        }
    }

    public void setSubtreeGrayed(Object element, boolean grayed) {
        TreeItem item;
        Widget widget = this.findItem(element);
        if (widget instanceof TreeItem && (item = (TreeItem)widget).getGrayed() != grayed) {
            item.setGrayed(grayed);
            this.grayChildren(this.getChildren((Widget)item), grayed);
        }
    }

    private void grayChildren(Item[] items, boolean grayed) {
        for (int i = 0; i < items.length; ++i) {
            TreeItem item;
            Item element = items[i];
            if (!(element instanceof TreeItem) || (item = (TreeItem)element).getGrayed() == grayed) continue;
            item.setGrayed(grayed);
            this.grayChildren(this.getChildren((Widget)item), grayed);
        }
    }
}

