/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.jdt.internal.ui.search.SearchMessages;

public class MethodExitsFinder
extends ASTVisitor {
    private AST fAST;
    private MethodDeclaration fMethodDeclaration;
    private List fResult;
    private List fCatchedExceptions;

    public String initialize(CompilationUnit root, int offset, int length) {
        Name name;
        this.fAST = root.getAST();
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        Type type = null;
        if (node instanceof Type) {
            type = (Type)node;
        } else if (node instanceof Name && (name = ASTNodes.getTopMostName((Name)node)).getParent() instanceof Type) {
            type = (Type)name.getParent();
        }
        if (type == null) {
            return SearchMessages.getString("MethodExitsFinder.no_return_type_selected");
        }
        if (!((type = ASTNodes.getTopMostType(type)).getParent() instanceof MethodDeclaration)) {
            return SearchMessages.getString("MethodExitsFinder.no_return_type_selected");
        }
        this.fMethodDeclaration = (MethodDeclaration)type.getParent();
        return null;
    }

    public List perform() {
        this.fResult = new ArrayList();
        this.markReferences();
        if (this.fResult.size() > 0) {
            this.fResult.add(this.fMethodDeclaration.getReturnType());
        }
        return this.fResult;
    }

    private void markReferences() {
        this.fCatchedExceptions = new ArrayList();
        this.fMethodDeclaration.accept((ASTVisitor)this);
        Block block = this.fMethodDeclaration.getBody();
        if (block != null) {
            List statements = block.statements();
            if (statements.size() > 0) {
                Statement last = (Statement)statements.get(statements.size() - 1);
                int maxVariableId = LocalVariableIndex.perform((BodyDeclaration)this.fMethodDeclaration);
                FlowContext flowContext = new FlowContext(0, maxVariableId + 1);
                flowContext.setConsiderAccessMode(false);
                flowContext.setComputeMode(FlowContext.ARGUMENTS);
                InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(flowContext);
                FlowInfo info = flowAnalyzer.perform(new ASTNode[]{last});
                if (!info.isNoReturn() && !info.isPartialReturn()) {
                    return;
                }
            }
            SimpleName name = this.fAST.newSimpleName("x");
            name.setSourceRange(this.fMethodDeclaration.getStartPosition() + this.fMethodDeclaration.getLength() - 1, 1);
            this.fResult.add(name);
        }
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.fResult.add(node);
        return super.visit(node);
    }

    public boolean visit(TryStatement node) {
        int toRemove;
        int currentSize = this.fCatchedExceptions.size();
        List catchClauses = node.catchClauses();
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            IVariableBinding variable = ((CatchClause)iter.next()).getException().resolveBinding();
            if (variable == null || variable.getType() == null) continue;
            this.fCatchedExceptions.add(variable.getType());
        }
        node.getBody().accept((ASTVisitor)this);
        for (int i = toRemove = this.fCatchedExceptions.size() - currentSize; i > 0; --i) {
            this.fCatchedExceptions.remove(currentSize);
        }
        Iterator iter2 = catchClauses.iterator();
        while (iter2.hasNext()) {
            ((CatchClause)iter2.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (this.isExitPoint(exception)) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxx");
            name.setSourceRange(node.getStartPosition(), 4);
            this.fResult.add(name);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return true;
    }

    private boolean isExitPoint(ITypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return !this.isCatched(binding);
    }

    private boolean isExitPoint(IMethodBinding binding) {
        if (binding == null) {
            return false;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            if (this.isCatched(exceptions[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isCatched(ITypeBinding binding) {
        Iterator iter = this.fCatchedExceptions.iterator();
        while (iter.hasNext()) {
            ITypeBinding catchException = (ITypeBinding)iter.next();
            if (!this.catches(catchException, binding)) continue;
            return true;
        }
        return false;
    }

    private boolean catches(ITypeBinding catchTypeBinding, ITypeBinding throwTypeBinding) {
        while (throwTypeBinding != null) {
            if (throwTypeBinding == catchTypeBinding) {
                return true;
            }
            throwTypeBinding = throwTypeBinding.getSuperclass();
        }
        return false;
    }
}

