/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;

public class ASTRewriteCorrectionProposal
extends CUCorrectionProposal {
    private ASTRewrite fRewrite;

    public ASTRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, relevance, image);
        this.fRewrite = rewrite;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                Map options = this.getCompilationUnit().getJavaProject().getOptions(true);
                TextEdit edit = rewrite.rewriteAST(document, options);
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fRewrite == null) {
            IStatus status = JavaUIStatus.createError(4, "Rewriter not initialized", null);
            throw new CoreException(status);
        }
        return this.fRewrite;
    }
}

