/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class ChangeCorrectionProposal
implements IJavaCompletionProposal {
    private Change fChange;
    private String fName;
    private int fRelevance;
    private Image fImage;

    public ChangeCorrectionProposal(String name, Change change, int relevance, Image image) {
        Assert.isNotNull(name);
        this.fName = name;
        this.fChange = change;
        this.fRelevance = relevance;
        this.fImage = image;
    }

    public void apply(IDocument document) {
        try {
            this.performChange(JavaPlugin.getActivePage().getActiveEditor(), document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.getString("ChangeCorrectionProposal.error.title"), CorrectionMessages.getString("ChangeCorrectionProposal.error.message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        Change change = null;
        try {
            change = this.getChange();
            if (change != null) {
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, JavaPlugin.getPluginId(), 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (change != null) {
                change.dispose();
            }
        }
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("<p>");
        Change change = this.getChange();
        if (change == null) {
            return null;
        }
        buf.append(change.getName());
        buf.append("</p>");
        return buf.toString();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fName;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public Change getChange() {
        return this.fChange;
    }

    public void setDisplayName(String name) {
        Assert.isNotNull(name);
        this.fName = name;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }
}

