/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewInterfaceCreationWizard;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewCUCompletionUsingWizardProposal
extends ChangeCorrectionProposal {
    private Name fNode;
    private ICompilationUnit fCompilationUnit;
    private boolean fIsClass;
    private IJavaElement fTypeContainer;
    private boolean fShowDialog;

    public NewCUCompletionUsingWizardProposal(ICompilationUnit cu, Name node, boolean isClass, IJavaElement typeContainer, int severity) {
        super("", null, severity, null);
        this.fCompilationUnit = cu;
        this.fNode = node;
        this.fIsClass = isClass;
        this.fTypeContainer = typeContainer;
        String containerName = ASTNodes.getQualifier(node);
        String typeName = ASTNodes.getSimpleNameIdentifier(node);
        boolean isInnerType = typeContainer instanceof IType;
        if (isClass) {
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.class_obj.gif"));
            if (isInnerType) {
                if (containerName.length() == 0) {
                    this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinnerclass.description", typeName));
                } else {
                    this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinnerclass.intype.description", new String[]{typeName, containerName}));
                }
            } else if (containerName.length() == 0) {
                this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createclass.description", typeName));
            } else {
                this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createclass.inpackage.description", new String[]{typeName, containerName}));
            }
        } else {
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.int_obj.gif"));
            if (isInnerType) {
                if (containerName.length() == 0) {
                    this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinnerinterface.description", typeName));
                } else {
                    this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinnerinterface.intype.description", new String[]{typeName, containerName}));
                }
            } else if (containerName.length() == 0) {
                this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinterface.description", typeName));
            } else {
                this.setDisplayName(CorrectionMessages.getFormattedString("NewCUCompletionUsingWizardProposal.createinterface.inpackage.description", new String[]{typeName, containerName}));
            }
        }
        this.fShowDialog = true;
    }

    public void apply(IDocument document) {
        NewElementWizard wizard = this.createWizard();
        wizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.fCompilationUnit));
        if (this.fShowDialog) {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter((Control)shell);
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.getShell().setText(CorrectionMessages.getString("NewCUCompletionUsingWizardProposal.dialogtitle"));
            this.configureWizardPage(wizard);
            dialog.open();
        } else {
            wizard.addPages();
            try {
                NewTypeWizardPage page = this.configureWizardPage(wizard);
                page.createType(null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private NewElementWizard createWizard() {
        NewElementWizard wizard = this.fIsClass ? new NewClassCreationWizard() : new NewInterfaceCreationWizard();
        return wizard;
    }

    private NewTypeWizardPage configureWizardPage(NewElementWizard wizard) {
        IWizardPage[] pages = wizard.getPages();
        Assert.isTrue(pages.length > 0 && pages[0] instanceof NewTypeWizardPage);
        NewTypeWizardPage page = (NewTypeWizardPage)pages[0];
        this.fillInWizardPageName(page);
        this.fillInWizardPageSuperTypes(page);
        return page;
    }

    private void fillInWizardPageName(NewTypeWizardPage page) {
        page.setTypeName(ASTNodes.getSimpleNameIdentifier(this.fNode), false);
        boolean isInEnclosingType = this.fTypeContainer instanceof IType;
        if (isInEnclosingType) {
            page.setEnclosingType((IType)this.fTypeContainer, true);
        } else {
            page.setPackageFragment((IPackageFragment)this.fTypeContainer, true);
        }
        page.setEnclosingTypeSelection(isInEnclosingType, true);
    }

    private void fillInWizardPageSuperTypes(NewTypeWizardPage page) {
        ITypeBinding type = NewCUCompletionUsingWizardProposal.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if ((type = Bindings.normalizeTypeBinding(type)) != null) {
            if (type.isArray()) {
                type = type.getElementType();
            }
            if (type.isTopLevel() || type.isMember()) {
                if (type.isClass() && this.fIsClass) {
                    page.setSuperClass(Bindings.getFullyQualifiedName(type), true);
                } else if (type.isInterface()) {
                    ArrayList<String> superInterfaces = new ArrayList<String>();
                    superInterfaces.add(Bindings.getFullyQualifiedName(type));
                    page.setSuperInterfaces(superInterfaces, true);
                }
            }
        }
    }

    private static ITypeBinding getPossibleSuperTypeBinding(ASTNode node) {
        AST ast = node.getAST();
        ASTNode parent = node.getParent();
        while (parent instanceof Type) {
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 31: {
                MethodDeclaration decl = (MethodDeclaration)parent;
                if (!decl.thrownExceptions().contains(node)) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)parent;
                return instanceofExpression.getLeftOperand().resolveTypeBinding();
            }
            case 3: {
                ArrayCreation creation = (ArrayCreation)parent;
                if (creation.getInitializer() != null) {
                    return creation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.guessBindingForReference(parent);
            }
            case 53: {
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 11: 
            case 14: 
            case 57: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 44: {
                ASTNode parentParent = parent.getParent();
                if (parentParent.getNodeType() != 12) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
        }
        return null;
    }

    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        if (this.fIsClass) {
            buf.append(CorrectionMessages.getString("NewCUCompletionUsingWizardProposal.createclass.info"));
        } else {
            buf.append(CorrectionMessages.getString("NewCUCompletionUsingWizardProposal.createinterface.info"));
        }
        buf.append("<br>");
        buf.append("<br>");
        if (this.fTypeContainer instanceof IType) {
            buf.append(CorrectionMessages.getString("NewCUCompletionUsingWizardProposal.tooltip.enclosingtype"));
        } else {
            buf.append(CorrectionMessages.getString("NewCUCompletionUsingWizardProposal.tooltip.package"));
        }
        buf.append("<b>");
        buf.append(JavaElementLabels.getElementLabel(this.fTypeContainer, 8192));
        buf.append("</b><br>");
        buf.append("public ");
        if (this.fIsClass) {
            buf.append("class <b>");
        } else {
            buf.append("interface <b>");
        }
        buf.append(ASTNodes.getSimpleNameIdentifier(this.fNode));
        ITypeBinding superclass = NewCUCompletionUsingWizardProposal.getPossibleSuperTypeBinding((ASTNode)this.fNode);
        if (superclass != null) {
            if (superclass.isClass() || !this.fIsClass) {
                buf.append("</b> extends <b>");
            } else {
                buf.append("</b> implements <b>");
            }
            buf.append(superclass.getName());
        }
        buf.append("</b> {<br>}<br>");
        return buf.toString();
    }

    public boolean isShowDialog() {
        return this.fShowDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }

    public boolean isClass() {
        return this.fIsClass;
    }
}

