/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.spelling.HtmlTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.JavaDocTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.SpellReconcileDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.TaskTagDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultSpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.PersistentSpellDictionary;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellChecker fChecker = null;
    private static ISpellCheckEngine fEngine = null;
    private final Set fGlobalDictionaries = new HashSet();
    private Locale fLocale = null;
    private final Map fLocaleDictionaries = new HashMap();
    private IPreferenceStore fPreferences = null;
    private ISpellDictionary fUserDictionary = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAvailableLocales() {
        URL url = null;
        Locale locale = null;
        InputStream stream = null;
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            URL location = SpellCheckEngine.getDictionaryLocation();
            Locale[] locales = Locale.getAvailableLocales();
            for (int index = 0; index < locales.length; ++index) {
                locale = locales[index];
                url = new URL(location, locale.toString().toLowerCase() + "." + JavaUIMessages.getString("Spelling.dictionary.file.extension"));
                try {
                    stream = url.openStream();
                    if (stream == null) continue;
                    try {
                        result.add(locale);
                        continue;
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException exception) {
                    // empty catch block
                }
            }
        }
        catch (MalformedURLException exception) {
            // empty catch block
        }
        result.add(SpellCheckEngine.getDefaultLocale());
        return result;
    }

    public static Locale getDefaultLocale() {
        return Locale.US;
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fEngine == null) {
            fEngine = new SpellCheckEngine();
        }
        return fEngine;
    }

    private SpellCheckEngine() {
        this.fGlobalDictionaries.add(new TaskTagDictionary());
        this.fGlobalDictionaries.add(new HtmlTagDictionary());
        this.fGlobalDictionaries.add(new JavaDocTagDictionary());
        try {
            Locale locale = null;
            URL location = SpellCheckEngine.getDictionaryLocation();
            Iterator iterator = SpellCheckEngine.getAvailableLocales().iterator();
            while (iterator.hasNext()) {
                locale = (Locale)iterator.next();
                this.fLocaleDictionaries.put(locale, new SpellReconcileDictionary(locale, location));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public final synchronized ISpellChecker createSpellChecker(Locale locale, IPreferenceStore store) {
        ISpellDictionary dictionary;
        if (this.fLocale != null && this.fLocale.equals(locale)) {
            return fChecker;
        }
        if (fChecker == null) {
            fChecker = new DefaultSpellChecker(store);
            store.addPropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferences = store;
            dictionary = null;
            Iterator iterator = this.fGlobalDictionaries.iterator();
            while (iterator.hasNext()) {
                dictionary = (ISpellDictionary)iterator.next();
                fChecker.addDictionary(dictionary);
            }
        }
        dictionary = null;
        if (this.fLocale != null && (dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(this.fLocale)) != null) {
            fChecker.removeDictionary(dictionary);
            dictionary.unload();
        }
        this.fLocale = locale;
        dictionary = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (dictionary == null) {
            if (!SpellCheckEngine.getDefaultLocale().equals(locale)) {
                if (this.fPreferences != null) {
                    this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
                }
                fChecker = null;
                this.fLocale = null;
            }
        } else {
            fChecker.addDictionary(dictionary);
        }
        if (this.fPreferences != null) {
            this.propertyChange(new PropertyChangeEvent((Object)this, "spelling_user_dictionary", null, (Object)this.fPreferences.getString("spelling_user_dictionary")));
        }
        return fChecker;
    }

    public final Locale getLocale() {
        return this.fLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void propertyChange(PropertyChangeEvent event) {
        block9: {
            if (fChecker != null && event.getProperty().equals("spelling_user_dictionary")) {
                String file;
                if (this.fUserDictionary != null) {
                    fChecker.removeDictionary(this.fUserDictionary);
                    this.fUserDictionary = null;
                }
                if ((file = (String)event.getNewValue()).length() > 0) {
                    try {
                        URL url = new URL("file", null, file);
                        InputStream stream = url.openStream();
                        if (stream == null) break block9;
                        try {
                            this.fUserDictionary = new PersistentSpellDictionary(url);
                            fChecker.addDictionary(this.fUserDictionary);
                        }
                        finally {
                            stream.close();
                        }
                    }
                    catch (MalformedURLException exception) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public final synchronized void registerDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        if (fChecker != null) {
            fChecker.addDictionary(dictionary);
        }
    }

    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        if (fChecker != null && this.fLocale != null && this.fLocale.equals(locale)) {
            fChecker.addDictionary(dictionary);
        }
    }

    public final synchronized void unload() {
        ISpellDictionary dictionary = null;
        Iterator<Object> iterator = this.fGlobalDictionaries.iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        iterator = this.fLocaleDictionaries.values().iterator();
        while (iterator.hasNext()) {
            dictionary = (ISpellDictionary)iterator.next();
            dictionary.unload();
        }
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fUserDictionary = null;
        fChecker = null;
    }

    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        if (fChecker != null) {
            fChecker.removeDictionary(dictionary);
        }
        dictionary.unload();
    }
}

