/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.workingsets.JavaWorkingSetPageContentProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class JavaWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.getString("JavaWorkingSetPage.title");
    private static final String PAGE_ID = "javaWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$core$resources$IContainer;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public JavaWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, JavaPluginImages.DESC_WIZBAN_JAVA_WORKINGSET);
        this.setDescription(WorkingSetMessages.getString("JavaWorkingSetPage.workingSet.description"));
        this.fFirstCheck = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("JavaWorkingSetPage.workingSet.name"));
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fWorkingSetName = new Text(composite, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("JavaWorkingSetPage.workingSet.content"));
        gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.fTree = new CheckboxTreeViewer(composite, 2816);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gd);
        this.fTreeContentProvider = new JavaWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider fJavaElementLabelProvider = new AppearanceAwareLabelProvider(1627389961, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(fJavaElementLabelProvider));
        this.fTree.setSorter((ViewerSorter)new JavaElementSorter());
        this.fTree.addFilter((ViewerFilter)new EmptyInnerPackageFilter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JavaWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!JavaWorkingSetPage.this.fTree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)JavaWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        private final /* synthetic */ Object val$element;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$element = val$element;
                        }

                        public void run() {
                            JavaWorkingSetPage.access$300(3.access$200(this.this$1), this.val$element, JavaWorkingSetPage.access$100(3.access$200(this.this$1)).getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ JavaWorkingSetPage access$200(3 x0) {
                return x0.JavaWorkingSetPage.this;
            }
        });
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite);
        JavaUIHelp.setHelp((StructuredViewer)this.fTree, "org.eclipse.jdt.ui.java_working_set_page_context");
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.fWorkingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(elements, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
        } else {
            IAdaptable[] oldItems = this.fWorkingSet.getElements();
            ArrayList<IProject> closedWithChildren = new ArrayList<IProject>(elements.size());
            for (int i = 0; i < oldItems.length; ++i) {
                IProject project;
                IResource oldResource = null;
                oldResource = oldItems[i] instanceof IResource ? (IResource)oldItems[i] : (IResource)oldItems[i].getAdapter(class$org$eclipse$core$resources$IResource == null ? JavaWorkingSetPage.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                if (oldResource == null || oldResource.isAccessible() || !elements.contains(project = oldResource.getProject()) && !closedWithChildren.contains(project)) continue;
                elements.add(oldItems[i]);
                elements.remove(project);
                closedWithChildren.add(project);
            }
            this.fWorkingSet.setName(workingSetName);
            this.fWorkingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private void validateInput() {
        String errorMessage = null;
        String newText = this.fWorkingSetName.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.getString("JavaWorkingSetPage.warning.nameWhitespace");
        }
        if (newText.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            errorMessage = WorkingSetMessages.getString("JavaWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        this.fFirstCheck = false;
        if (!(errorMessage != null || this.fWorkingSet != null && newText.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            for (int i = 0; i < workingSets.length; ++i) {
                if (!newText.equals(workingSets[i].getName())) continue;
                errorMessage = WorkingSetMessages.getString("JavaWorkingSetPage.warning.workingSetExists");
            }
        }
        if (errorMessage == null && !this.hasCheckedElement()) {
            errorMessage = WorkingSetMessages.getString("JavaWorkingSetPage.warning.resourceMustBeChecked");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] items = this.fTree.getTree().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            return true;
        }
        return false;
    }

    private void findCheckedElements(List checkedResources, Object parent) {
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            if (this.fTree.getGrayed(children[i])) {
                this.findCheckedElements(checkedResources, children[i]);
                continue;
            }
            if (!this.fTree.getChecked(children[i])) continue;
            checkedResources.add(children[i]);
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                boolean state = event.getChecked();
                JavaWorkingSetPage.this.fTree.setGrayed((Object)element, false);
                if (JavaWorkingSetPage.this.isExpandable(element)) {
                    JavaWorkingSetPage.this.setSubtreeChecked(element, state, state);
                }
                JavaWorkingSetPage.this.updateParentState(element, state);
                JavaWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object parent, boolean state, boolean checkExpandedState) {
        if (!(parent instanceof IAdaptable)) {
            return;
        }
        IContainer container = (IContainer)((IAdaptable)parent).getAdapter(class$org$eclipse$core$resources$IContainer == null ? (class$org$eclipse$core$resources$IContainer = JavaWorkingSetPage.class$("org.eclipse.core.resources.IContainer")) : class$org$eclipse$core$resources$IContainer);
        if (!this.fTree.getExpandedState(parent) && checkExpandedState || container != null && !container.isAccessible()) {
            return;
        }
        Object[] children = this.fTreeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            Object element = children[i];
            if (state) {
                this.fTree.setChecked(element, true);
                this.fTree.setGrayed(element, false);
            } else {
                this.fTree.setGrayChecked(element, false);
            }
            if (!this.isExpandable(element)) continue;
            this.setSubtreeChecked(element, state, true);
        }
    }

    private void updateParentState(Object child, boolean baseChildState) {
        IResource resource;
        if (child == null) {
            return;
        }
        if (child instanceof IAdaptable && (resource = (IResource)((IAdaptable)child).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = JavaWorkingSetPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) != null && !resource.isAccessible()) {
            return;
        }
        Object parent = this.fTreeContentProvider.getParent(child);
        if (parent == null) {
            return;
        }
        boolean allSameState = true;
        Object[] children = null;
        children = this.fTreeContentProvider.getChildren(parent);
        for (int i = children.length - 1; i >= 0; --i) {
            if (this.fTree.getChecked(children[i]) == baseChildState && !this.fTree.getGrayed(children[i])) continue;
            allSameState = false;
            break;
        }
        this.fTree.setGrayed(parent, !allSameState);
        this.fTree.setChecked(parent, !allSameState || baseChildState);
        this.updateParentState(parent, baseChildState);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object element;
                int i;
                Object[] elements;
                if (JavaWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage page = JavaPlugin.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IWorkbenchPart part = JavaPlugin.getActivePage().getActivePart();
                    if (part == null) {
                        return;
                    }
                    try {
                        elements = SelectionConverter.getStructuredSelection(part).toArray();
                        for (int i2 = 0; i2 < elements.length; ++i2) {
                            IJavaElement je;
                            if (!(elements[i2] instanceof IResource) || (je = (IJavaElement)((IResource)elements[i2]).getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? JavaWorkingSetPage.class$("org.eclipse.jdt.core.IJavaElement") : class$org$eclipse$jdt$core$IJavaElement)) == null || !je.exists() || !je.getJavaProject().isOnClasspath((IResource)elements[i2])) continue;
                            elements[i2] = je;
                        }
                    }
                    catch (JavaModelException e) {
                        return;
                    }
                } else {
                    elements = JavaWorkingSetPage.this.fWorkingSet.getElements();
                }
                for (i = 0; i < elements.length; ++i) {
                    IJavaProject jProject;
                    IProject project;
                    element = elements[i];
                    if (element instanceof IResource && !(project = ((IResource)element).getProject()).isAccessible()) {
                        elements[i] = project;
                    }
                    if (!(element instanceof IJavaElement) || (jProject = ((IJavaElement)element).getJavaProject()) == null || jProject.getProject().isAccessible()) continue;
                    elements[i] = jProject.getProject();
                }
                JavaWorkingSetPage.this.fTree.setCheckedElements(elements);
                for (i = 0; i < elements.length; ++i) {
                    element = elements[i];
                    if (JavaWorkingSetPage.this.isExpandable(element)) {
                        JavaWorkingSetPage.this.setSubtreeChecked(element, true, true);
                    }
                    JavaWorkingSetPage.this.updateParentState(element, true);
                }
            }
        });
    }

    private boolean isExpandable(Object element) {
        return element instanceof IJavaProject || element instanceof IPackageFragmentRoot || element instanceof IPackageFragment || element instanceof IJavaModel || element instanceof IContainer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

