/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSRevisionNumberCompareCriteria;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;

public abstract class CVSSyncTreeSubscriber
extends ResourceVariantTreeSubscriber {
    public static final String SYNC_KEY_QUALIFIER = "org.eclipse.team.cvs";
    private IResourceVariantComparator comparisonCriteria;
    private QualifiedName id;
    private String name;
    private String description;

    CVSSyncTreeSubscriber(QualifiedName id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.comparisonCriteria = new CVSRevisionNumberCompareCriteria(this.isThreeWay());
    }

    public QualifiedName getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        if (!this.isSupervised(resource)) {
            return null;
        }
        if (resource.getType() == 1 || !this.isThreeWay()) {
            return super.getSyncInfo(resource);
        }
        IResourceVariant remoteResource = this.getRemoteTree().getResourceVariant(resource);
        return this.getSyncInfo(resource, remoteResource, remoteResource);
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        try {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (provider == null) {
                return false;
            }
            ICVSResource cvsThing = CVSWorkspaceRoot.getCVSResourceFor(resource);
            if (cvsThing.isIgnored()) {
                return this.getRemoteTree().hasResourceVariant(resource);
            }
            return true;
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 368) {
                return false;
            }
            throw e;
        }
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparisonCriteria;
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        CVSSyncInfo info = new CVSSyncInfo(local, base, remote, (Subscriber)this);
        info.init();
        return info;
    }

    protected boolean getCacheFileContentsHint() {
        return false;
    }

    protected boolean isThreeWay() {
        return true;
    }

    protected boolean rootsEqual(Subscriber other) {
        HashSet<IResource> roots1 = new HashSet<IResource>(Arrays.asList(other.roots()));
        HashSet<IResource> roots2 = new HashSet<IResource>(Arrays.asList(this.roots()));
        if (roots1.size() != roots2.size()) {
            return false;
        }
        return roots2.containsAll(roots1);
    }
}

