/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;

public class CommandOutputListener
implements ICommandOutputListener {
    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        return ICommandOutputListener.OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        String protocolError = this.getProtocolError(line, location);
        if (protocolError != null) {
            return new CVSStatus(4, -23, commandRoot, protocolError);
        }
        return new CVSStatus(4, -14, commandRoot, line);
    }

    protected String getProtocolError(String line, ICVSRepositoryLocation location) {
        if (line.startsWith("Protocol error:")) {
            return line;
        }
        return null;
    }

    public String getServerMessage(String line, ICVSRepositoryLocation location) {
        return ((CVSRepositoryLocation)location).getServerMessageWithoutPrefix(line, "server: ");
    }

    public String getServerAbortedMessage(String line, ICVSRepositoryLocation location) {
        return ((CVSRepositoryLocation)location).getServerMessageWithoutPrefix(line, "[server aborted]: ");
    }

    public String getServerRTagMessage(String line, ICVSRepositoryLocation location) {
        return ((CVSRepositoryLocation)location).getServerMessageWithoutPrefix(line, "rtag: ");
    }
}

