/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class KnownRepositories {
    private List repositoryListeners = new ArrayList();
    private Map repositories = new HashMap();
    private static KnownRepositories instance;

    public static synchronized KnownRepositories getInstance() {
        if (instance == null) {
            instance = new KnownRepositories();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.remove(listener);
        }
    }

    public ICVSRepositoryLocation addRepository(final ICVSRepositoryLocation repository, boolean broadcast) {
        CVSRepositoryLocation existingLocation = this.internalGetRepository(repository.getLocation());
        if (existingLocation == null) {
            this.store((CVSRepositoryLocation)repository);
            existingLocation = (CVSRepositoryLocation)repository;
        }
        if (broadcast) {
            ((CVSRepositoryLocation)repository).updateCache();
            this.fireNotification(new Notification(){

                public void notify(ICVSListener listener) {
                    listener.repositoryAdded(repository);
                }
            });
        }
        return existingLocation;
    }

    public void disposeRepository(final ICVSRepositoryLocation repository) {
        ((CVSRepositoryLocation)repository).dispose();
        if (this.getRepositoriesMap().remove(repository.getLocation()) != null) {
            this.fireNotification(new Notification(){

                public void notify(ICVSListener listener) {
                    listener.repositoryRemoved(repository);
                }
            });
        }
    }

    public boolean isKnownRepository(String location) {
        return this.internalGetRepository(location) != null;
    }

    public ICVSRepositoryLocation[] getRepositories() {
        return this.getRepositoriesMap().values().toArray(new ICVSRepositoryLocation[this.getRepositoriesMap().size()]);
    }

    public ICVSRepositoryLocation getRepository(String location) throws CVSException {
        CVSRepositoryLocation repository = this.internalGetRepository(location);
        if (repository == null) {
            repository = CVSRepositoryLocation.fromString(location);
        }
        return repository;
    }

    private CVSRepositoryLocation internalGetRepository(String location) {
        return (CVSRepositoryLocation)this.getRepositoriesMap().get(location);
    }

    private void store(CVSRepositoryLocation location) {
        this.getRepositoriesMap().put(location.getLocation(), location);
        location.storePreferences();
    }

    private Map getRepositoriesMap() {
        if (this.repositories == null) {
            this.repositories = new HashMap();
            Preferences prefs = CVSRepositoryLocation.getParentPreferences();
            try {
                String[] keys = prefs.childrenNames();
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    try {
                        Preferences node = prefs.node(key);
                        String location = node.get("location", null);
                        if (location != null) {
                            this.repositories.put(location, CVSRepositoryLocation.fromString(location));
                            continue;
                        }
                        node.removeNode();
                        prefs.flush();
                        continue;
                    }
                    catch (CVSException e) {
                        CVSProviderPlugin.log((CoreException)((Object)e));
                    }
                }
                if (this.repositories.isEmpty()) {
                    this.getRepositoriesFromProjects();
                }
            }
            catch (BackingStoreException e) {
                CVSProviderPlugin.log(4, Policy.bind("KnownRepositories.0"), e);
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
        }
        return this.repositories;
    }

    private void getRepositoriesFromProjects() throws CVSException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            ICVSFolder folder;
            FolderSyncInfo info;
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)projects[i], (String)CVSProviderPlugin.getTypeId());
            if (provider == null || (info = (folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)projects[i])).getFolderSyncInfo()) == null) continue;
            this.addRepository(this.getRepository(info.getRoot()), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICVSListener[] getListeners() {
        List list = this.repositoryListeners;
        synchronized (list) {
            return this.repositoryListeners.toArray(new ICVSListener[this.repositoryListeners.size()]);
        }
    }

    private void fireNotification(Notification notification) {
        ICVSListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ICVSListener listener = listeners[i];
            notification.run(listener);
        }
    }

    private abstract class Notification
    implements ISafeRunnable {
        private ICVSListener listener;

        private Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(ICVSListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(ICVSListener var1);
    }
}

