/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.adaptor.core.BundleResourceHandler;
import org.eclipse.osgi.framework.adaptor.core.ServiceRegistryImpl;
import org.eclipse.osgi.framework.adaptor.core.SystemBundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractFrameworkAdaptor
implements FrameworkAdaptor {
    public static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    public static final String PARENT_CLASSLOADER_APP = "app";
    public static final String PARENT_CLASSLOADER_EXT = "ext";
    public static final String PARENT_CLASSLOADER_BOOT = "boot";
    public static final String PARENT_CLASSLOADER_FWK = "fwk";
    protected final String ADAPTOR_MANIFEST = "ADAPTOR.MF";
    protected EventPublisher eventPublisher;
    protected ServiceRegistryImpl serviceRegistry;
    protected Properties properties;
    protected BundleContext context;
    protected int initialBundleStartLevel = 1;
    protected Headers manifest = null;
    protected boolean stopping = false;
    protected static ClassLoader bundleClassLoaderParent;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor;

    public void initialize(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.serviceRegistry = new ServiceRegistryImpl();
        this.serviceRegistry.initialize();
        this.loadProperties();
        this.readAdaptorManifest();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URLConnection mapLocationToURLConnection(String location) throws BundleException {
        try {
            return new URL(location).openConnection();
        }
        catch (IOException e) {
            throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)location), (Throwable)e);
        }
    }

    public long getTotalFreeSpace() throws IOException {
        return -1L;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.stopping = false;
        this.context = context;
        BundleResourceHandler.setContext(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.context = null;
        BundleResourceHandler.setContext(null);
    }

    public void frameworkStopping(BundleContext context) {
        this.stopping = true;
    }

    public String getExportPackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Package");
    }

    public String getExportServices() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Service");
    }

    public String getProvidePackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Provide-Package");
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int value) {
        this.initialBundleStartLevel = value;
    }

    public BundleWatcher getBundleWatcher() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() {
        block13: {
            this.properties = new Properties();
            String resource = System.getProperty("osgi.framework.properties", "osgi.properties");
            try {
                InputStream in = null;
                File file = new File(resource);
                if (file.exists()) {
                    in = new FileInputStream(file);
                }
                if (in == null) {
                    in = this.getClass().getResourceAsStream(resource);
                }
                if (in != null) {
                    try {
                        this.properties.load(new BufferedInputStream(in));
                        break block13;
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException ee) {}
                    }
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.println((String)("Skipping osgi.properties: " + resource));
                }
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) break block13;
                Debug.println((String)("Unable to load osgi.properties: " + e.getMessage()));
            }
        }
    }

    protected void readAdaptorManifest() {
        InputStream in = null;
        Class<?> adaptorClazz = this.getClass();
        while (in == null && (class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor == null ? AbstractFrameworkAdaptor.class$("org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor") : class$org$eclipse$osgi$framework$adaptor$core$AbstractFrameworkAdaptor).isAssignableFrom(adaptorClazz)) {
            in = adaptorClazz.getResourceAsStream("ADAPTOR.MF");
            adaptorClazz = adaptorClazz.getSuperclass();
        }
        if (in == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)"Unable to find adaptor bundle manifest ADAPTOR.MF");
            }
            this.manifest = new Headers((Dictionary)new Properties());
            return;
        }
        try {
            this.manifest = Headers.parseManifest(in);
        }
        catch (BundleException e) {
            Debug.println((String)"Unable to read adaptor bundle manifest ADAPTOR.MF");
        }
    }

    public BundleData createSystemBundleData() throws BundleException {
        return new SystemBundleData(this);
    }

    public abstract AdaptorElementFactory getElementFactory();

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            for (int i = 0; i < files.length; ++i) {
                File inFile = new File(inDir, files[i]);
                File outFile = new File(outDir, files[i]);
                if (inFile.isDirectory()) {
                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                    continue;
                }
                FileInputStream in = new FileInputStream(inFile);
                AbstractFrameworkAdaptor.readFile(in, outFile);
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)"Unable to read file");
                Debug.printStackTrace((Throwable)e);
            }
            throw e;
        }
    }

    public ClassLoader getBundleClassLoaderParent() {
        return bundleClassLoaderParent;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public BundleFile createBundleFile(File basefile, BundleData bundledata) throws IOException {
        if (basefile.isDirectory()) {
            return new BundleFile.DirBundleFile(basefile);
        }
        return new BundleFile.ZipBundleFile(basefile, bundledata);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader appCL;
        String type = System.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        if (PARENT_CLASSLOADER_FWK.equalsIgnoreCase(type)) {
            bundleClassLoaderParent = (class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor == null ? (class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor = AbstractFrameworkAdaptor.class$("org.eclipse.osgi.framework.adaptor.FrameworkAdaptor")) : class$org$eclipse$osgi$framework$adaptor$FrameworkAdaptor).getClassLoader();
        } else if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            bundleClassLoaderParent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type) && (appCL = ClassLoader.getSystemClassLoader()) != null) {
            bundleClassLoaderParent = appCL.getParent();
        }
        if (bundleClassLoaderParent == null) {
            bundleClassLoaderParent = new ParentClassLoader();
        }
    }

    protected static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

