/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusViewer;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class ErrorWizardPage
extends RefactoringWizardPage {
    public static final String PAGE_NAME = "ErrorPage";
    private RefactoringStatus fStatus;
    private RefactoringStatusViewer fViewer;

    public ErrorWizardPage() {
        super(PAGE_NAME);
    }

    public void setStatus(RefactoringStatus status) {
        this.fStatus = status;
        if (this.fStatus != null) {
            this.setPageComplete(this.isRefactoringPossible());
            int severity = this.fStatus.getSeverity();
            if (severity >= 4) {
                this.setDescription(RefactoringUIMessages.getString("ErrorWizardPage.cannot_proceed"));
            } else if (severity >= 1) {
                this.setDescription(RefactoringUIMessages.getString("ErrorWizardPage.confirm"));
            } else {
                this.setDescription("");
            }
        } else {
            this.setPageComplete(true);
            this.setDescription("");
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fViewer = new RefactoringStatusViewer(parent, 0);
        this.setControl((Control)this.fViewer);
        Dialog.applyDialogFont((Control)this.fViewer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.refactoring_error_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fViewer.setStatus(this.fStatus);
        } else if (!this.isPageComplete() && this.fStatus.hasFatalError()) {
            this.setPageComplete(true);
        }
        super.setVisible(visible);
    }

    public boolean canFlipToNextPage() {
        return this.fStatus != null && this.isRefactoringPossible() && this.isPageComplete() && super.getNextPage() != null;
    }

    public IWizardPage getNextPage() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        Change change = wizard.getChange();
        if (change == null) {
            change = wizard.internalCreateChange(InternalAPI.INSTANCE, new CreateChangeOperation(this.getRefactoring()), false);
            wizard.internalSetChange(InternalAPI.INSTANCE, change);
        }
        if (change == null) {
            return this;
        }
        return super.getNextPage();
    }

    protected boolean performFinish() {
        RefactoringWizard wizard = this.getRefactoringWizard();
        Change change = wizard.getChange();
        UIPerformChangeOperation operation = null;
        if (change != null) {
            operation = new UIPerformChangeOperation(this.getShell().getDisplay(), change, this.getContainer());
        } else {
            CreateChangeOperation ccop = new CreateChangeOperation(this.getRefactoring());
            operation = new UIPerformChangeOperation(this.getShell().getDisplay(), ccop, this.getContainer());
        }
        FinishResult result = wizard.internalPerformFinish(InternalAPI.INSTANCE, operation);
        if (result.isException()) {
            return true;
        }
        if (result.isInterrupted()) {
            return false;
        }
        RefactoringStatus fValidationStatus = operation.getValidationStatus();
        if (fValidationStatus != null && fValidationStatus.hasFatalError()) {
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)RefactoringUIMessages.getFormattedString("RefactoringUI.cannot_execute", fValidationStatus.getMessageMatchingSeverity(4)));
            return true;
        }
        return true;
    }

    private boolean isRefactoringPossible() {
        return this.fStatus.getSeverity() < 4;
    }
}

