/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextStore;

public class GapTextStore
implements ITextStore {
    private char[] fContent = new char[0];
    private int fGapStart = -1;
    private int fGapEnd = -1;
    private int fHighWatermark;
    private int fLowWatermark;

    public GapTextStore(int lowWatermark, int highWatermark) {
        Assert.isTrue(lowWatermark < highWatermark);
        this.fLowWatermark = lowWatermark;
        this.fHighWatermark = highWatermark;
    }

    private void adjustGap(int offset, int sizeHint) {
        int size;
        if (offset == this.fGapStart && this.fLowWatermark <= (size = this.fGapEnd - this.fGapStart - sizeHint) && size <= this.fHighWatermark) {
            return;
        }
        this.moveAndResizeGap(offset, sizeHint);
    }

    private void moveAndResizeGap(int offset, int size) {
        char[] content = null;
        int oldSize = this.fGapEnd - this.fGapStart;
        int newSize = this.fHighWatermark + size;
        if (newSize < 0) {
            if (oldSize > 0) {
                content = new char[this.fContent.length - oldSize];
                System.arraycopy(this.fContent, 0, content, 0, this.fGapStart);
                System.arraycopy(this.fContent, this.fGapEnd, content, this.fGapStart, content.length - this.fGapStart);
                this.fContent = content;
            }
            this.fGapStart = this.fGapEnd = offset;
            return;
        }
        content = new char[this.fContent.length + (newSize - oldSize)];
        int newGapStart = offset;
        int newGapEnd = newGapStart + newSize;
        if (oldSize == 0) {
            System.arraycopy(this.fContent, 0, content, 0, newGapStart);
            System.arraycopy(this.fContent, newGapStart, content, newGapEnd, content.length - newGapEnd);
        } else if (newGapStart < this.fGapStart) {
            int delta = this.fGapStart - newGapStart;
            System.arraycopy(this.fContent, 0, content, 0, newGapStart);
            System.arraycopy(this.fContent, newGapStart, content, newGapEnd, delta);
            System.arraycopy(this.fContent, this.fGapEnd, content, newGapEnd + delta, this.fContent.length - this.fGapEnd);
        } else {
            int delta = newGapStart - this.fGapStart;
            System.arraycopy(this.fContent, 0, content, 0, this.fGapStart);
            System.arraycopy(this.fContent, this.fGapEnd, content, this.fGapStart, delta);
            System.arraycopy(this.fContent, this.fGapEnd + delta, content, newGapEnd, content.length - newGapEnd);
        }
        this.fContent = content;
        this.fGapStart = newGapStart;
        this.fGapEnd = newGapEnd;
    }

    public char get(int offset) {
        if (offset < this.fGapStart) {
            return this.fContent[offset];
        }
        int gapLength = this.fGapEnd - this.fGapStart;
        return this.fContent[offset + gapLength];
    }

    public String get(int offset, int length) {
        int end = offset + length;
        if (this.fContent == null) {
            return "";
        }
        if (end <= this.fGapStart) {
            return new String(this.fContent, offset, length);
        }
        if (this.fGapStart < offset) {
            int gapLength = this.fGapEnd - this.fGapStart;
            return new String(this.fContent, offset + gapLength, length);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.fContent, offset, this.fGapStart - offset);
        buf.append(this.fContent, this.fGapEnd, end - this.fGapStart);
        return buf.toString();
    }

    public int getLength() {
        int length = this.fGapEnd - this.fGapStart;
        return this.fContent.length - length;
    }

    public void replace(int offset, int length, String text) {
        int textLength;
        int n = textLength = text == null ? 0 : text.length();
        if (textLength == 0 && offset <= this.fGapStart && offset + length >= this.fGapStart && this.fGapStart > -1 && this.fGapEnd > -1) {
            this.fGapStart = offset;
            this.fGapEnd += (length -= this.fGapStart - offset);
            return;
        }
        this.adjustGap(offset + length, textLength - length);
        int min = Math.min(textLength, length);
        int i = offset;
        int j = 0;
        while (i < offset + min) {
            this.fContent[i] = text.charAt(j);
            ++i;
            ++j;
        }
        if (length > textLength) {
            this.fGapStart -= length - textLength;
        } else if (textLength > length) {
            this.fGapStart += textLength - length;
            for (i = length; i < textLength; ++i) {
                this.fContent[offset + i] = text.charAt(i);
            }
        }
    }

    public void set(String text) {
        if (text == null) {
            text = "";
        }
        this.fContent = text.toCharArray();
        this.fGapStart = -1;
        this.fGapEnd = -1;
    }

    protected String getContentAsString() {
        return new String(this.fContent);
    }

    protected int getGapStartIndex() {
        return this.fGapStart;
    }

    protected int getGapEndIndex() {
        return this.fGapEnd;
    }
}

