/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.InputStream;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private InputStream proxStream;
    private int proxCount;
    private int position;

    SegmentTermPositions(SegmentReader p) throws IOException {
        super(p);
        this.proxStream = (InputStream)this.parent.proxStream.clone();
    }

    final void seek(TermInfo ti) throws IOException {
        super.seek(ti);
        if (ti != null) {
            this.proxStream.seek(ti.proxPointer);
        } else {
            this.proxCount = 0;
        }
    }

    public final void close() throws IOException {
        super.close();
        this.proxStream.close();
    }

    public final int nextPosition() throws IOException {
        --this.proxCount;
        return this.position += this.proxStream.readVInt();
    }

    protected final void skippingDoc() throws IOException {
        for (int f = this.freq; f > 0; --f) {
            this.proxStream.readVInt();
        }
    }

    public final boolean next() throws IOException {
        for (int f = this.proxCount; f > 0; --f) {
            this.proxStream.readVInt();
        }
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    public final int read(int[] docs, int[] freqs) throws IOException {
        throw new UnsupportedOperationException();
    }
}

