/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.util.List;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.Patcher;

class Hunk {
    Diff fParent;
    int fOldStart;
    int fOldLength;
    int fNewStart;
    int fNewLength;
    String[] fLines;
    boolean fMatches = false;
    private boolean fIsEnabled = true;

    Hunk(Diff parent, int[] oldRange, int[] newRange, List lines) {
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.add(this);
        }
        this.fOldStart = oldRange[0] > 0 ? oldRange[0] - 1 : 0;
        this.fOldLength = oldRange[1];
        this.fNewStart = newRange[0] > 0 ? newRange[0] - 1 : 0;
        this.fNewLength = newRange[1];
        this.fLines = lines.toArray(new String[lines.size()]);
    }

    boolean isEnabled() {
        return this.fIsEnabled;
    }

    void setEnabled(boolean enable) {
        this.fIsEnabled = enable;
    }

    void reverse() {
        int t = this.fOldStart;
        this.fOldStart = this.fNewStart;
        this.fNewStart = t;
        t = this.fOldLength;
        this.fOldLength = this.fNewLength;
        this.fNewLength = t;
        block4: for (int i = 0; i < this.fLines.length; ++i) {
            String line = this.fLines[i];
            char c = line.charAt(0);
            switch (c) {
                case '+': {
                    this.fLines[i] = '-' + line.substring(1);
                    continue block4;
                }
                case '-': {
                    this.fLines[i] = '+' + line.substring(1);
                    continue block4;
                }
            }
        }
    }

    String getContent() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fLines.length; ++i) {
            String line = this.fLines[i];
            sb.append(line.substring(0, Patcher.length(line)));
            sb.append('\n');
        }
        return sb.toString();
    }

    String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(this.fOldStart));
        sb.append(',');
        sb.append(Integer.toString(this.fOldLength));
        sb.append(" -> ");
        sb.append(Integer.toString(this.fNewStart));
        sb.append(',');
        sb.append(Integer.toString(this.fNewLength));
        return sb.toString();
    }

    String getRejectedDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("@@ -");
        sb.append(Integer.toString(this.fOldStart));
        sb.append(',');
        sb.append(Integer.toString(this.fOldLength));
        sb.append(" +");
        sb.append(Integer.toString(this.fNewStart));
        sb.append(',');
        sb.append(Integer.toString(this.fNewLength));
        sb.append(" @@");
        return sb.toString();
    }
}

