/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CBanner
extends Composite {
    Control left;
    Control right;
    Control bottom;
    boolean simple = true;
    int[] curve;
    int curveStart = 0;
    Rectangle curveRect = new Rectangle(0, 0, 0, 0);
    int curve_width = 5;
    int curve_indent = -2;
    int rightWidth = -1;
    Cursor resizeCursor = new Cursor(this.getDisplay(), 9);
    boolean dragging = false;
    int rightDragDisplacement = 0;
    static final int OFFSCREEN = -200;
    static final int BORDER_BOTTOM = 2;
    static final int BORDER_TOP = 3;
    static final int BORDER_STRIPE = 1;
    static final int CURVE_TAIL = 200;
    static final int BEZIER_RIGHT = 30;
    static final int BEZIER_LEFT = 30;
    static final int MIN_LEFT = 10;
    static final int MIN_RIGHT = 160;
    static int BORDER1 = 20;

    public CBanner(Composite parent, int style) {
        super(parent, CBanner.checkStyle(style));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        CBanner.this.onDispose();
                        break;
                    }
                    case 3: {
                        CBanner.this.onMouseDown(e.x, e.y);
                        break;
                    }
                    case 7: {
                        CBanner.this.onMouseExit();
                        break;
                    }
                    case 5: {
                        CBanner.this.onMouseMove(e.x, e.y);
                        break;
                    }
                    case 4: {
                        CBanner.this.onMouseUp();
                        break;
                    }
                    case 9: {
                        CBanner.this.onPaint(e.gc);
                        break;
                    }
                    case 11: {
                        CBanner.this.onResize();
                    }
                }
            }
        };
        int[] events = new int[]{12, 3, 7, 5, 4, 9, 11};
        for (int i = 0; i < events.length; ++i) {
            this.addListener(events[i], listener);
        }
    }

    static int[] bezier(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3, int count) {
        double a0 = x0;
        double a1 = 3 * (x1 - x0);
        double a2 = 3 * (x0 + x2 - 2 * x1);
        double a3 = x3 - x0 + 3 * x1 - 3 * x2;
        double b0 = y0;
        double b1 = 3 * (y1 - y0);
        double b2 = 3 * (y0 + y2 - 2 * y1);
        double b3 = y3 - y0 + 3 * y1 - 3 * y2;
        int[] polygon = new int[2 * count + 2];
        for (int i = 0; i <= count; ++i) {
            double t = (double)i / (double)count;
            polygon[2 * i] = (int)(a0 + a1 * t + a2 * t * t + a3 * t * t * t);
            polygon[2 * i + 1] = (int)(b0 + b1 * t + b2 * t * t + b3 * t * t * t);
        }
        return polygon;
    }

    static int checkStyle(int style) {
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        boolean showCurve = this.left != null && this.right != null;
        int height = hHint;
        int width = wHint;
        Point bottomSize = new Point(0, 0);
        if (this.bottom != null) {
            Point trim = this.bottom.computeSize(width, -1);
            trim.x -= width;
            bottomSize = this.bottom.computeSize(width == -1 ? -1 : width - trim.x, -1);
            if (height != -1) {
                bottomSize.y = Math.min(bottomSize.y, height);
                height -= bottomSize.y + 3 + 1 + 2;
            }
        }
        if (showCurve && height != -1) {
            height -= 7;
        }
        Point rightSize = new Point(0, 0);
        if (this.right != null) {
            Point trim = this.right.computeSize(this.rightWidth, height);
            trim.x -= this.rightWidth;
            rightSize = this.right.computeSize(this.rightWidth == -1 ? -1 : this.rightWidth - trim.x, this.rightWidth == -1 ? -1 : height);
            if (width != -1) {
                rightSize.x = Math.min(rightSize.x, width);
                width -= rightSize.x + this.curve_width - 2 * this.curve_indent;
                width = Math.max(width, 10);
            }
        }
        Point leftSize = new Point(0, 0);
        if (this.left != null) {
            Point trim = this.left.computeSize(width, -1);
            trim.x -= width;
            leftSize = this.left.computeSize(width == -1 ? -1 : width - trim.x, -1);
        }
        int w = 0;
        int h = 0;
        h += bottomSize.y;
        if (this.bottom != null && (this.left != null || this.right != null)) {
            h += 6;
        }
        w += leftSize.x + rightSize.x;
        if (showCurve) {
            w += this.curve_width - 2 * this.curve_indent;
            h += 7;
        }
        h += this.left != null ? leftSize.y : rightSize.y;
        if (wHint != -1) {
            w = wHint;
        }
        if (hHint != -1) {
            h = hHint;
        }
        return new Point(w, h);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        return new Rectangle(x, y, width, height);
    }

    public Control getBottom() {
        this.checkWidget();
        return this.bottom;
    }

    public Rectangle getClientArea() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Control getLeft() {
        this.checkWidget();
        return this.left;
    }

    public Control getRight() {
        this.checkWidget();
        return this.right;
    }

    public int getRightWidth() {
        this.checkWidget();
        if (this.right == null) {
            return 0;
        }
        if (this.rightWidth == -1) {
            return this.right.computeSize((int)-1, (int)this.getSize().y).x;
        }
        return this.rightWidth;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public void layout(boolean changed) {
        this.checkWidget();
        Point size = this.getSize();
        boolean showCurve = this.left != null && this.right != null;
        int width = size.x;
        int height = size.y;
        Point bottomSize = new Point(0, 0);
        if (this.bottom != null) {
            Point trim = this.bottom.computeSize(width, -1);
            trim.x -= width;
            bottomSize = this.bottom.computeSize(width - trim.x, -1);
            bottomSize.y = Math.min(bottomSize.y, height);
            height -= bottomSize.y + 3 + 2 + 1;
        }
        if (showCurve) {
            height -= 7;
        }
        height = Math.max(0, height);
        Point rightSize = new Point(0, 0);
        if (this.right != null) {
            Point trim = this.right.computeSize(this.rightWidth, height);
            trim.x -= this.rightWidth;
            rightSize = this.right.computeSize(this.rightWidth == -1 ? -1 : this.rightWidth - trim.x, this.rightWidth == -1 ? -1 : height);
            rightSize.x = Math.min(rightSize.x, width);
            width -= rightSize.x + this.curve_width - 2 * this.curve_indent;
            width = Math.max(width, 10);
        }
        Point leftSize = new Point(0, 0);
        if (this.left != null) {
            Point trim = this.left.computeSize(width, -1);
            trim.x -= width;
            leftSize = this.left.computeSize(width - trim.x, -1);
        }
        int x = 0;
        int y = 0;
        int oldStart = this.curveStart;
        Rectangle leftRect = null;
        Rectangle rightRect = null;
        Rectangle bottomRect = null;
        if (this.bottom != null) {
            bottomRect = new Rectangle(x, y + size.y - bottomSize.y, bottomSize.x, bottomSize.y);
        }
        if (showCurve) {
            y += 4;
        }
        if (this.left != null) {
            leftRect = new Rectangle(x, y, leftSize.x, leftSize.y);
            this.curveStart = x + leftSize.x - this.curve_indent;
            x += leftSize.x + this.curve_width - 2 * this.curve_indent;
        }
        if (this.right != null) {
            rightRect = new Rectangle(x, y, rightSize.x, rightSize.y);
        }
        if (this.curveStart < oldStart) {
            this.redraw(this.curveStart - 200, 0, oldStart + this.curve_width - this.curveStart + 200 + 5, size.y, false);
        }
        if (this.curveStart > oldStart) {
            this.redraw(oldStart - 200, 0, this.curveStart + this.curve_width - oldStart + 200 + 5, size.y, false);
        }
        this.curveRect = new Rectangle(this.curveStart, 0, this.curve_width, size.y);
        this.update();
        if (bottomRect != null) {
            this.bottom.setBounds(bottomRect);
        }
        if (rightRect != null) {
            this.right.setBounds(rightRect);
        }
        if (leftRect != null) {
            this.left.setBounds(leftRect);
        }
    }

    void onDispose() {
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        this.left = null;
        this.right = null;
    }

    void onMouseDown(int x, int y) {
        if (this.curveRect.contains(x, y)) {
            this.dragging = true;
            this.rightDragDisplacement = this.curveStart - x + this.curve_width - this.curve_indent;
        }
    }

    void onMouseExit() {
        if (!this.dragging) {
            this.setCursor(null);
        }
    }

    void onMouseMove(int x, int y) {
        if (this.dragging) {
            Point size = this.getSize();
            if (0 >= x || x >= size.x) {
                return;
            }
            this.rightWidth = size.x - x - this.rightDragDisplacement;
            this.rightWidth = Math.max(160, this.rightWidth);
            this.layout();
            return;
        }
        if (this.curveRect.contains(x, y)) {
            this.setCursor(this.resizeCursor);
        } else {
            this.setCursor(null);
        }
    }

    void onMouseUp() {
        this.dragging = false;
    }

    void onPaint(GC gc) {
        Point size = this.getSize();
        Color border1 = this.getDisplay().getSystemColor(BORDER1);
        if (this.bottom != null && (this.left != null || this.right != null)) {
            gc.setForeground(border1);
            int y = this.bottom.getBounds().y - 2 - 1;
            gc.drawLine(0, y, size.x, y);
        }
        if (this.left == null || this.right == null) {
            return;
        }
        int[] line1 = new int[this.curve.length + 6];
        int index = 0;
        int x = this.curveStart;
        int y = 0;
        line1[index++] = x + 1;
        line1[index++] = size.y - 1;
        for (int i = 0; i < this.curve.length / 2; ++i) {
            line1[index++] = x + this.curve[2 * i];
            line1[index++] = y + this.curve[2 * i + 1];
        }
        line1[index++] = x + this.curve_width;
        line1[index++] = 0;
        line1[index++] = size.x;
        line1[index++] = 0;
        Color background = this.getBackground();
        if (this.getDisplay().getDepth() >= 15) {
            int[] line2 = new int[line1.length];
            index = 0;
            for (int i = 0; i < line1.length / 2; ++i) {
                line2[index] = line1[index++] - 1;
                line2[index] = line1[index++];
            }
            int[] line3 = new int[line1.length];
            index = 0;
            for (int i = 0; i < line1.length / 2; ++i) {
                line3[index] = line1[index++] + 1;
                line3[index] = line1[index++];
            }
            RGB from = border1.getRGB();
            RGB to = background.getRGB();
            int red = from.red + 3 * (to.red - from.red) / 4;
            int green = from.green + 3 * (to.green - from.green) / 4;
            int blue = from.blue + 3 * (to.blue - from.blue) / 4;
            Color color = new Color(this.getDisplay(), red, green, blue);
            gc.setForeground(color);
            gc.drawPolyline(line2);
            gc.drawPolyline(line3);
            color.dispose();
            int x1 = Math.max(0, this.curveStart - 200);
            gc.setForeground(background);
            gc.setBackground(border1);
            gc.fillGradientRectangle(x1, size.y - 1, this.curveStart - x1 + 1, 1, false);
        } else {
            int x1 = Math.max(0, this.curveStart - 200);
            gc.setForeground(border1);
            gc.drawLine(x1, size.y - 1, this.curveStart + 1, size.y - 1);
        }
        gc.setForeground(border1);
        gc.drawPolyline(line1);
    }

    void onResize() {
        this.updateCurve(this.getSize().y);
        this.layout();
    }

    public void setBottom(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.bottom != null && !this.bottom.isDisposed()) {
            Point size = this.bottom.getSize();
            this.bottom.setLocation(-200 - size.x, -200 - size.y);
        }
        this.bottom = control;
        this.layout();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setLeft(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.left != null && !this.left.isDisposed()) {
            Point size = this.left.getSize();
            this.left.setLocation(-200 - size.x, -200 - size.y);
        }
        this.left = control;
        this.layout();
    }

    public void setRight(Control control) {
        this.checkWidget();
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.right != null && !this.right.isDisposed()) {
            Point size = this.right.getSize();
            this.right.setLocation(-200 - size.x, -200 - size.y);
        }
        this.right = control;
        this.layout();
    }

    public void setRightWidth(int width) {
        this.checkWidget();
        if (width < -1) {
            SWT.error(5);
        }
        this.rightWidth = width;
        this.layout(true);
    }

    public void setSimple(boolean simple) {
        this.checkWidget();
        if (this.simple != simple) {
            this.simple = simple;
            if (simple) {
                this.curve_width = 5;
                this.curve_indent = -2;
            } else {
                this.curve_width = 50;
                this.curve_indent = 5;
            }
            this.updateCurve(this.getSize().y);
            this.layout();
            this.redraw();
        }
    }

    void updateCurve(int height) {
        int h = height - 1;
        this.curve = this.simple ? new int[]{0, h, 1, h, 2, h - 1, 3, h - 2, 3, 2, 4, 1, 5, 0} : CBanner.bezier(0, h + 1, 30, h + 1, this.curve_width - 30, 0, this.curve_width, 0, this.curve_width);
    }
}

