/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;

abstract class StyledTextRenderer {
    private Device device;
    protected Font regularFont;
    protected Font boldFont;
    protected Font italicFont;
    protected Font boldItalicFont;
    private int tabWidth;
    private int ascent;
    private int descent;
    private int lineEndSpaceWidth;

    StyledTextRenderer(Device device, Font regularFont) {
        this.device = device;
        this.regularFont = regularFont;
    }

    void calculateLineHeight() {
        GC gc = this.getGC();
        this.lineEndSpaceWidth = gc.stringExtent((String)" ").x;
        Font originalFont = gc.getFont();
        FontMetrics metrics = gc.getFontMetrics();
        this.ascent = Math.max(this.ascent, metrics.getAscent() + metrics.getLeading());
        this.descent = Math.max(this.descent, metrics.getDescent());
        gc.setFont(this.getFont(1));
        metrics = gc.getFontMetrics();
        this.ascent = Math.max(this.ascent, metrics.getAscent() + metrics.getLeading());
        this.descent = Math.max(this.descent, metrics.getDescent());
        gc.setFont(this.getFont(2));
        metrics = gc.getFontMetrics();
        this.ascent = Math.max(this.ascent, metrics.getAscent() + metrics.getLeading());
        this.descent = Math.max(this.descent, metrics.getDescent());
        gc.setFont(this.getFont(3));
        metrics = gc.getFontMetrics();
        this.ascent = Math.max(this.ascent, metrics.getAscent() + metrics.getLeading());
        this.descent = Math.max(this.descent, metrics.getDescent());
        gc.setFont(originalFont);
        this.disposeGC(gc);
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
    }

    protected abstract void disposeGC(GC var1);

    void drawLine(String line, int lineIndex, int paintY, GC gc, Color widgetBackground, Color widgetForeground, boolean clearBackground) {
        int lineOffset = this.getContent().getOffsetAtLine(lineIndex);
        int lineLength = line.length();
        Point selection = this.getSelection();
        int selectionStart = selection.x;
        int selectionEnd = selection.y;
        int leftMargin = this.getLeftMargin();
        Color lineBackground = null;
        TextLayout layout = this.getTextLayout(line, lineOffset);
        Rectangle client = this.getClientArea();
        StyledTextEvent event = this.getLineBackgroundData(lineOffset, line);
        if (event != null) {
            lineBackground = event.lineBackground;
        }
        if (lineBackground == null) {
            lineBackground = widgetBackground;
        }
        if (clearBackground && (!this.isFullLineSelection() || selectionStart > lineOffset || selectionEnd <= lineOffset + lineLength)) {
            gc.setBackground(lineBackground);
            gc.setForeground(lineBackground);
            gc.fillRectangle(client.x + leftMargin, paintY, client.width, this.ascent + this.descent);
        }
        int paintX = client.x + leftMargin - this.getHorizontalPixel();
        if (selectionStart != selectionEnd) {
            Rectangle rect = layout.getLineBounds(0);
            this.drawLineBreakSelection(line, lineOffset, paintX + rect.x + rect.width, paintY, gc);
        }
        gc.setForeground(widgetForeground);
        gc.setBackground(lineBackground);
        if (selectionStart == selectionEnd || selectionEnd <= lineOffset && selectionStart > lineOffset + lineLength - 1) {
            layout.draw(gc, paintX, paintY);
        } else {
            int start = Math.max(0, selectionStart - lineOffset);
            int end = Math.min(lineLength, selectionEnd - lineOffset);
            layout.draw(gc, paintX, paintY, start, end - 1, this.getSelectionForeground(), this.getSelectionBackground());
        }
        this.disposeTextLayout(layout);
    }

    protected abstract void drawLineBreakSelection(String var1, int var2, int var3, int var4, GC var5);

    protected abstract Rectangle getClientArea();

    protected abstract StyledTextContent getContent();

    Device getDevice() {
        return this.device;
    }

    int getBaseline() {
        return this.ascent;
    }

    protected abstract int[] getBidiSegments(int var1, String var2);

    Font getFont(int style) {
        switch (style) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(style));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(style));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(style));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int style) {
        FontData[] fontDatas = this.regularFont.getFontData();
        for (int i = 0; i < fontDatas.length; ++i) {
            fontDatas[i].setStyle(style);
        }
        return fontDatas;
    }

    protected abstract GC getGC();

    protected abstract int getHorizontalPixel();

    protected int getLeftMargin() {
        return 0;
    }

    int getLineEndSpaceWidth() {
        return this.lineEndSpaceWidth;
    }

    protected abstract StyledTextEvent getLineBackgroundData(int var1, String var2);

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    StyledTextEvent getLineStyleData(StyledTextEvent event, int lineOffset, String line) {
        int lineLength = line.length();
        if (event.styles != null && this.getWordWrap()) {
            event.styles = this.getVisualLineStyleData(event.styles, lineOffset, lineLength);
        }
        if (event.styles == null) {
            event.styles = new StyleRange[0];
        }
        return event;
    }

    protected abstract StyledTextEvent getLineStyleData(int var1, String var2);

    protected abstract int getOrientation();

    protected int getRightMargin() {
        return 0;
    }

    protected abstract Color getSelectionForeground();

    protected abstract Color getSelectionBackground();

    protected abstract Point getSelection();

    StyleRange[] getVisualLineStyleData(StyleRange[] logicalStyles, int lineOffset, int lineLength) {
        int lineEnd = lineOffset + lineLength;
        int oldStyleCount = logicalStyles.length;
        int newStyleCount = 0;
        for (int i = 0; i < oldStyleCount; ++i) {
            StyleRange style = logicalStyles[i];
            if (style.start >= lineEnd || style.start + style.length <= lineOffset) continue;
            ++newStyleCount;
        }
        if (newStyleCount != oldStyleCount) {
            StyleRange[] newStyles = new StyleRange[newStyleCount];
            int j = 0;
            for (int i = 0; i < oldStyleCount; ++i) {
                StyleRange style = logicalStyles[i];
                if (style.start >= lineEnd || style.start + style.length <= lineOffset) continue;
                newStyles[j++] = logicalStyles[i];
            }
            logicalStyles = newStyles;
        }
        return logicalStyles;
    }

    protected abstract boolean getWordWrap();

    protected abstract boolean isFullLineSelection();

    void setTabLength(int tabLength) {
        GC gc = this.getGC();
        StringBuffer tabBuffer = new StringBuffer(tabLength);
        for (int i = 0; i < tabLength; ++i) {
            tabBuffer.append(' ');
        }
        this.tabWidth = gc.stringExtent((String)tabBuffer.toString()).x;
        this.disposeGC(gc);
    }

    TextLayout getTextLayout(String line, int lineOffset) {
        TextLayout layout = this.createTextLayout(lineOffset);
        layout.setFont(this.regularFont);
        layout.setAscent(this.ascent);
        layout.setDescent(this.descent);
        layout.setText(line);
        layout.setOrientation(this.getOrientation());
        layout.setSegments(this.getBidiSegments(lineOffset, line));
        layout.setTabs(new int[]{this.tabWidth});
        int length = line.length();
        StyledTextEvent event = this.getLineStyleData(lineOffset, line);
        StyleRange[] styles = event != null ? event.styles : null;
        int lastOffset = 0;
        if (styles != null) {
            for (int styleIndex = 0; styleIndex < styles.length; ++styleIndex) {
                int end;
                int start;
                StyleRange style = styles[styleIndex];
                if (style.isUnstyled()) continue;
                if (lineOffset > style.start) {
                    start = 0;
                    end = Math.min(length, style.length - lineOffset + style.start);
                } else {
                    start = style.start - lineOffset;
                    end = Math.min(length, start + style.length);
                }
                if (start >= length) break;
                if (lastOffset != start) {
                    layout.setStyle(null, lastOffset, start - 1);
                }
                TextStyle textStyle = new TextStyle(this.getFont(style.fontStyle), style.foreground, style.background);
                layout.setStyle(textStyle, start, end - 1);
                lastOffset = end;
            }
        }
        if (lastOffset != length) {
            layout.setStyle(null, lastOffset, length);
        }
        return layout;
    }

    TextLayout createTextLayout(int lineOffset) {
        return new TextLayout(this.device);
    }

    void disposeTextLayout(TextLayout layout) {
        layout.dispose();
    }
}

