/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    private int shellHandle;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$Clipboard;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
        int widgetClass = OS.topLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(null, null, widgetClass, display.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtRealizeWidget(this.shellHandle);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$Clipboard == null ? (class$org$eclipse$swt$dnd$Clipboard = Clipboard.class$("org.eclipse.swt.dnd.Clipboard")) : class$org$eclipse$swt$dnd$Clipboard).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        if (this.display == null) {
            DND.error(24);
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (this.display.isDisposed()) {
            DND.error(24);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
        }
        this.shellHandle = 0;
        this.display = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContents(Transfer transfer) {
        int xDisplay;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((xDisplay = OS.XtDisplay(this.shellHandle)) == 0) {
            return null;
        }
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return null;
        }
        if (OS.XmClipboardStartRetrieve(xDisplay, xWindow, OS.XtLastTimestampProcessed(xDisplay)) != 1) {
            return null;
        }
        byte[] data = null;
        byte[] type = null;
        try {
            int[] length = new int[1];
            String[] supportedTypes = transfer.getTypeNames();
            for (int i = 0; i < supportedTypes.length; ++i) {
                byte[] bName = Converter.wcsToMbcs(null, supportedTypes[i], true);
                if (OS.XmClipboardInquireLength(xDisplay, xWindow, bName, length) != 1) continue;
                type = bName;
                break;
            }
            if (type == null) {
                Object var8_10 = null;
                return var8_10;
            }
            data = new byte[length[0]];
            if (OS.XmClipboardRetrieve(xDisplay, xWindow, type, data, length[0], new int[1], new int[1]) != 1) {
                Object var8_11 = null;
                return var8_11;
            }
        }
        finally {
            OS.XmClipboardEndRetrieve(xDisplay, xWindow);
        }
        int pValue = OS.XtMalloc(data.length);
        if (pValue == 0) {
            return null;
        }
        try {
            OS.memmove(pValue, data, data.length);
            TransferData transferData = new TransferData();
            transferData.type = OS.XmInternAtom(xDisplay, type, true);
            transferData.length = data.length;
            transferData.format = 8;
            transferData.pValue = pValue;
            transferData.result = 1;
            Object object = transfer.nativeToJava(transferData);
            return object;
        }
        finally {
            OS.XtFree(pValue);
        }
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Object[] data, Transfer[] dataTypes) {
        int xWindow;
        int xDisplay;
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        if ((xDisplay = OS.XtDisplay(this.shellHandle)) == 0) {
            DND.error(2002);
        }
        if ((xWindow = OS.XtWindow(this.shellHandle)) == 0) {
            DND.error(2002);
        }
        int[] item_id = new int[1];
        if (OS.XmClipboardStartCopy(xDisplay, xWindow, 0, OS.XtLastTimestampProcessed(xDisplay), this.shellHandle, 0, item_id) != 1) {
            DND.error(2002);
        }
        try {
            for (int i = 0; i < dataTypes.length; ++i) {
                int[] ids = dataTypes[i].getTypeIds();
                String[] names = dataTypes[i].getTypeNames();
                for (int j = 0; j < names.length; ++j) {
                    TransferData transferData = new TransferData();
                    transferData.type = ids[j];
                    dataTypes[i].javaToNative(data[i], transferData);
                    if (transferData.result != 1) {
                        DND.error(2002);
                    }
                    try {
                        if (transferData.format != 8) {
                            DND.error(2002);
                        }
                        byte[] buffer = new byte[transferData.length];
                        OS.memmove(buffer, transferData.pValue, transferData.length);
                        byte[] bName = Converter.wcsToMbcs(null, names[j], true);
                        if (OS.XmClipboardCopy(xDisplay, xWindow, item_id[0], bName, buffer, transferData.length, 0, null) == 1) continue;
                        DND.error(2002);
                        continue;
                    }
                    finally {
                        OS.XtFree(transferData.pValue);
                    }
                }
            }
        }
        finally {
            OS.XmClipboardEndCopy(xDisplay, xWindow, item_id[0]);
        }
    }

    public TransferData[] getAvailableTypes() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return new TransferData[0];
        }
        byte[][] types = this._getAvailableTypes();
        TransferData[] result = new TransferData[types.length];
        for (int i = 0; i < types.length; ++i) {
            int atom = OS.XmInternAtom(xDisplay, types[i], true);
            result[i] = new TransferData();
            result[i].type = atom;
        }
        return result;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        byte[][] types = this._getAvailableTypes();
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = new String(Converter.mbcsToWcs(null, types[i]));
        }
        return names;
    }

    private byte[][] _getAvailableTypes() {
        Object types = new byte[][]{};
        int[] count = new int[1];
        int[] max_length = new int[1];
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return types;
        }
        int xWindow = OS.XtWindow(this.shellHandle);
        if (xWindow == 0) {
            return types;
        }
        if (OS.XmClipboardInquireCount(xDisplay, xWindow, count, max_length) == 0) {
            return types;
        }
        if (count[0] == 0) {
            return types;
        }
        types = new byte[count[0]][];
        int index = -1;
        for (int i = 0; i < count[0]; ++i) {
            byte[] buffer = new byte[max_length[0]];
            int[] copied_length = new int[1];
            int rc = OS.XmClipboardInquireFormat(xDisplay, xWindow, i + 1, buffer, buffer.length, copied_length);
            if (rc != 1) continue;
            byte[] buffer2 = new byte[copied_length[0]];
            System.arraycopy(buffer, 0, buffer2, 0, copied_length[0]);
            types[++index] = buffer2;
        }
        if (index == -1) {
            types = new byte[0][0];
        } else if (index + 1 < ((byte[][])types).length) {
            byte[][] newTypes = new byte[index + 1][];
            System.arraycopy(types, 0, newTypes, 0, index + 1);
            types = newTypes;
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

