/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    int dialog;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String fileName = "";
    String filterPath = "";
    String fullPath;
    boolean cancel = false;
    static final String FILTER = "*";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int cancelPressed(int widget, int client, int call) {
        this.cancel = true;
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    int itemSelected(int widget, int client, int call) {
        int fileList = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
        if (fileList == 0) {
            return 0;
        }
        int selectionText = OS.XmFileSelectionBoxGetChild(this.dialog, 13);
        if (selectionText == 0) {
            return 0;
        }
        int[] argList = new int[]{OS.XmNselectedItems, 0, OS.XmNselectedItemCount, 0};
        OS.XtGetValues(fileList, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int ptr = 0;
        if (itemCount == 0) {
            int[] argList2 = new int[]{OS.XmNdirectory, 0};
            OS.XtGetValues(this.dialog, argList2, argList2.length / 2);
            ptr = argList2[1];
        } else {
            int[] buffer = new int[1];
            OS.memmove(buffer, items, 4);
            ptr = buffer[0];
        }
        if (ptr == 0) {
            return 0;
        }
        Display display = this.parent.getDisplay();
        int[] table = new int[]{display.tabMapping, display.crMapping};
        int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
        if (itemCount == 0) {
            OS.XmStringFree(ptr);
        }
        if (address == 0) {
            return 0;
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, address, length);
        OS.XtFree(address);
        OS.XmTextSetString(selectionText, buffer);
        OS.XmTextSetInsertionPosition(selectionText, OS.XmTextGetLastPosition(selectionText));
        return 0;
    }

    int okPressed(int widget, int client, int call) {
        String fullPath = null;
        String fileName = null;
        String[] fileNames = null;
        int[] argList = new int[]{OS.XmNdirSpec, 0, OS.XmNdirectory, 0};
        OS.XtGetValues(this.dialog, argList, argList.length / 2);
        int xmString1 = argList[1];
        Display display = this.parent.getDisplay();
        int[] table = new int[]{display.tabMapping, display.crMapping};
        int ptr = OS.XmStringUnparse(xmString1, null, 0, 0, table, table.length, 0);
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            OS.XtFree(ptr);
            fullPath = new String(Converter.mbcsToWcs(null, buffer)).trim();
        }
        OS.XmStringFree(xmString1);
        if ((this.style & 2) != 0) {
            int fileList = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
            if (fileList == 0) {
                return 0;
            }
            int[] argList2 = new int[]{OS.XmNselectedItems, 0, OS.XmNselectedItemCount, 0};
            OS.XtGetValues(fileList, argList2, argList2.length / 2);
            int items = argList2[1];
            int itemCount = argList2[3];
            int[] buffer1 = new int[1];
            fileNames = new String[itemCount];
            boolean match = false;
            for (int i = 0; i < itemCount; ++i) {
                OS.memmove(buffer1, items, 4);
                ptr = buffer1[0];
                int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
                if (address != 0) {
                    int length = OS.strlen(address);
                    byte[] buffer = new byte[length];
                    OS.memmove(buffer, address, length);
                    OS.XtFree(address);
                    String fullFilename = new String(Converter.mbcsToWcs(null, buffer));
                    int index = fullFilename.lastIndexOf(SEPARATOR);
                    fileNames[i] = fullFilename.substring(index + 1, fullFilename.length());
                    if (fullFilename.equals(fullPath)) {
                        match = true;
                    }
                }
                items += 4;
            }
            if (match) {
                fileName = fileNames[0];
            } else {
                int index = fullPath.lastIndexOf(SEPARATOR);
                fileName = fullPath.substring(index + 1, fullPath.length());
                fileNames = new String[]{fileName};
            }
        } else {
            int index = fullPath.lastIndexOf(SEPARATOR);
            fileName = fullPath.substring(index + 1, fullPath.length());
            fileNames = new String[]{fileName};
        }
        if (fileName.equals("")) {
            int[] argList1 = new int[]{OS.XmNdirMask, 0};
            OS.XtGetValues(this.dialog, argList1, argList1.length / 2);
            int directoryHandle = argList1[1];
            int[] argList2 = new int[]{OS.XmNpattern, directoryHandle};
            OS.XtSetValues(this.dialog, argList2, argList2.length / 2);
            OS.XmStringFree(directoryHandle);
            return 0;
        }
        int xmString2 = argList[3];
        ptr = OS.XmStringUnparse(xmString2, null, 0, 0, table, table.length, 0);
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            OS.XtFree(ptr);
            this.filterPath = new String(Converter.mbcsToWcs(null, buffer));
        }
        OS.XmStringFree(xmString2);
        int length = this.filterPath.length();
        if (length > 0 && this.filterPath.charAt(length - 1) == SEPARATOR) {
            this.filterPath = this.filterPath.substring(0, length - 1);
        }
        this.fullPath = fullPath;
        this.fileName = fileName;
        this.fileNames = fileNames;
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String open() {
        int length;
        String filter;
        String string;
        Display appContext = Display.getCurrent();
        boolean destroyContext = appContext == null;
        if (destroyContext) {
            appContext = new Display();
        }
        int display = appContext.xDisplay;
        int parentHandle = appContext.shellHandle;
        if (this.parent != null && this.parent.display == appContext) {
            if (OS.IsAIX) {
                this.parent.realizeWidget();
            }
            parentHandle = this.parent.shellHandle;
        }
        if ((string = this.title).length() == 0) {
            string = " ";
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, string, true);
        int xmStringPtr1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        this.fullPath = null;
        this.fileNames = new String[0];
        String mask = FILTER;
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions.length != 0 && this.filterExtensions.length == 1 && (filter = this.filterExtensions[0]).indexOf(59, 0) == -1) {
            mask = filter;
        }
        byte[] buffer2 = Converter.wcsToMbcs(null, mask, true);
        int xmStringPtr2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if ((length = this.filterPath.length()) == 0 || this.filterPath.charAt(length - 1) != SEPARATOR) {
            this.filterPath = this.filterPath + SEPARATOR;
        }
        byte[] buffer3 = Converter.wcsToMbcs(null, this.filterPath, true);
        int xmStringPtr3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        int[] argList1 = new int[]{OS.XmNresizePolicy, 0, OS.XmNdialogStyle, 1, OS.XmNwidth, OS.XDisplayWidth(display, OS.XDefaultScreen(display)) * 4 / 9, OS.XmNpathMode, 0, OS.XmNdialogTitle, xmStringPtr1, OS.XmNpattern, xmStringPtr2, OS.XmNdirMask, xmStringPtr3};
        byte[] name = new byte[]{0};
        this.dialog = OS.XmCreateFileSelectionDialog(parentHandle, name, argList1, argList1.length / 2);
        int child = OS.XmFileSelectionBoxGetChild(this.dialog, 7);
        if (child != 0) {
            OS.XtUnmanageChild(child);
        }
        OS.XmStringFree(xmStringPtr1);
        OS.XmStringFree(xmStringPtr2);
        OS.XmStringFree(xmStringPtr3);
        if (this.fileName != null && this.fileName.length() > 0) {
            int newDirSpec;
            byte[] buffer4 = Converter.wcsToMbcs(null, this.fileName, true);
            int xmStringPtr4 = OS.XmStringParseText(buffer4, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] argList2 = new int[]{OS.XmNdirSpec, 0};
            OS.XtGetValues(this.dialog, argList2, argList2.length / 2);
            int oldDirSpec = argList2[1];
            argList2[1] = newDirSpec = OS.XmStringConcat(oldDirSpec, xmStringPtr4);
            OS.XtSetValues(this.dialog, argList2, argList2.length / 2);
            OS.XmStringFree(xmStringPtr4);
            OS.XmStringFree(oldDirSpec);
            OS.XmStringFree(newDirSpec);
        }
        Callback cancelCallback = new Callback(this, "cancelPressed", 3);
        int cancelAddress = cancelCallback.getAddress();
        OS.XtAddCallback(this.dialog, OS.XmNcancelCallback, cancelAddress, 0);
        Callback okCallback = new Callback(this, "okPressed", 3);
        int okAddress = okCallback.getAddress();
        OS.XtAddCallback(this.dialog, OS.XmNokCallback, okAddress, 0);
        Callback selectCallback = null;
        if ((this.style & 2) != 0 && (child = OS.XmFileSelectionBoxGetChild(this.dialog, 8)) != 0) {
            int[] argList3 = new int[]{OS.XmNselectionPolicy, 2};
            OS.XtSetValues(child, argList3, argList3.length / 2);
            selectCallback = new Callback(this, "itemSelected", 3);
            int selectAddress = selectCallback.getAddress();
            if (selectAddress == 0) {
                this.error(3);
            }
            OS.XtAddCallback(child, OS.XmNextendedSelectionCallback, selectAddress, 0);
        }
        OS.XtManageChild(this.dialog);
        while (OS.XtIsRealized(this.dialog) && OS.XtIsManaged(this.dialog)) {
            if (appContext.readAndDispatch()) continue;
            appContext.sleep();
        }
        if (OS.XtIsRealized(this.dialog)) {
            OS.XtDestroyWidget(this.dialog);
        }
        if (destroyContext) {
            appContext.dispose();
        }
        okCallback.dispose();
        cancelCallback.dispose();
        if (selectCallback != null) {
            selectCallback.dispose();
        }
        return this.fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

