/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    int scrollHandle;

    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        int hScroll = this.display.scrolledMarginX;
        int vScroll = this.display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            width += hScroll * 10;
            height += vScroll;
        } else {
            width += hScroll;
            height += vScroll * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int[] argList = new int[]{OS.XmNtitleString, 0, OS.XmNborderWidth, (this.style & 0x800) != 0 ? 1 : 0, OS.XmNorientation, (this.style & 0x100) != 0 ? 2 : 1, OS.XmNprocessingDirection, (this.style & 0x100) != 0 ? 3 : 1, OS.XmNancestorSensitive, 1};
        int parentHandle = this.parent.handle;
        this.handle = OS.XmCreateScale(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        byte[] scrollbar = Converter.wcsToMbcs(null, "Scrollbar\u0000");
        this.scrollHandle = OS.XtNameToWidget(this.handle, scrollbar);
    }

    void deregister() {
        super.deregister();
        if (this.scrollHandle != 0) {
            this.display.removeWidget(this.scrollHandle);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        return 1;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNmaximum, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNminimum, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNscaleMultiple, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNvalue, 0};
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 25);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, windowProc, 15);
        if (this.scrollHandle != 0) {
            OS.XtAddEventHandler(this.scrollHandle, 1, false, windowProc, 6);
            OS.XtAddEventHandler(this.scrollHandle, 2, false, windowProc, 7);
            OS.XtInsertEventHandler(this.scrollHandle, 0x200000, false, windowProc, 5, 1);
        }
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    void register() {
        super.register();
        if (this.scrollHandle != 0) {
            this.display.addWidget(this.scrollHandle, this);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNmaximum, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNminimum, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNscaleMultiple, pageIncrement};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setSelection(int selection) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNvalue, selection};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    int XmNdragCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        this.postEvent(13);
        return 0;
    }
}

