/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetHistory;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CheatSheetPlugin
extends AbstractUIPlugin {
    private static CheatSheetPlugin plugin;
    private boolean resourceBundleInitialized = false;
    private ResourceBundle resourceBundle;
    private CheatSheetHistory history = null;
    private DocumentBuilder documentBuilder = null;
    private static final String DEFAULT_CHEATSHEET_STATE_FILENAME = "cheatsheet.xml";
    private static final String MEMENTO_TAG_CHEATSHEET = "cheatsheet";
    private static final String MEMENTO_TAG_VERSION = "version";
    private static final String[] VERSION_STRING;
    private static final String MEMENTO_TAG_CHEATSHEET_HISTORY = "cheatsheetHistory";

    public static String getResourceString(String key) {
        try {
            if (plugin != null) {
                return Platform.getResourceString((Bundle)plugin.getBundle(), (String)key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return key;
    }

    public static CheatSheetPlugin getPlugin() {
        return plugin;
    }

    public static String formatResourceString(String key, Object[] args) {
        return MessageFormat.format(CheatSheetPlugin.getResourceString(key), args);
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        return image;
    }

    public ResourceBundle getResourceBundle() {
        if (!this.resourceBundleInitialized) {
            this.resourceBundleInitialized = true;
            try {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ui.internal.cheatsheets.CheatsheetPluginResources");
            }
            catch (MissingResourceException x) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public CheatSheetHistory getCheatSheetHistory() {
        if (this.history == null) {
            this.history = new CheatSheetHistory(CheatSheetRegistryReader.getInstance());
            this.restoreCheatSheetHistory();
        }
        return this.history;
    }

    private File getCheatSheetStateFile() {
        IPath path = CheatSheetPlugin.getPlugin().getStateLocation();
        path = path.append(DEFAULT_CHEATSHEET_STATE_FILENAME);
        return path.toFile();
    }

    public DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, CheatSheetPlugin.getResourceString("%ERROR_CREATING_DOCUMENT_BUILDER"), (Throwable)e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return this.documentBuilder;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        String imageFileName = "icons/full/obj16/skip_status.gif";
        URL imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_SKIP", imageDescriptor);
        imageFileName = "icons/full/obj16/complete_status.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_COMPLETE", imageDescriptor);
        imageFileName = "icons/full/clcl16/linkto_help.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_HELP", imageDescriptor);
        imageFileName = "icons/full/clcl16/start_cheatsheet.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_START", imageDescriptor);
        imageFileName = "icons/full/clcl16/restart_cheatsheet.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_RESTART", imageDescriptor);
        imageFileName = "icons/full/clcl16/start_task.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_BUTTON_START", imageDescriptor);
        imageFileName = "icons/full/clcl16/skip_task.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_BUTTON_SKIP", imageDescriptor);
        imageFileName = "icons/full/clcl16/complete_task.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_BUTTON_COMPLETE", imageDescriptor);
        imageFileName = "icons/full/clcl16/restart_task.gif";
        imageURL = CheatSheetPlugin.getPlugin().find((IPath)new Path(imageFileName));
        imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        reg.put("CHEATSHEET_ITEM_BUTTON_RESTART", imageDescriptor);
    }

    private void restoreCheatSheetHistory() {
        Platform.run((ISafeRunnable)new SafeRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block15: {
                    InputStreamReader reader;
                    block14: {
                        reader = null;
                        File stateFile = CheatSheetPlugin.this.getCheatSheetStateFile();
                        FileInputStream input = new FileInputStream(stateFile);
                        reader = new InputStreamReader((InputStream)input, "utf-8");
                        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                        IMemento childMem = memento.getChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY);
                        if (childMem == null) break block14;
                        CheatSheetPlugin.this.history.restoreState(childMem);
                    }
                    Object var7_10 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block15;
                    }
                    catch (IOException e2) {
                        String message2 = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                        Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                    }
                    break block15;
                    {
                        catch (FileNotFoundException e) {
                            Object var7_11 = null;
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                break block15;
                            }
                            catch (IOException e2) {
                                String message2 = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                                Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                            }
                            break block15;
                        }
                        catch (Exception e) {
                            String message = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                            Object var7_12 = null;
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                break block15;
                            }
                            catch (IOException e2) {
                                String message2 = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                                Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e2) {
                            String message2 = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                            Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                        }
                        throw throwable;
                    }
                }
            }

            public void handleException(Throwable e) {
                String message = CheatSheetPlugin.getResourceString("%ERROR_READING_STATE_FILE");
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    private void saveCheatSheetHistory() {
        Platform.run((ISafeRunnable)new SafeRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block11: {
                    XMLMemento memento = XMLMemento.createWriteRoot((String)CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET);
                    memento.putString(CheatSheetPlugin.MEMENTO_TAG_VERSION, VERSION_STRING[1]);
                    CheatSheetPlugin.this.getCheatSheetHistory().saveState(memento.createChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY));
                    File stateFile = CheatSheetPlugin.this.getCheatSheetStateFile();
                    OutputStreamWriter writer = null;
                    FileOutputStream stream = new FileOutputStream(stateFile);
                    writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
                    memento.save((Writer)writer);
                    Object var8_6 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {
                        String message2 = CheatSheetPlugin.getResourceString("%ERROR_WRITING_STATE_FILE");
                        Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                    }
                    break block11;
                    {
                        catch (IOException e) {
                            stateFile.delete();
                            String message = CheatSheetPlugin.getResourceString("%ERROR_WRITING_STATE_FILE");
                            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                            Object var8_7 = null;
                            try {
                                if (writer != null) {
                                    writer.close();
                                }
                                break block11;
                            }
                            catch (IOException e2) {
                                String message2 = CheatSheetPlugin.getResourceString("%ERROR_WRITING_STATE_FILE");
                                Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e2) {
                            String message2 = CheatSheetPlugin.getResourceString("%ERROR_WRITING_STATE_FILE");
                            Status status2 = new Status(4, "org.eclipse.ui.cheatsheets", 0, message2, (Throwable)e2);
                            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status2);
                        }
                        throw throwable;
                    }
                }
            }

            public void handleException(Throwable e) {
                String message = CheatSheetPlugin.getResourceString("%ERROR_WRITING_STATE_FILE");
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, e);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            }
        });
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.history != null) {
            this.saveCheatSheetHistory();
        }
        CheatSheetRegistryReader.getInstance().stop();
    }

    static {
        VERSION_STRING = new String[]{"0.0", "3.0.0"};
    }
}

