/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Menu;

public class CoolBarManager
extends ContributionManager
implements ICoolBarManager {
    public static final String USER_SEPARATOR = "UserSeparator";
    private ArrayList cbItemsCreationOrder = new ArrayList();
    private MenuManager contextMenuManager = null;
    private CoolBar coolBar = null;
    private int itemStyle = 0;

    public CoolBarManager() {
    }

    public CoolBarManager(CoolBar coolBar) {
        this();
        Assert.isNotNull(coolBar);
        this.coolBar = coolBar;
        this.itemStyle = coolBar.getStyle();
    }

    public CoolBarManager(int style) {
        this.itemStyle = style;
    }

    public void add(IToolBarManager toolBarManager) {
        Assert.isNotNull(toolBarManager);
        super.add(new ToolBarContributionItem(toolBarManager));
    }

    private ArrayList adjustContributionList(ArrayList contributionList) {
        if (contributionList.size() != 0) {
            IContributionItem item = (IContributionItem)contributionList.get(0);
            if (item.isSeparator()) {
                contributionList.remove(0);
            }
            ListIterator iterator = contributionList.listIterator();
            while (iterator.hasNext()) {
                item = (IContributionItem)iterator.next();
                if (!item.isSeparator()) continue;
                while (iterator.hasNext() && (item = (IContributionItem)iterator.next()).isSeparator()) {
                    iterator.remove();
                }
            }
            item = (IContributionItem)contributionList.get(contributionList.size() - 1);
            if (item.isSeparator()) {
                contributionList.remove(contributionList.size() - 1);
            }
        }
        return contributionList;
    }

    protected boolean allowItem(IContributionItem itemToAdd) {
        if (itemToAdd == null) {
            return true;
        }
        String firstId = itemToAdd.getId();
        if (firstId == null) {
            return true;
        }
        IContributionItem[] currentItems = this.getItems();
        for (int i = 0; i < currentItems.length; ++i) {
            String secondId;
            IContributionItem currentItem = currentItems[i];
            if (currentItem == null || !firstId.equals(secondId = currentItem.getId())) continue;
            if (Policy.TRACE_TOOLBAR) {
                System.out.println("Trying to add a duplicate item.");
                new Exception().printStackTrace(System.out);
                System.out.println("DONE --------------------------");
            }
            return false;
        }
        return true;
    }

    private void collapseSeparators(ListIterator iterator) {
        while (iterator.hasNext()) {
            IContributionItem item = (IContributionItem)iterator.next();
            if (item.isSeparator()) continue;
            iterator.previous();
            return;
        }
    }

    private boolean coolBarExist() {
        return this.coolBar != null && !this.coolBar.isDisposed();
    }

    public CoolBar createControl(Composite parent) {
        Assert.isNotNull(parent);
        if (!this.coolBarExist()) {
            this.coolBar = new CoolBar(parent, this.itemStyle);
            this.coolBar.setMenu(this.getContextMenuControl());
            this.coolBar.setLocked(false);
            this.update(false);
        }
        return this.coolBar;
    }

    public void dispose() {
        if (this.coolBarExist()) {
            IContributionItem[] items = this.getItems();
            for (int i = 0; i < items.length; ++i) {
                items[i].dispose();
            }
            this.coolBar.dispose();
            this.coolBar = null;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
            this.contextMenuManager = null;
        }
    }

    private void dispose(CoolItem item) {
        if (item != null && !item.isDisposed()) {
            item.setData(null);
            Control control = item.getControl();
            if (control != null && !control.isDisposed()) {
                item.setControl(null);
            }
            item.dispose();
        }
    }

    private CoolItem findCoolItem(IContributionItem item) {
        if (this.coolBar == null) {
            return null;
        }
        CoolItem[] items = this.coolBar.getItems();
        for (int i = 0; i < items.length; ++i) {
            CoolItem coolItem = items[i];
            IContributionItem data = (IContributionItem)coolItem.getData();
            if (data == null || !data.equals(item)) continue;
            return coolItem;
        }
        return null;
    }

    private int[] getAdjustedWrapIndices(int[] wraps) {
        int[] adjustedWrapIndices;
        if (wraps.length == 0) {
            adjustedWrapIndices = new int[]{0};
        } else if (wraps[0] != 0) {
            adjustedWrapIndices = new int[wraps.length + 1];
            adjustedWrapIndices[0] = 0;
            for (int i = 0; i < wraps.length; ++i) {
                adjustedWrapIndices[i + 1] = wraps[i];
            }
        } else {
            adjustedWrapIndices = wraps;
        }
        return adjustedWrapIndices;
    }

    private Menu getContextMenuControl() {
        if (this.contextMenuManager != null && this.coolBar != null) {
            Menu menuWidget = this.contextMenuManager.getMenu();
            if (menuWidget == null || menuWidget.isDisposed()) {
                menuWidget = this.contextMenuManager.createContextMenu((Control)this.coolBar);
            }
            return menuWidget;
        }
        return null;
    }

    public IMenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    public CoolBar getControl() {
        return this.coolBar;
    }

    private ArrayList getItemList() {
        IContributionItem[] cbItems = this.getItems();
        ArrayList<IContributionItem> list = new ArrayList<IContributionItem>(cbItems.length);
        for (int i = 0; i < cbItems.length; ++i) {
            list.add(cbItems[i]);
        }
        return list;
    }

    public boolean getLockLayout() {
        if (!this.coolBarExist()) {
            return false;
        }
        return this.coolBar.getLocked();
    }

    private int getNumRows(IContributionItem[] items) {
        int numRows = 1;
        boolean separatorFound = false;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].isSeparator()) {
                separatorFound = true;
            }
            if (!separatorFound || !items[i].isVisible() || items[i].isGroupMarker() || items[i].isSeparator()) continue;
            ++numRows;
            separatorFound = false;
        }
        return numRows;
    }

    public int getStyle() {
        return this.itemStyle;
    }

    protected void itemAdded(IContributionItem item) {
        Assert.isNotNull(item);
        super.itemAdded(item);
        int insertedAt = this.indexOf(item);
        boolean replaced = false;
        int size = this.cbItemsCreationOrder.size();
        for (int i = 0; i < size; ++i) {
            IContributionItem created = (IContributionItem)this.cbItemsCreationOrder.get(i);
            if (created.getId() == null || !created.getId().equals(item.getId())) continue;
            this.cbItemsCreationOrder.set(i, item);
            replaced = true;
            break;
        }
        if (!replaced) {
            this.cbItemsCreationOrder.add(Math.min(Math.max(insertedAt, 0), this.cbItemsCreationOrder.size()), item);
        }
    }

    protected void itemRemoved(IContributionItem item) {
        Assert.isNotNull(item);
        super.itemRemoved(item);
        CoolItem coolItem = this.findCoolItem(item);
        if (coolItem != null) {
            coolItem.setData(null);
        }
    }

    private void nextRow(ListIterator iterator, boolean ignoreCurrentItem) {
        IContributionItem currentElement = null;
        if (!ignoreCurrentItem && iterator.hasPrevious()) {
            currentElement = (IContributionItem)iterator.previous();
            iterator.next();
        }
        if (currentElement != null && currentElement.isSeparator()) {
            this.collapseSeparators(iterator);
            return;
        }
        while (iterator.hasNext()) {
            IContributionItem item = (IContributionItem)iterator.next();
            if (!item.isSeparator()) continue;
            this.collapseSeparators(iterator);
            return;
        }
    }

    public void refresh() {
        if (!this.coolBarExist()) {
            return;
        }
        ArrayList contributionList = this.getItemList();
        if (contributionList.size() == 0) {
            return;
        }
        CoolItem[] coolItems = this.coolBar.getItems();
        int[] wrapIndicies = this.getAdjustedWrapIndices(this.coolBar.getWrapIndices());
        int row = 0;
        int coolItemIndex = 0;
        ArrayList<IContributionItem> displayedItems = new ArrayList<IContributionItem>(this.coolBar.getItemCount());
        for (int i = 0; i < coolItems.length; ++i) {
            CoolItem coolItem = coolItems[i];
            if (!(coolItem.getData() instanceof IContributionItem)) continue;
            IContributionItem cbItem = (IContributionItem)coolItem.getData();
            displayedItems.add(Math.min(i, displayedItems.size()), cbItem);
        }
        int offset = 0;
        for (int i = 1; i < wrapIndicies.length; ++i) {
            int insertAt = wrapIndicies[i] + offset;
            displayedItems.add(insertAt, new Separator(USER_SEPARATOR));
            ++offset;
        }
        ArrayList<Integer> existingVisibleRows = new ArrayList<Integer>(4);
        ListIterator rowIterator = contributionList.listIterator();
        this.collapseSeparators(rowIterator);
        int numRow = 0;
        while (rowIterator.hasNext()) {
            while (rowIterator.hasNext()) {
                IContributionItem cbItem = (IContributionItem)rowIterator.next();
                if (displayedItems.contains(cbItem)) {
                    existingVisibleRows.add(new Integer(numRow));
                    break;
                }
                if (!cbItem.isSeparator()) continue;
                break;
            }
            this.nextRow(rowIterator, false);
            ++numRow;
        }
        Iterator existingRows = existingVisibleRows.iterator();
        if (existingRows.hasNext()) {
            row = (Integer)existingRows.next();
        }
        HashMap<IContributionItem, Integer> itemLocation = new HashMap<IContributionItem, Integer>();
        ListIterator locationIterator = displayedItems.listIterator();
        while (locationIterator.hasNext()) {
            IContributionItem item = (IContributionItem)locationIterator.next();
            if (item.isSeparator()) {
                if (existingRows.hasNext()) {
                    Integer value = (Integer)existingRows.next();
                    row = value;
                    continue;
                }
                ++row;
                continue;
            }
            itemLocation.put(item, new Integer(row));
        }
        ListIterator iterator = displayedItems.listIterator();
        while (iterator.hasNext()) {
            IContributionItem cbItem = (IContributionItem)iterator.next();
            if (cbItem.isSeparator()) {
                coolItemIndex = 0;
                continue;
            }
            this.relocate(cbItem, coolItemIndex, contributionList, itemLocation);
            cbItem.saveWidgetState();
            ++coolItemIndex;
        }
        if (contributionList.size() != 0) {
            contributionList = this.adjustContributionList(contributionList);
            IContributionItem[] array = new IContributionItem[contributionList.size() - 1];
            array = contributionList.toArray(array);
            this.internalSetItems(array);
        }
    }

    private void relocate(IContributionItem cbItem, int index, ArrayList contributionList, HashMap itemLocation) {
        if (!(itemLocation.get(cbItem) instanceof Integer)) {
            return;
        }
        int targetRow = (Integer)itemLocation.get(cbItem);
        int cbInternalIndex = contributionList.indexOf(cbItem);
        int insertAt = contributionList.size();
        ListIterator iterator = contributionList.listIterator();
        this.collapseSeparators(iterator);
        int currentRow = -1;
        while (iterator.hasNext()) {
            if (++currentRow == targetRow) {
                int virtualIndex = 0;
                insertAt = iterator.nextIndex();
                while (iterator.hasNext()) {
                    IContributionItem item = (IContributionItem)iterator.next();
                    Integer itemRow = (Integer)itemLocation.get(item);
                    if (item.isSeparator()) break;
                    if (itemRow != null && itemRow == targetRow) {
                        if (virtualIndex >= index) break;
                        ++virtualIndex;
                    }
                    ++insertAt;
                }
                if (cbInternalIndex != insertAt) break;
                return;
            }
            this.nextRow(iterator, true);
        }
        contributionList.remove(cbItem);
        if (cbInternalIndex < insertAt) {
            --insertAt;
        }
        if (currentRow != targetRow) {
            contributionList.add(new Separator(USER_SEPARATOR));
            insertAt = contributionList.size();
        }
        insertAt = Math.min(insertAt, contributionList.size());
        contributionList.add(insertAt, cbItem);
    }

    public void resetItemOrder() {
        ListIterator iterator = this.cbItemsCreationOrder.listIterator();
        while (iterator.hasNext()) {
            IContributionItem item = (IContributionItem)iterator.next();
            if (item.getId() == null || !item.getId().equals(USER_SEPARATOR)) continue;
            iterator.remove();
        }
        IContributionItem[] itemsToSet = new IContributionItem[this.cbItemsCreationOrder.size()];
        this.cbItemsCreationOrder.toArray(itemsToSet);
        this.setItems(itemsToSet);
    }

    public void setContextMenuManager(IMenuManager contextMenuManager) {
        this.contextMenuManager = (MenuManager)contextMenuManager;
        if (this.coolBar != null) {
            this.coolBar.setMenu(this.getContextMenuControl());
        }
    }

    public void setItems(IContributionItem[] newItems) {
        if (this.coolBar != null) {
            CoolItem[] coolItems = this.coolBar.getItems();
            for (int i = 0; i < coolItems.length; ++i) {
                this.dispose(coolItems[i]);
            }
        }
        this.internalSetItems(newItems);
        this.update(true);
    }

    public void setLockLayout(boolean value) {
        if (!this.coolBarExist()) {
            return;
        }
        this.coolBar.setLocked(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean force) {
        if (!this.isDirty() && !force || !this.coolBarExist()) {
            return;
        }
        boolean relock = false;
        boolean changed = false;
        try {
            int i;
            int i2;
            this.coolBar.setRedraw(false);
            this.refresh();
            if (this.coolBar.getLocked()) {
                this.coolBar.setLocked(false);
                relock = true;
            }
            IContributionItem[] items = this.getItems();
            ArrayList<IContributionItem> visibleItems = new ArrayList<IContributionItem>(items.length);
            for (int i3 = 0; i3 < items.length; ++i3) {
                IContributionItem item = items[i3];
                if (!item.isVisible()) continue;
                visibleItems.add(item);
            }
            CoolItem[] coolItems = this.coolBar.getItems();
            ArrayList<CoolItem> coolItemsToRemove = new ArrayList<CoolItem>(coolItems.length);
            for (i2 = 0; i2 < coolItems.length; ++i2) {
                Object data = coolItems[i2].getData();
                if (data != null && visibleItems.contains(data) && (!(data instanceof IContributionItem) || !((IContributionItem)data).isDynamic())) continue;
                coolItemsToRemove.add(coolItems[i2]);
            }
            for (i2 = coolItemsToRemove.size() - 1; i2 >= 0; --i2) {
                CoolItem coolItem = (CoolItem)coolItemsToRemove.get(i2);
                if (coolItem.isDisposed()) continue;
                Control control = coolItem.getControl();
                if (control != null) {
                    coolItem.setControl(null);
                    control.dispose();
                }
                coolItem.dispose();
            }
            coolItems = this.coolBar.getItems();
            int sourceIndex = 0;
            int destinationIndex = 0;
            Iterator visibleItemItr = visibleItems.iterator();
            while (visibleItemItr.hasNext()) {
                IContributionItem sourceItem = (IContributionItem)visibleItemItr.next();
                IContributionItem destinationItem = sourceIndex < coolItems.length ? (IContributionItem)coolItems[sourceIndex].getData() : null;
                if (destinationItem != null) {
                    if (sourceItem.equals(destinationItem)) {
                        ++sourceIndex;
                        ++destinationIndex;
                        sourceItem.update();
                        continue;
                    }
                    if (destinationItem.isSeparator() && sourceItem.isSeparator()) {
                        coolItems[sourceIndex].setData((Object)sourceItem);
                        ++sourceIndex;
                        ++destinationIndex;
                        sourceItem.update();
                        continue;
                    }
                }
                int start = this.coolBar.getItemCount();
                sourceItem.fill(this.coolBar, destinationIndex);
                int newItems = this.coolBar.getItemCount() - start;
                for (int i4 = 0; i4 < newItems; ++i4) {
                    this.coolBar.getItem(destinationIndex++).setData((Object)sourceItem);
                }
                changed = true;
            }
            for (i = coolItems.length - 1; i >= sourceIndex; --i) {
                CoolItem item = coolItems[i];
                if (item.isDisposed()) continue;
                Control control = item.getControl();
                if (control != null) {
                    item.setControl(null);
                    control.dispose();
                }
                item.dispose();
                changed = true;
            }
            this.updateWrapIndices();
            for (i = 0; i < items.length; ++i) {
                IContributionItem item = items[i];
                item.update("size");
            }
            if (relock) {
                this.coolBar.setLocked(true);
            }
            if (changed) {
                this.updateTabOrder();
            }
            this.setDirty(false);
        }
        finally {
            this.coolBar.setRedraw(true);
        }
    }

    void updateTabOrder() {
        CoolItem[] items;
        if (this.coolBar != null && (items = this.coolBar.getItems()) != null) {
            ArrayList<Control> children = new ArrayList<Control>(items.length);
            for (int i = 0; i < items.length; ++i) {
                if (items[i].getControl() == null || items[i].getControl().isDisposed()) continue;
                children.add(items[i].getControl());
            }
            Control[] childrenArray = new Control[]{};
            if ((childrenArray = children.toArray(childrenArray)) != null) {
                this.coolBar.setTabList(childrenArray);
            }
        }
    }

    private void updateWrapIndices() {
        IContributionItem[] items = this.getItems();
        int numRows = this.getNumRows(items) - 1;
        int[] wrapIndices = new int[numRows];
        boolean foundSeparator = false;
        int j = 0;
        for (int i = 0; i < items.length; ++i) {
            IContributionItem item = items[i];
            CoolItem coolItem = this.findCoolItem(item);
            if (item.isSeparator()) {
                foundSeparator = true;
            }
            if (item.isSeparator() || item.isGroupMarker() || !item.isVisible() || coolItem == null || !foundSeparator) continue;
            wrapIndices[j] = this.coolBar.indexOf(coolItem);
            ++j;
            foundSeparator = false;
        }
        int[] oldIndices = this.coolBar.getWrapIndices();
        boolean shouldUpdate = false;
        if (oldIndices.length == wrapIndices.length) {
            for (int i = 0; i < oldIndices.length; ++i) {
                if (oldIndices[i] == wrapIndices[i]) continue;
                shouldUpdate = true;
                break;
            }
        } else {
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            this.coolBar.setWrapIndices(wrapIndices);
        }
    }
}

