/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog
extends Window {
    public static final String DLG_IMG_ERROR = "dialog_error_image";
    public static final String DLG_IMG_INFO = "dialog_info_imageg";
    public static final String DLG_IMG_QUESTION = "dialog_question_image";
    public static final String DLG_IMG_WARNING = "dialog_warning_image";
    public static final String DLG_IMG_MESSAGE_INFO = "dialog_messasge_info_image";
    public static final String DLG_IMG_MESSAGE_WARNING = "dialog_messasge_warning_image";
    public static final String DLG_IMG_MESSAGE_ERROR = "dialog_message_error_image";
    public static final String ELLIPSIS = "...";
    protected Control dialogArea;
    public Control buttonBar;
    private HashMap buttons = new HashMap();
    private FontMetrics fontMetrics;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    public static IDialogBlockedHandler blockedHandler;
    static /* synthetic */ Class class$org$eclipse$jface$dialogs$Dialog;

    public static int convertHeightInCharsToPixels(FontMetrics fontMetrics, int chars) {
        return fontMetrics.getHeight() * chars;
    }

    public static int convertHorizontalDLUsToPixels(FontMetrics fontMetrics, int dlus) {
        return (fontMetrics.getAverageCharWidth() * dlus + 2) / 4;
    }

    public static int convertVerticalDLUsToPixels(FontMetrics fontMetrics, int dlus) {
        return (fontMetrics.getHeight() * dlus + 4) / 8;
    }

    public static int convertWidthInCharsToPixels(FontMetrics fontMetrics, int chars) {
        return fontMetrics.getAverageCharWidth() * chars;
    }

    public static String shortenText(String textValue, Control control) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        GC gc = new GC((Drawable)control);
        int maxWidth = control.getBounds().width - 5;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int start = pivot = length / 2;
        for (int end = pivot + 1; start >= 0 && end < length; --start, ++end) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            String s = s1 + ELLIPSIS + s2;
            int l = gc.textExtent((String)s).x;
            if (l >= maxWidth) continue;
            gc.dispose();
            return s;
        }
        gc.dispose();
        return textValue;
    }

    protected Dialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
        this.setBlockOnOpen(true);
        if (parentShell == null && Policy.DEBUG_DIALOG_NO_PARENT) {
            Policy.getLog().log((IStatus)new Status(1, "org.eclipse.jface", 1, this.getClass() + " created with no shell", (Throwable)new Exception()));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (0 == buttonId) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels(this.fontMetrics, chars);
    }

    protected int convertHorizontalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHorizontalDLUsToPixels(this.fontMetrics, dlus);
    }

    protected int convertVerticalDLUsToPixels(int dlus) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertVerticalDLUsToPixels(this.fontMetrics, dlus);
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels(this.fontMetrics, chars);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Dialog.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(new Integer(id), button);
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void initializeBounds() {
        Button defaultButton;
        Shell shell;
        String platform = SWT.getPlatform();
        if ("carbon".equals(platform) && (shell = this.getShell()) != null && (defaultButton = shell.getDefaultButton()) != null && this.isContained(this.buttonBar, (Control)defaultButton)) {
            defaultButton.moveBelow(null);
        }
        super.initializeBounds();
    }

    private boolean isContained(Control container, Control control) {
        Composite parent;
        while ((parent = control.getParent()) != null) {
            if (parent == container) {
                return true;
            }
            control = parent;
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Button getButton(int id) {
        return (Button)this.buttons.get(new Integer(id));
    }

    protected Control getButtonBar() {
        return this.buttonBar;
    }

    protected Button getCancelButton() {
        return this.getButton(1);
    }

    protected Control getDialogArea() {
        return this.dialogArea;
    }

    public static Image getImage(String key) {
        return JFaceResources.getImageRegistry().get(key);
    }

    protected Button getOKButton() {
        return this.getButton(0);
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.close();
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        data.heightHint = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    protected void setButtonLayoutFormData(Button button) {
        FormData data = new FormData();
        data.height = this.convertVerticalDLUsToPixels(14);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.width = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    public boolean close() {
        boolean returnValue = super.close();
        if (returnValue) {
            this.buttons = new HashMap();
            this.buttonBar = null;
            this.dialogArea = null;
        }
        return returnValue;
    }

    public static void applyDialogFont(Control control) {
        if (control == null || Dialog.dialogFontIsDefault()) {
            return;
        }
        Font dialogFont = JFaceResources.getDialogFont();
        Dialog.applyDialogFont(control, dialogFont);
    }

    private static void applyDialogFont(Control control, Font dialogFont) {
        if (Dialog.hasDefaultFont(control)) {
            control.setFont(dialogFont);
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            for (int i = 0; i < children.length; ++i) {
                Dialog.applyDialogFont(children[i], dialogFont);
            }
        }
    }

    private static boolean hasDefaultFont(Control control) {
        FontData[] defaultFontData;
        FontData[] controlFontData = control.getFont().getFontData();
        if (controlFontData.length == (defaultFontData = Dialog.getDefaultFont(control).getFontData()).length) {
            for (int i = 0; i < controlFontData.length; ++i) {
                if (controlFontData[i].equals((Object)defaultFontData[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Font getDefaultFont(Control control) {
        String fontName = "DEFAULT_FONT_" + control.getClass().getName();
        if (JFaceResources.getFontRegistry().hasValueFor(fontName)) {
            return JFaceResources.getFontRegistry().get(fontName);
        }
        Font cached = control.getFont();
        control.setFont(null);
        Font defaultFont = control.getFont();
        control.setFont(cached);
        JFaceResources.getFontRegistry().put(fontName, defaultFont.getFontData());
        return defaultFont;
    }

    protected static boolean dialogFontIsDefault() {
        Object[] dialogFontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont");
        Object[] defaultFontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont");
        return Arrays.equals(dialogFontData, defaultFontData);
    }

    public void create() {
        super.create();
        Dialog.applyDialogFont(this.buttonBar);
    }

    public static IDialogBlockedHandler getBlockedHandler() {
        return blockedHandler;
    }

    public static void setBlockedHandler(IDialogBlockedHandler blockedHandler) {
        Dialog.blockedHandler = blockedHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(DLG_IMG_MESSAGE_INFO, ImageDescriptor.createFromFile(class$org$eclipse$jface$dialogs$Dialog == null ? (class$org$eclipse$jface$dialogs$Dialog = Dialog.class$("org.eclipse.jface.dialogs.Dialog")) : class$org$eclipse$jface$dialogs$Dialog, "images/message_info.gif"));
        reg.put(DLG_IMG_MESSAGE_WARNING, ImageDescriptor.createFromFile(class$org$eclipse$jface$dialogs$Dialog == null ? (class$org$eclipse$jface$dialogs$Dialog = Dialog.class$("org.eclipse.jface.dialogs.Dialog")) : class$org$eclipse$jface$dialogs$Dialog, "images/message_warning.gif"));
        reg.put(DLG_IMG_MESSAGE_ERROR, ImageDescriptor.createFromFile(class$org$eclipse$jface$dialogs$Dialog == null ? (class$org$eclipse$jface$dialogs$Dialog = Dialog.class$("org.eclipse.jface.dialogs.Dialog")) : class$org$eclipse$jface$dialogs$Dialog, "images/message_error.gif"));
        blockedHandler = new IDialogBlockedHandler(){

            public void clearBlocked() {
            }

            public void showBlocked(IProgressMonitor blocking, IStatus blockingStatus, String blockedName) {
            }

            public void showBlocked(Shell parentShell, IProgressMonitor blocking, IStatus blockingStatus, String blockedName) {
            }
        };
    }
}

