/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroContainer;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroAnchor;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroHomePage;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroInclude;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroPageTitle;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.osgi.framework.Bundle;

public class IntroModelSerializer {
    private StringBuffer buffer = new StringBuffer();

    public IntroModelSerializer(IntroModelRoot root) {
        this.printModelRootInfo(root, this.buffer);
        IntroHomePage rootPage = root.getHomePage();
        this.printHomePage(rootPage, this.buffer);
        this.printPageChildren(rootPage, this.buffer);
        IntroPage[] pages = root.getPages();
        this.printPages(pages, this.buffer);
        this.buffer.append("\n\n");
        this.printModelFlagTests(root, this.buffer);
    }

    private void printModelRootInfo(IntroModelRoot model, StringBuffer text) {
        text.append("\nIntro Model Content:");
        text.append("\n======================");
        text.append("\n\nModel has valid config = " + model.hasValidConfig());
        text.append("\nPresentation Kind = " + model.getPresentation().getImplementationKind());
        text.append("\nPresentation Shared Style = " + model.getPresentation().getImplementationStyle());
        text.append("\nPresentation type = " + model.getPresentation().getType());
        text.append("\nHome page id = " + model.getPresentation().getHomePageId());
        IntroHead headContent = model.getPresentation().getHead();
        if (headContent != null) {
            text.append("\nPresentation Shared Head = " + headContent.getSrc());
        }
        text.append("\nNumber of pages (not including Root Page) = " + model.getPages().length);
        text.append("\nNumber of shared groups = " + model.getChildrenOfType(16).length);
        text.append("\nNumber of unresolved extensions = " + model.getChildrenOfType(1024).length);
    }

    private void printHomePage(IntroHomePage rootPage, StringBuffer text) {
        text.append("\n\nHOME PAGE: ");
        text.append("\n--------------");
        text.append("\n\tis dynamic= " + ((IntroModelRoot)rootPage.getParent()).isDynamic());
        text.append("\n\tid = " + rootPage.getId());
        text.append("\n\ttitle = " + rootPage.getTitle());
        text.append("\n\tstyle = " + rootPage.getStyle());
        text.append("\n\talt-style = " + rootPage.getAltStyle());
        text.append("\n\turl = " + rootPage.getUrl());
        text.append("\n\tstyle-id = " + rootPage.getStyleId());
        this.printPageStyles(rootPage, text);
    }

    private void printPageStyles(AbstractIntroPage page, StringBuffer text) {
        text.append("\n\tpage styles are = ");
        String[] styles = page.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            text.append(styles[i] + "\n\t\t\t");
        }
        text.append("\n\tpage alt-styles are = ");
        Hashtable altStylesHashtable = page.getAltStyles();
        Enumeration altStyles = altStylesHashtable.keys();
        while (altStyles.hasMoreElements()) {
            String altStyle = (String)altStyles.nextElement();
            Bundle bundle = (Bundle)altStylesHashtable.get(altStyle);
            text.append(altStyle + " from " + bundle.getSymbolicName());
            text.append("\n\t\t");
        }
    }

    private void printPageChildren(AbstractIntroPage page, StringBuffer text) {
        text.append("\n\tpage children = " + page.getChildren().length);
        text.append("\n");
        this.printContainerChildren(page, text, "\n\t\t");
    }

    private void printContainerChildren(AbstractIntroContainer container, StringBuffer text, String indent) {
        AbstractIntroElement[] children = container.getChildren();
        block12: for (int i = 0; i < children.length; ++i) {
            int childType = children[i].getType();
            switch (childType) {
                case 16383: {
                    text.append("SHOULD NEVER BE HERE");
                    continue block12;
                }
                case 16: {
                    this.printGroup(text, (IntroGroup)children[i], indent);
                    continue block12;
                }
                case 64: {
                    this.printLink(text, (IntroLink)children[i], indent);
                    continue block12;
                }
                case 512: {
                    this.printText(text, (IntroText)children[i], indent);
                    continue block12;
                }
                case 128: {
                    this.printImage(text, (IntroImage)children[i], indent);
                    continue block12;
                }
                case 32: {
                    this.printHtml(text, (IntroHTML)children[i], indent);
                    continue block12;
                }
                case 256: {
                    this.printInclude(text, (IntroInclude)children[i], indent);
                    continue block12;
                }
                case 2048: {
                    this.printHead(text, (IntroHead)children[i], indent);
                    continue block12;
                }
                case 4096: {
                    this.printPageTitle(text, (IntroPageTitle)children[i], indent);
                    continue block12;
                }
                case 8192: {
                    this.printAnchor(text, (IntroAnchor)children[i], indent);
                }
            }
        }
    }

    private void printGroup(StringBuffer text, IntroGroup group, String indent) {
        text.append(indent + "GROUP: id = " + group.getId());
        indent = indent + "\t\t";
        text.append(indent + "label = " + group.getLabel());
        text.append(indent + "children = " + group.getChildren().length);
        text.append(indent + "style-id = " + group.getStyleId());
        this.printContainerChildren(group, text, indent + "\t\t");
    }

    private void printLink(StringBuffer text, IntroLink link, String indent) {
        text.append(indent + "LINK: id = " + link.getId());
        indent = indent + "\t\t";
        text.append(indent + "label = " + link.getLabel());
        text.append(indent + "text = " + link.getText());
        text.append(indent + "style-id = " + link.getStyleId());
    }

    private void printText(StringBuffer text, IntroText introText, String indent) {
        text.append(indent + "TEXT: id = " + introText.getId());
        indent = indent + "\t\t";
        text.append(indent + "text = " + introText.getText());
        text.append(indent + "style-id = " + introText.getStyleId());
    }

    private void printImage(StringBuffer text, IntroImage image, String indent) {
        text.append(indent + "IMAGE: id = " + image.getId());
        indent = indent + "\t\t";
        text.append(indent + "src = " + image.getSrc());
        text.append(indent + "alt = " + image.getAlt());
        text.append(indent + "style-id = " + image.getStyleId());
    }

    private void printHtml(StringBuffer text, IntroHTML html, String indent) {
        text.append(indent + "HTML: id = " + html.getId());
        indent = indent + "\t\t";
        text.append(indent + "src = " + html.getSrc());
        text.append(indent + "isInlined = " + html.isInlined());
        text.append(indent + "style-id = " + html.getStyleId());
        if (html.getIntroImage() != null) {
            this.printImage(text, html.getIntroImage(), indent + "\t\t");
        }
        if (html.getIntroText() != null) {
            this.printText(text, html.getIntroText(), indent + "\t\t");
        }
    }

    private void printInclude(StringBuffer text, IntroInclude include, String indent) {
        text.append(indent + "INCLUDE: configId = " + include.getConfigId());
        indent = indent + "\t\t";
        text.append(indent + "path = " + include.getPath());
        text.append(indent + "merge-style = " + include.getMergeStyle());
    }

    private void printHead(StringBuffer text, IntroHead head, String indent) {
        text.append(indent + "HEAD: src = " + head.getSrc());
    }

    private void printPageTitle(StringBuffer text, IntroPageTitle title, String indent) {
        text.append(indent + "TITLE: id = " + title.getId());
        indent = indent + "\t\t";
        text.append(indent + "title = " + title.getTitle());
        text.append(indent + "style-id = " + title.getStyleId());
    }

    private void printAnchor(StringBuffer text, IntroAnchor anchor, String indent) {
        text.append(indent + "ANCHOR: id = " + anchor.getId());
    }

    private void printPages(IntroPage[] pages, StringBuffer text) {
        for (int i = 0; i < pages.length; ++i) {
            text.append("\n\nPAGE id = " + pages[i].getId());
            text.append("\n----------");
            text.append("\n\ttitle = " + pages[i].getTitle());
            text.append("\n\tstyle = " + pages[i].getStyle());
            text.append("\n\talt-style = " + pages[i].getAltStyle());
            text.append("\n\tstyle-id = " + pages[i].getStyleId());
            this.printPageStyles(pages[i], text);
            this.printPageChildren(pages[i], text);
        }
    }

    private void printModelFlagTests(IntroModelRoot model, StringBuffer text) {
        text.append("Model Flag Tests: ");
        text.append("\n----------------");
        if (model.getPages().length == 0) {
            text.append("\nNo first page in model\n\n");
            return;
        }
        IntroPage firstPage = model.getPages()[0];
        text.append("\n\t\tFirst page children are: ");
        text.append("\n\t\t\tGroups: " + firstPage.getChildrenOfType(16).length);
        text.append("\n\t\t\tLinks: " + firstPage.getChildrenOfType(64).length);
        text.append("\n\t\t\tTexts: " + firstPage.getChildrenOfType(512).length);
        text.append("\n\t\t\tHTMLs: " + firstPage.getChildrenOfType(32).length);
        text.append("\n\t\t\tImages: " + firstPage.getChildrenOfType(128).length);
        text.append("\n\t\t\tIncludes: " + firstPage.getChildrenOfType(256).length);
        text.append("\n\t\t\tPage Titles: " + firstPage.getChildrenOfType(4096).length);
        text.append("\n\t\t\tPage Heads: " + firstPage.getChildrenOfType(2048).length);
        text.append("\n\t\t\tModel Elements: " + firstPage.getChildrenOfType(16383).length);
        text.append("\n\t\t\tContainers: " + firstPage.getChildrenOfType(29).length);
        text.append("\n\t\t\tAll Pages: " + firstPage.getChildrenOfType(12).length);
        text.append("\n\t\t\tElements with Text child(AbstractTextElemets): " + firstPage.getChildrenOfType(96).length);
        AbstractIntroElement[] linksAndGroups = (AbstractIntroElement[])firstPage.getChildrenOfType(80);
        text.append("\n\t\t\tGroups and Links: " + linksAndGroups.length);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

