/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class DuplicateLaunchConfigurationAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_DUPLICATE_ACTION = DebugUIPlugin.getUniqueIdentifier() + ".ID_DUPLICATE_ACTION";

    public DuplicateLaunchConfigurationAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.getString("DuplicateLaunchConfigurationAction.&Duplicate_1"), viewer, mode);
    }

    protected void performAction() {
        ILaunchConfiguration original = (ILaunchConfiguration)this.getStructuredSelection().getFirstElement();
        String newName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(original.getName());
        try {
            ILaunchConfigurationWorkingCopy newWorkingCopy = original.copy(newName);
            newWorkingCopy.doSave();
        }
        catch (CoreException e) {
            this.errorDialog(e);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return selection.size() == 1 && selection.getFirstElement() instanceof ILaunchConfiguration;
    }
}

