/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.debug.internal.ui.sourcelookup.SourceElementLabelProvider;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ResolveDuplicatesHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Object[] args = (Object[])source;
        List sources = (List)args[1];
        return this.resolveSourceElement(sources);
    }

    public Object resolveSourceElement(List sources) {
        Object file = null;
        if ((sources = this.removeSourceNotFoundEditors(sources)).size() == 1) {
            return sources.get(0);
        }
        if (sources.size() == 0) {
            return null;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DebugUIPlugin.getShell(), (ILabelProvider)new SourceElementLabelProvider());
        dialog.setMultipleSelection(false);
        dialog.setTitle(SourceLookupUIMessages.getString("ResolveDuplicatesHandler.0"));
        dialog.setMessage(SourceLookupUIMessages.getString("ResolveDuplicatesHandler.1"));
        dialog.setElements(sources.toArray());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            file = dialog.getFirstResult();
        }
        return file;
    }

    private List removeSourceNotFoundEditors(List sources) {
        Iterator iterator = sources.iterator();
        ArrayList filteredList = new ArrayList();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof CommonSourceNotFoundEditor) continue;
            filteredList.add(next);
        }
        if (filteredList.isEmpty() && sources.get(0) != null) {
            filteredList.add(sources.get(0));
        }
        return filteredList;
    }
}

