/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.ui.IMemento;

class LogReader {
    private static final int SESSION_STATE = 10;
    public static final long MAX_FILE_LENGTH = 0x100000L;
    private static final int ENTRY_STATE = 20;
    private static final int SUBENTRY_STATE = 30;
    private static final int MESSAGE_STATE = 40;
    private static final int STACK_STATE = 50;
    private static final int TEXT_STATE = 60;
    private static final int UNKNOWN_STATE = 70;
    private static LogSession currentSession;

    LogReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void parseLargeFile(File file, ArrayList entries, IMemento memento) {
        block28: {
            String line;
            ArrayList parents = new ArrayList();
            LogEntry current = null;
            LogSession session = null;
            int writerState = 70;
            StringWriter swriter = null;
            PrintWriter writer = null;
            int state = 70;
            currentSession = null;
            RandomAccessFile random = null;
            random = new RandomAccessFile(file, "r");
            random.seek(file.length() - 0x100000L);
            while ((line = random.readLine()) != null) {
                LogEntry entry;
                String message;
                if ((line = line.trim()).length() == 0) continue;
                state = line.startsWith("!SESSION") ? 10 : (line.startsWith("!ENTRY") ? 20 : (line.startsWith("!SUBENTRY") ? 30 : (line.startsWith("!MESSAGE") ? 40 : (line.startsWith("!STACK") ? 50 : 60))));
                if (state == 60) {
                    if (writer == null) continue;
                    writer.println(line);
                    continue;
                }
                if (writer != null) {
                    if (writerState == 50 && current != null) {
                        current.setStack(swriter.toString());
                    } else if (writerState == 10 && session != null) {
                        session.setSessionData(swriter.toString());
                    } else if (writerState == 40 && current != null) {
                        message = current.getMessage() + swriter.toString();
                        message = message.trim();
                        current.setMessage(message);
                    }
                    writerState = 70;
                    swriter = null;
                    writer.close();
                    writer = null;
                }
                if (state == 50) {
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 50;
                    continue;
                }
                if (state == 10) {
                    session = new LogSession();
                    session.processLogLine(line);
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 10;
                    LogReader.updateCurrentSession(session);
                    if (!currentSession.equals(session) || memento.getString("allSessions").equals("true")) continue;
                    entries.clear();
                    continue;
                }
                if (state == 20) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    entry.processLogLine(line, true);
                    LogReader.setNewParent(parents, entry, 0);
                    current = entry;
                    LogReader.addEntry(current, entries, memento, false);
                    continue;
                }
                if (state == 30) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    int depth = entry.processLogLine(line, false);
                    LogReader.setNewParent(parents, entry, depth);
                    current = entry;
                    LogEntry parent = (LogEntry)((Object)parents.get(depth - 1));
                    parent.addChild(entry);
                    continue;
                }
                if (state != 40) continue;
                swriter = new StringWriter();
                writer = new PrintWriter((Writer)swriter, true);
                message = "";
                if (line.length() > 8) {
                    message = line.substring(9).trim();
                }
                message = message.trim();
                if (current != null) {
                    current.setMessage(message);
                }
                writerState = 40;
            }
            Object var16_17 = null;
            try {
                if (random != null) {
                    random.close();
                }
                break block28;
            }
            catch (IOException e1) {}
            break block28;
            {
                catch (FileNotFoundException e) {
                    Object var16_18 = null;
                    try {
                        if (random != null) {
                            random.close();
                        }
                        break block28;
                    }
                    catch (IOException e1) {}
                    break block28;
                }
                catch (IOException e) {
                    Object var16_19 = null;
                    try {
                        if (random != null) {
                            random.close();
                        }
                        break block28;
                    }
                    catch (IOException e1) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (random != null) {
                        random.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void parseLogFile(File file, ArrayList entries, IMemento memento) {
        block28: {
            ArrayList parents = new ArrayList();
            LogEntry current = null;
            LogSession session = null;
            int writerState = 70;
            StringWriter swriter = null;
            PrintWriter writer = null;
            int state = 70;
            currentSession = null;
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while (reader.ready()) {
                LogEntry entry;
                String message;
                String line = reader.readLine();
                if (line == null || (line = line.trim()).length() == 0) continue;
                state = line.startsWith("!SESSION") ? 10 : (line.startsWith("!ENTRY") ? 20 : (line.startsWith("!SUBENTRY") ? 30 : (line.startsWith("!MESSAGE") ? 40 : (line.startsWith("!STACK") ? 50 : 60))));
                if (state == 60) {
                    if (writer == null) continue;
                    writer.println(line);
                    continue;
                }
                if (writer != null) {
                    if (writerState == 50 && current != null) {
                        current.setStack(swriter.toString());
                    } else if (writerState == 10 && session != null) {
                        session.setSessionData(swriter.toString());
                    } else if (writerState == 40 && current != null) {
                        message = current.getMessage() + swriter.toString();
                        message = message.trim();
                        current.setMessage(message);
                    }
                    writerState = 70;
                    swriter = null;
                    writer.close();
                    writer = null;
                }
                if (state == 50) {
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 50;
                    continue;
                }
                if (state == 10) {
                    session = new LogSession();
                    session.processLogLine(line);
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 10;
                    LogReader.updateCurrentSession(session);
                    if (!currentSession.equals(session) || memento.getString("allSessions").equals("true")) continue;
                    entries.clear();
                    continue;
                }
                if (state == 20) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    entry.processLogLine(line, true);
                    LogReader.setNewParent(parents, entry, 0);
                    current = entry;
                    LogReader.addEntry(current, entries, memento, false);
                    continue;
                }
                if (state == 30) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    int depth = entry.processLogLine(line, false);
                    LogReader.setNewParent(parents, entry, depth);
                    current = entry;
                    LogEntry parent = (LogEntry)((Object)parents.get(depth - 1));
                    parent.addChild(entry);
                    continue;
                }
                if (state != 40) continue;
                swriter = new StringWriter();
                writer = new PrintWriter((Writer)swriter, true);
                message = "";
                if (line.length() > 8) {
                    message = line.substring(9).trim();
                }
                message = message.trim();
                if (current != null) {
                    current.setMessage(message);
                }
                writerState = 40;
            }
            Object var16_17 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block28;
            }
            catch (IOException e1) {}
            break block28;
            {
                catch (FileNotFoundException e) {
                    Object var16_18 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block28;
                    }
                    catch (IOException e1) {}
                    break block28;
                }
                catch (IOException e) {
                    Object var16_19 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block28;
                    }
                    catch (IOException e1) {}
                }
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void updateCurrentSession(LogSession session) {
        if (currentSession == null) {
            currentSession = session;
            return;
        }
        Date currentDate = currentSession.getDate();
        Date sessionDate = session.getDate();
        if (currentDate == null && sessionDate != null) {
            currentSession = session;
        } else if (currentDate != null && sessionDate == null) {
            currentSession = session;
        } else if (currentDate != null && sessionDate != null && sessionDate.after(currentDate)) {
            currentSession = session;
        }
    }

    public static void addEntry(LogEntry current, ArrayList entries, IMemento memento, boolean useCurrentSession) {
        int severity = current.getSeverity();
        boolean doAdd = true;
        switch (severity) {
            case 1: {
                doAdd = memento.getString("info").equals("true");
                break;
            }
            case 2: {
                doAdd = memento.getString("warning").equals("true");
                break;
            }
            case 4: {
                doAdd = memento.getString("error").equals("true");
            }
        }
        if (doAdd) {
            if (useCurrentSession) {
                current.setSession(currentSession);
            }
            entries.add(0, current);
            if (memento.getString("useLimit").equals("true") && entries.size() > memento.getInteger("limit")) {
                entries.remove(entries.size() - 1);
            }
        }
    }

    private static void setNewParent(ArrayList parents, LogEntry entry, int depth) {
        if (depth + 1 > parents.size()) {
            parents.add(entry);
        } else {
            parents.set(depth, entry);
        }
    }

    public static void reset() {
        currentSession = null;
    }
}

