/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.GenerateDiffFileAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantLabelDecorator;
import org.eclipse.team.internal.ccvs.ui.subscriber.ChangeLogModelManager;
import org.eclipse.team.internal.ccvs.ui.subscriber.ConfirmMergedAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.OverrideAndCommitAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.OverrideAndUpdateAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.RefreshDirtyStateAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceCommitAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceUpdateAction;
import org.eclipse.team.internal.ui.synchronize.ScopableSubscriberParticipant;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class WorkspaceSynchronizeParticipant
extends ScopableSubscriberParticipant {
    public static final String ID = "org.eclipse.team.cvs.ui.cvsworkspace-participant";
    public static final String TOOLBAR_CONTRIBUTION_GROUP = "toolbar_group_1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "context_group_1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_2 = "context_group_2";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_3 = "context_group_3";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_4 = "context_group_4";

    public WorkspaceSynchronizeParticipant() {
    }

    public WorkspaceSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        CVSParticipantLabelDecorator labelDecorator = new CVSParticipantLabelDecorator(configuration);
        configuration.addLabelDecorator((ILabelDecorator)labelDecorator);
        configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", TOOLBAR_CONTRIBUTION_GROUP);
        configuration.addActionContribution((SynchronizePageActionGroup)new WorkspaceActionContribution());
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.setProperty("org.eclipse.team.ui.P_MODEL_MANAGER", (Object)new ChangeLogModelManager(configuration));
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_1);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_2);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_3);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_4);
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
    }

    public class WorkspaceActionContribution
    extends SynchronizePageActionGroup {
        private WorkspaceCommitAction commitToolbar;
        private WorkspaceUpdateAction updateToolbar;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.updateToolbar = new WorkspaceUpdateAction(configuration, this.getVisibleRootsSelectionProvider(), "WorkspaceToolbarUpdateAction.");
            this.updateToolbar.setPromptBeforeUpdate(true);
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", WorkspaceSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.updateToolbar);
            this.commitToolbar = new WorkspaceCommitAction(configuration, this.getVisibleRootsSelectionProvider(), "WorkspaceToolbarCommitAction.");
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", WorkspaceSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.commitToolbar);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new WorkspaceUpdateAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)new WorkspaceCommitAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new OverrideAndUpdateAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new OverrideAndCommitAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2, (IAction)new ConfirmMergedAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper((IActionDelegate)new IgnoreAction(), configuration));
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper((IActionDelegate)new GenerateDiffFileAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper((IActionDelegate)new BranchAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper((IActionDelegate)new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper((IActionDelegate)new ShowResourceInHistoryAction(), configuration));
            }
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_4, (IAction)new RefreshDirtyStateAction(configuration));
        }
    }
}

