/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.TagSelectionWizardPage;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateWizard
extends Wizard {
    private IResource[] resources;
    private final IWorkbenchPart part;
    private TagSelectionWizardPage tagSelectionPage;

    public UpdateWizard(IWorkbenchPart part, IResource[] resources) {
        this.part = part;
        this.resources = resources;
        this.setWindowTitle(Policy.bind("UpdateWizard.title"));
    }

    public void addPages() {
        ImageDescriptor substImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        this.tagSelectionPage = new TagSelectionWizardPage("tagPage", Policy.bind("UpdateWizard.0"), substImage, Policy.bind("UpdateWizard.1"), null, 31);
        this.tagSelectionPage.setAllowNoTag(true);
        this.tagSelectionPage.setFolders(this.getCVSFolders());
        this.tagSelectionPage.setHelpContxtId("org.eclipse.team.cvs.ui.update_tag_selection_page_context");
        this.addPage((IWizardPage)this.tagSelectionPage);
    }

    private ICVSFolder[] getCVSFolders() {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (int i = 0; i < this.resources.length; ++i) {
            IResource resource = this.resources[i];
            projects.add(resource.getProject());
        }
        ICVSFolder[] folders = new ICVSFolder[projects.size()];
        int i = 0;
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            folders[i++] = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        }
        return folders;
    }

    public boolean performFinish() {
        try {
            new UpdateOperation(this.part, this.resources, Command.NO_LOCAL_OPTIONS, this.tagSelectionPage.getSelectedTag()).run();
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), null, null, e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

