/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureSpecSection;
import org.eclipse.pde.internal.ui.editor.feature.PortabilitySection;
import org.eclipse.pde.internal.ui.editor.feature.URLSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.WorkbenchHelp;

public class FeatureFormPage
extends PDEFormPage {
    public static final String PAGE_ID = "feature";
    private URLSection urlSection;
    private FeatureSpecSection specSection;
    private PortabilitySection portabilitySection;

    public FeatureFormPage(PDEFormEditor editor, String title) {
        super(editor, PAGE_ID, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        this.specSection = new FeatureSpecSection(this, form.getBody());
        GridData gd = new GridData(770);
        this.specSection.getSection().setLayoutData((Object)gd);
        this.urlSection = new URLSection(this, form.getBody());
        gd = new GridData(784);
        this.urlSection.getSection().setLayoutData((Object)gd);
        this.portabilitySection = new PortabilitySection(this, form.getBody());
        gd = new GridData(1808);
        this.portabilitySection.getSection().setLayoutData((Object)gd);
        managedForm.addPart((IFormPart)this.specSection);
        managedForm.addPart((IFormPart)this.urlSection);
        managedForm.addPart((IFormPart)this.portabilitySection);
        WorkbenchHelp.setHelp((Control)form.getBody(), (String)"org.eclipse.pde.doc.user.manifest_feature_overview");
        this.initialize();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getModel();
        IFeature feature = model.getFeature();
        this.getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
    }
}

