/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;

public class OpenReferenceAction
extends SelectionProviderAction {
    public static final String LABEL = "Actions.open.label";

    public OpenReferenceAction(ISelectionProvider provider) {
        super(provider, PDEPlugin.getResourceString(LABEL));
    }

    public void run() {
        ISiteBuildFeature sfeature;
        IFeature feature;
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object obj = sel.getFirstElement();
        IFile file = null;
        if (obj instanceof FeaturePlugin) {
            FeaturePlugin reference = (FeaturePlugin)obj;
            IPluginBase pluginBase = reference.getPluginBase();
            if (pluginBase != null) {
                file = (IFile)pluginBase.getModel().getUnderlyingResource();
            }
        } else if (obj instanceof IFeatureData) {
            IFeatureData data = (IFeatureData)obj;
            String id = data.getId();
            IResource resource = data.getModel().getUnderlyingResource();
            if (resource != null) {
                IProject project = resource.getProject();
                file = project.getFile(id);
            }
        } else if (obj instanceof ISiteBuildFeature && (feature = (sfeature = (ISiteBuildFeature)obj).getReferencedFeature()) != null) {
            file = (IFile)feature.getModel().getUnderlyingResource();
        }
        if (file != null && file.exists()) {
            IWorkbenchPage page = PDEPlugin.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                // empty catch block
            }
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

