/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class RequiredFeaturesWizardPage
extends WizardPage {
    public static final String KEY_TITLE = "FeatureEditor.RequiresSection.newFeature.title";
    public static final String KEY_DESC = "FeatureEditor.RequiresSection.newFeature.desc";
    public static final String KEY_FEATURES = "FeatureEditor.RequiresSection.newFeature.label";
    public static final String KEY_ADDING = "FeatureEditor.RequiresSection.newFeature.adding";
    public static final String KEY_UPDATING = "FeatureEditor.RequiresSection.newFeature.updating";
    private IFeatureModel model;
    private TablePart checkboxTablePart;
    private CheckboxTableViewer pluginViewer;

    public RequiredFeaturesWizardPage(IFeatureModel model) {
        super("RequiredFeaturesPage");
        this.model = model;
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.setPageComplete(false);
        this.checkboxTablePart = new TablePart();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createPluginList(container);
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_included_features_wizard");
    }

    protected void createPluginList(Composite parent) {
        this.checkboxTablePart.createControl(parent);
        this.pluginViewer = this.checkboxTablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IFeatureModel) {
                    IFeatureModel model = (IFeatureModel)object;
                    return !RequiredFeaturesWizardPage.this.isOnTheList(model);
                }
                return true;
            }
        });
        GridData gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
    }

    private boolean isOnTheList(IFeatureModel candidate) {
        IFeatureImport[] imports = this.model.getFeature().getImports();
        IFeature cfeature = candidate.getFeature();
        if (this.isThisModel(cfeature)) {
            return true;
        }
        for (int i = 0; i < imports.length; ++i) {
            IFeatureImport iimport = imports[i];
            if (iimport.getType() == 0 || !iimport.getId().equals(cfeature.getId()) || !iimport.getVersion().equals(cfeature.getVersion())) continue;
            return true;
        }
        return false;
    }

    private boolean isThisModel(IFeature cfeature) {
        IFeature thisFeature = this.model.getFeature();
        return cfeature.getId().equals(thisFeature.getId()) && cfeature.getVersion().equals(thisFeature.getVersion());
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.pluginViewer.setInput((Object)this.model.getFeature());
        this.checkboxTablePart.setSelection(new Object[0]);
    }

    private Object[] getChoices() {
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        return mng.getFeatureModels();
    }

    public boolean finish() {
        final Object[] candidates = this.checkboxTablePart.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    RequiredFeaturesWizardPage.this.doAdd(candidates, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private void doAdd(Object[] candidates, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_ADDING), candidates.length + 1);
        IFeature feature = this.model.getFeature();
        IFeatureImport[] added = new IFeatureImport[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            String name = candidate.getFeature().getLabel();
            monitor.subTask(candidate.getResourceString(name));
            FeatureImport iimport = (FeatureImport)this.model.getFactory().createImport();
            iimport.loadFrom(candidate.getFeature());
            added[i] = iimport;
            monitor.worked(1);
        }
        monitor.subTask("");
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        feature.addImports(added);
        monitor.worked(1);
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart() {
            super(PDEPlugin.getResourceString(RequiredFeaturesWizardPage.KEY_FEATURES));
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            RequiredFeaturesWizardPage.this.setPageComplete(count > 0);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.FEATURE_SORTER);
            return viewer;
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return RequiredFeaturesWizardPage.this.getChoices();
        }
    }
}

