/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.PrintWriter;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Namespace;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class RegistryWriter {
    public static final int INDENT = 2;
    public static final String REGISTRY = "plugin-registry";

    public void writeConfigurationElement(ConfigurationElement configElement, PrintWriter w, int indent) {
        int subElementSize;
        String element = configElement.getName();
        if (element == null) {
            return;
        }
        String gap1 = "";
        for (int i = 0; i < indent; ++i) {
            gap1 = gap1 + " ";
        }
        String gap2 = gap1;
        for (int i = 0; i < 2; ++i) {
            gap2 = gap2 + " ";
        }
        w.print(gap1 + "<" + element);
        ConfigurationProperty[] propList = configElement.getProperties();
        int propSize = propList == null ? 0 : propList.length;
        for (int i = 0; i < propSize; ++i) {
            this.writeConfigurationProperty(propList[i], w);
        }
        IConfigurationElement[] subElementList = configElement.getChildren();
        int n = subElementSize = subElementList == null ? 0 : subElementList.length;
        if (configElement.getValue() == null && subElementSize == 0) {
            w.println("/>");
            return;
        }
        w.println(">");
        if (configElement.getValue() != null) {
            w.println(gap2 + RegistryWriter.xmlSafe(configElement.getValue()));
        }
        for (int i = 0; i < subElementSize; ++i) {
            this.writeConfigurationElement((ConfigurationElement)subElementList[i], w, indent + 2);
        }
        w.println(gap1 + "</" + element + ">");
    }

    public void writeConfigurationProperty(ConfigurationProperty configProp, PrintWriter w) {
        if (configProp.getName() == null) {
            return;
        }
        w.print(" " + RegistryWriter.xmlSafe(configProp.getName()) + "=\"");
        if (configProp.getValue() != null) {
            w.print(RegistryWriter.xmlSafe(configProp.getValue()));
        }
        w.print("\"");
    }

    public void writeExtension(Extension extension, PrintWriter w, int indent) {
        IConfigurationElement[] subElements;
        int size;
        String gap1 = "";
        for (int i = 0; i < indent; ++i) {
            gap1 = gap1 + " ";
        }
        w.print(gap1 + "<" + "extension");
        if (extension.getExtensionPointIdentifier() != null) {
            w.print(" point=\"" + RegistryWriter.xmlSafe(extension.getExtensionPointIdentifier()) + "\"");
        }
        if (extension.getUniqueIdentifier() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(extension.getUniqueIdentifier()) + "\"");
        }
        if (extension.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(extension.getName()) + "\"");
        }
        int n = size = (subElements = extension.getConfigurationElements()) == null ? 0 : subElements.length;
        if (size == 0) {
            w.println("/>");
            return;
        }
        w.println(">");
        for (int i = 0; i < size; ++i) {
            this.writeConfigurationElement((ConfigurationElement)subElements[i], w, indent + 2);
        }
        w.println(gap1 + "</" + "extension" + ">");
    }

    public void writeExtensionPoint(ExtensionPoint extPt, PrintWriter w, int indent) {
        String gap1 = "";
        for (int i = 0; i < indent; ++i) {
            gap1 = gap1 + " ";
        }
        w.print(gap1 + "<" + "extension-point");
        if (extPt.getUniqueIdentifier() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(extPt.getUniqueIdentifier()) + "\"");
        }
        if (extPt.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(extPt.getName()) + "\"");
        }
        w.println("/>");
    }

    public void writeBundleModel(Namespace plugin, PrintWriter w, int indent) {
        IExtension[] extensions;
        int extSize;
        int extPointsSize;
        String gap1 = "";
        for (int i = 0; i < indent; ++i) {
            gap1 = gap1 + " ";
        }
        String gap2 = gap1;
        for (int i = 0; i < 2; ++i) {
            gap2 = gap2 + " ";
        }
        w.println("");
        w.print(gap1 + "<" + "plugin");
        if (plugin.getUniqueIdentifier() != null) {
            w.print(" id=\"" + RegistryWriter.xmlSafe(plugin.getUniqueIdentifier()) + "\"");
        }
        if (plugin.getName() != null) {
            w.print(" name=\"" + RegistryWriter.xmlSafe(plugin.getName()) + "\"");
        }
        w.println(">");
        IExtensionPoint[] extensionPoints = plugin.getExtensionPoints();
        int n = extPointsSize = extensionPoints == null ? 0 : extensionPoints.length;
        if (extPointsSize != 0) {
            w.println("");
            for (int i = 0; i < extPointsSize; ++i) {
                this.writeExtensionPoint((ExtensionPoint)extensionPoints[i], w, indent + 2);
            }
        }
        int n2 = extSize = (extensions = plugin.getExtensions()) == null ? 0 : extensions.length;
        if (extSize != 0) {
            for (int i = 0; i < extSize; ++i) {
                w.println("");
                this.writeExtension((Extension)extensions[i], w, indent + 2);
            }
        }
        w.println(gap1 + "</" + "plugin" + ">");
    }

    public void writeRegistry(ExtensionRegistry registry, PrintWriter w, int indent) {
        String gap1 = "";
        for (int i = 0; i < indent; ++i) {
            gap1 = gap1 + " ";
        }
        w.println(gap1 + "<" + REGISTRY + ">");
        String[] list = registry.getNamespaces();
        for (int i = 0; i < list.length; ++i) {
            this.writeBundleModel(registry.getNamespace(list[i]), w, indent + 2);
        }
        w.println(gap1 + "</" + REGISTRY + ">");
        w.flush();
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = RegistryWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else if (c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t') {
            buffer.append(c);
        } else {
            buffer.append("&#");
            buffer.append(Integer.toString(c));
            buffer.append(';');
        }
    }

    public static String xmlSafe(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        for (int i = 0; i < s.length(); ++i) {
            RegistryWriter.appendEscapedChar(result, s.charAt(i));
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

