/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import org.eclipse.core.internal.dependencies.Assert;
import org.eclipse.core.internal.dependencies.IMatchRule;

public class Dependency {
    private int changedMark;
    private Object requiredObjectId;
    private IMatchRule matchRule;
    private boolean optional;
    private Object resolvedVersionId;
    private Object userObject;

    public Dependency(Object requiredObjectId, IMatchRule matchRule, boolean optional, Object userObject) {
        Assert.isNotNull(requiredObjectId);
        Assert.isNotNull(matchRule);
        this.requiredObjectId = requiredObjectId;
        this.matchRule = matchRule;
        this.optional = optional;
        this.userObject = userObject;
    }

    public IMatchRule getMatchRule() {
        return this.matchRule;
    }

    public Object getRequiredObjectId() {
        return this.requiredObjectId;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getResolvedVersionId() {
        return this.resolvedVersionId;
    }

    public void resolve(Object resolvedVersionId, int changedMark) {
        if (resolvedVersionId == null && this.resolvedVersionId == null || resolvedVersionId != null && resolvedVersionId.equals(this.resolvedVersionId)) {
            return;
        }
        this.resolvedVersionId = resolvedVersionId;
        this.changedMark = changedMark;
    }

    public int getChangedMark() {
        return this.changedMark;
    }

    public String toString() {
        return " -> " + this.getUserObject() + " (" + this.getMatchRule() + ")";
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

