/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.subscribers.SubscriberEventHandler;
import org.eclipse.team.internal.core.subscribers.SyncSetInputFromSubscriber;
import org.eclipse.team.internal.core.subscribers.SyncSetInputFromSyncSet;

public final class SubscriberSyncInfoCollector
implements IResourceChangeListener,
ISubscriberChangeListener {
    private SyncSetInputFromSubscriber subscriberInput;
    private SyncSetInputFromSyncSet filteredInput;
    private SubscriberEventHandler eventHandler;
    private Subscriber subscriber;
    private IResource[] roots;

    public SubscriberSyncInfoCollector(Subscriber subscriber, IResource[] roots) {
        this.roots = roots;
        this.subscriber = subscriber;
        Assert.isNotNull(subscriber);
        this.eventHandler = new SubscriberEventHandler(subscriber, roots);
        this.subscriberInput = this.eventHandler.getSyncSetInput();
        this.filteredInput = new SyncSetInputFromSyncSet(this.subscriberInput.getSyncSet(), this.getEventHandler());
        this.filteredInput.setFilter(new SyncInfoFilter(){

            public boolean select(SyncInfo info, IProgressMonitor monitor) {
                return true;
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        subscriber.addListener(this);
    }

    public void setProgressGroup(IProgressMonitor monitor, int ticks) {
        this.getEventHandler().setProgressGroupHint(monitor, ticks);
    }

    public void start() {
        this.eventHandler.start();
    }

    public void waitForCollector(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.eventHandler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Policy.checkCanceled(monitor);
        }
        monitor.worked(1);
    }

    public void reset() {
        this.eventHandler.reset(this.getRoots());
    }

    public Subscriber getSubscriber() {
        return this.subscriber;
    }

    public void dispose() {
        this.eventHandler.shutdown();
        this.subscriberInput.disconnect();
        if (this.filteredInput != null) {
            this.filteredInput.disconnect();
        }
        this.getSubscriber().removeListener(this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private void processDelta(IResourceDelta delta, IResource[] roots) {
        IResource resource = delta.getResource();
        int kind = delta.getKind();
        if (resource.getType() == 4) {
            if ((kind & 2) != 0) {
                this.eventHandler.remove(resource);
                return;
            }
            if ((delta.getFlags() & 0x4000) != 0 && !((IProject)resource).isOpen()) {
                this.eventHandler.remove(resource);
                return;
            }
            if (!this.isAncestorOfRoot(resource, roots)) {
                if (this.getSubscriberSyncInfoSet().hasMembers(resource)) {
                    this.eventHandler.remove(resource);
                }
                return;
            }
        }
        boolean visitChildren = false;
        if (this.isDescendantOfRoot(resource, roots)) {
            int changeFlags;
            visitChildren = true;
            if ((delta.getFlags() & 0x8000) != 0) {
                this.eventHandler.remove(resource);
                this.eventHandler.change(resource, 2);
            }
            if (((changeFlags = delta.getFlags()) & 0x4100) != 0) {
                this.eventHandler.change(resource, 0);
            }
            if ((delta.getKind() & 3) != 0) {
                this.eventHandler.change(resource, 0);
            }
        }
        if (visitChildren || this.isAncestorOfRoot(resource, roots)) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(7);
            for (int i = 0; i < affectedChildren.length; ++i) {
                this.processDelta(affectedChildren[i], roots);
            }
        }
    }

    private boolean isAncestorOfRoot(IResource parent, IResource[] roots) {
        if (parent.getType() == 8) {
            return true;
        }
        for (int i = 0; i < roots.length; ++i) {
            IResource resource = roots[i];
            if (!parent.getFullPath().isPrefixOf(resource.getFullPath())) continue;
            return true;
        }
        return false;
    }

    private boolean isDescendantOfRoot(IResource resource, IResource[] roots) {
        for (int i = 0; i < roots.length; ++i) {
            IResource root = roots[i];
            if (!root.getFullPath().isPrefixOf(resource.getFullPath())) continue;
            return true;
        }
        return false;
    }

    public IResource[] getRoots() {
        if (this.roots == null) {
            return this.getSubscriber().roots();
        }
        return this.roots;
    }

    public boolean isAllRootsIncluded() {
        return this.roots == null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta(), this.getRoots());
    }

    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        IResource[] roots = this.getRoots();
        block5: for (int i = 0; i < deltas.length; ++i) {
            switch (deltas[i].getFlags()) {
                case 1: {
                    if (!this.isAllRootsIncluded() && !this.isDescendantOfRoot(deltas[i].getResource(), roots)) continue block5;
                    this.eventHandler.change(deltas[i].getResource(), 0);
                    continue block5;
                }
                case 4: {
                    this.eventHandler.remove(deltas[i].getResource());
                    continue block5;
                }
                case 2: {
                    if (!this.isAllRootsIncluded() && !this.isDescendantOfRoot(deltas[i].getResource(), roots)) continue block5;
                    this.eventHandler.change(deltas[i].getResource(), 2);
                }
            }
        }
    }

    protected SubscriberEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public SyncInfoTree getSubscriberSyncInfoSet() {
        return this.subscriberInput.getSyncSet();
    }

    public SyncInfoTree getSyncInfoSet() {
        return this.filteredInput.getSyncSet();
    }

    public void setFilter(SyncInfoFilter filter) {
        this.filteredInput.setFilter(filter);
        this.filteredInput.reset();
    }

    public SyncInfoFilter getFilter() {
        if (this.filteredInput != null) {
            return this.filteredInput.getFilter();
        }
        return null;
    }

    public void setRoots(IResource[] roots) {
        this.roots = roots;
        this.reset();
    }
}

