/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.vss;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.vss.MSVSSConstants;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;

public abstract class MSVSS
extends Task
implements MSVSSConstants {
    private String m_SSDir = null;
    private String m_vssLogin = null;
    private String m_vssPath = null;
    private String m_serverPath = null;
    private String m_Version = null;
    private String m_Date = null;
    private String m_Label = null;
    private String m_AutoResponse = null;
    private String m_LocalPath = null;
    private String m_Comment = null;
    private String m_FromLabel = null;
    private String m_ToLabel = null;
    private String m_OutputFileName = null;
    private String m_User = null;
    private String m_FromDate = null;
    private String m_ToDate = null;
    private String m_Style = null;
    private boolean m_Quiet = false;
    private boolean m_Recursive = false;
    private boolean m_Writable = false;
    private boolean m_FailOnError = true;
    private boolean m_getLocalCopy = true;
    private int m_NumDays = Integer.MIN_VALUE;
    private DateFormat m_DateFormat = DateFormat.getDateInstance(3);
    private CurrentModUpdated m_timestamp = null;
    private WritableFiles m_writablefiles = null;

    abstract Commandline buildCmdLine();

    public final void setSsdir(String dir) {
        this.m_SSDir = Project.translatePath((String)dir);
    }

    public final void setLogin(String login) {
        this.m_vssLogin = login;
    }

    public final void setVsspath(String vssPath) {
        String projectPath = vssPath.startsWith("vss://") ? vssPath.substring(5) : vssPath;
        this.m_vssPath = projectPath.startsWith("$") ? projectPath : "$" + projectPath;
    }

    public final void setServerpath(String serverPath) {
        this.m_serverPath = serverPath;
    }

    public final void setFailOnError(boolean failOnError) {
        this.m_FailOnError = failOnError;
    }

    public void execute() throws BuildException {
        int result = 0;
        Commandline commandLine = this.buildCmdLine();
        result = this.run(commandLine);
        if (Execute.isFailure((int)result) && this.getFailOnError()) {
            String msg = "Failed executing: " + this.formatCommandLine(commandLine) + " With a return code of " + result;
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected void setInternalComment(String text) {
        this.m_Comment = text;
    }

    protected void setInternalAutoResponse(String text) {
        this.m_AutoResponse = text;
    }

    protected void setInternalDate(String text) {
        this.m_Date = text;
    }

    protected void setInternalDateFormat(DateFormat date) {
        this.m_DateFormat = date;
    }

    protected void setInternalFailOnError(boolean fail) {
        this.m_FailOnError = fail;
    }

    protected void setInternalFromDate(String text) {
        this.m_FromDate = text;
    }

    protected void setInternalFromLabel(String text) {
        this.m_FromLabel = text;
    }

    protected void setInternalLabel(String text) {
        this.m_Label = text;
    }

    protected void setInternalLocalPath(String text) {
        this.m_LocalPath = text;
    }

    protected void setInternalNumDays(int days) {
        this.m_NumDays = days;
    }

    protected void setInternalOutputFilename(String text) {
        this.m_OutputFileName = text;
    }

    protected void setInternalQuiet(boolean quiet) {
        this.m_Quiet = quiet;
    }

    protected void setInternalRecursive(boolean recursive) {
        this.m_Recursive = recursive;
    }

    protected void setInternalStyle(String style) {
        this.m_Style = style;
    }

    protected void setInternalToDate(String text) {
        this.m_ToDate = text;
    }

    protected void setInternalToLabel(String text) {
        this.m_ToLabel = text;
    }

    protected void setInternalUser(String user) {
        this.m_User = user;
    }

    protected void setInternalVersion(String text) {
        this.m_Version = text;
    }

    protected void setInternalWritable(boolean writable) {
        this.m_Writable = writable;
    }

    protected void setInternalFileTimeStamp(CurrentModUpdated timestamp) {
        this.m_timestamp = timestamp;
    }

    protected void setInternalWritableFiles(WritableFiles files) {
        this.m_writablefiles = files;
    }

    protected void setInternalGetLocalCopy(boolean get) {
        this.m_getLocalCopy = get;
    }

    protected String getSSCommand() {
        if (this.m_SSDir == null) {
            return "ss";
        }
        return this.m_SSDir.endsWith(File.separator) ? this.m_SSDir + "ss" : this.m_SSDir + File.separator + "ss";
    }

    protected String getVsspath() {
        return this.m_vssPath;
    }

    protected String getQuiet() {
        return this.m_Quiet ? "-O-" : "";
    }

    protected String getRecursive() {
        return this.m_Recursive ? "-R" : "";
    }

    protected String getWritable() {
        return this.m_Writable ? "-W" : "";
    }

    protected String getLabel() {
        if (this.m_Label != null && this.m_Label.length() > 0) {
            return "-L" + this.getShortLabel();
        }
        return "";
    }

    private String getShortLabel() {
        if (this.m_Label != null && this.m_Label.length() > 31) {
            String label = this.m_Label.substring(0, 30);
            this.log("Label is longer than 31 characters, truncated to: " + label, 1);
            return label;
        }
        return this.m_Label;
    }

    protected String getStyle() {
        return this.m_Style != null ? this.m_Style : "";
    }

    protected String getVersionDateLabel() {
        if (this.m_Version != null) {
            return "-V" + this.m_Version;
        }
        if (this.m_Date != null) {
            return "-Vd" + this.m_Date;
        }
        String label = this.getShortLabel();
        if (label != null && !label.equals("")) {
            return "-VL" + label;
        }
        return "";
    }

    protected String getVersion() {
        return this.m_Version != null ? "-V" + this.m_Version : "";
    }

    protected String getLocalpath() {
        if (this.m_LocalPath == null) {
            return "";
        }
        File dir = this.getProject().resolveFile(this.m_LocalPath);
        if (!dir.exists()) {
            boolean done = dir.mkdirs();
            if (!done) {
                String msg = "Directory " + this.m_LocalPath + " creation was not " + "successful for an unknown reason";
                throw new BuildException(msg, this.getLocation());
            }
            this.getProject().log("Created dir: " + dir.getAbsolutePath());
        }
        return "-GL" + this.m_LocalPath;
    }

    protected String getComment() {
        return this.m_Comment != null ? "-C" + this.m_Comment : "-C-";
    }

    protected String getAutoresponse() {
        if (this.m_AutoResponse == null) {
            return "-I-";
        }
        if (this.m_AutoResponse.equalsIgnoreCase("Y")) {
            return "-I-Y";
        }
        if (this.m_AutoResponse.equalsIgnoreCase("N")) {
            return "-I-N";
        }
        return "-I-";
    }

    protected String getLogin() {
        return this.m_vssLogin != null ? "-Y" + this.m_vssLogin : "";
    }

    protected String getOutput() {
        return this.m_OutputFileName != null ? "-O" + this.m_OutputFileName : "";
    }

    protected String getUser() {
        return this.m_User != null ? "-U" + this.m_User : "";
    }

    protected String getVersionLabel() {
        if (this.m_FromLabel == null && this.m_ToLabel == null) {
            return "";
        }
        if (this.m_FromLabel != null && this.m_ToLabel != null) {
            if (this.m_FromLabel.length() > 31) {
                this.m_FromLabel = this.m_FromLabel.substring(0, 30);
                this.log("FromLabel is longer than 31 characters, truncated to: " + this.m_FromLabel, 1);
            }
            if (this.m_ToLabel.length() > 31) {
                this.m_ToLabel = this.m_ToLabel.substring(0, 30);
                this.log("ToLabel is longer than 31 characters, truncated to: " + this.m_ToLabel, 1);
            }
            return "-VL" + this.m_ToLabel + "~L" + this.m_FromLabel;
        }
        if (this.m_FromLabel != null) {
            if (this.m_FromLabel.length() > 31) {
                this.m_FromLabel = this.m_FromLabel.substring(0, 30);
                this.log("FromLabel is longer than 31 characters, truncated to: " + this.m_FromLabel, 1);
            }
            return "-V~L" + this.m_FromLabel;
        }
        if (this.m_ToLabel.length() > 31) {
            this.m_ToLabel = this.m_ToLabel.substring(0, 30);
            this.log("ToLabel is longer than 31 characters, truncated to: " + this.m_ToLabel, 1);
        }
        return "-VL" + this.m_ToLabel;
    }

    protected String getVersionDate() throws BuildException {
        if (this.m_FromDate == null && this.m_ToDate == null && this.m_NumDays == Integer.MIN_VALUE) {
            return "";
        }
        if (this.m_FromDate != null && this.m_ToDate != null) {
            return "-Vd" + this.m_ToDate + "~d" + this.m_FromDate;
        }
        if (this.m_ToDate != null && this.m_NumDays != Integer.MIN_VALUE) {
            try {
                return "-Vd" + this.m_ToDate + "~d" + this.calcDate(this.m_ToDate, this.m_NumDays);
            }
            catch (ParseException ex) {
                String msg = "Error parsing date: " + this.m_ToDate;
                throw new BuildException(msg, this.getLocation());
            }
        }
        if (this.m_FromDate != null && this.m_NumDays != Integer.MIN_VALUE) {
            try {
                return "-Vd" + this.calcDate(this.m_FromDate, this.m_NumDays) + "~d" + this.m_FromDate;
            }
            catch (ParseException ex) {
                String msg = "Error parsing date: " + this.m_FromDate;
                throw new BuildException(msg, this.getLocation());
            }
        }
        return this.m_FromDate != null ? "-V~d" + this.m_FromDate : "-Vd" + this.m_ToDate;
    }

    protected String getGetLocalCopy() {
        return !this.m_getLocalCopy ? "-G-" : "";
    }

    private boolean getFailOnError() {
        return this.getWritableFiles().equals("skip") ? false : this.m_FailOnError;
    }

    public String getFileTimeStamp() {
        if (this.m_timestamp == null) {
            return "";
        }
        if (this.m_timestamp.getValue().equals("modified")) {
            return "-GTM";
        }
        if (this.m_timestamp.getValue().equals("updated")) {
            return "-GTU";
        }
        return "-GTC";
    }

    public String getWritableFiles() {
        if (this.m_writablefiles == null) {
            return "";
        }
        if (this.m_writablefiles.getValue().equals("replace")) {
            return "-GWR";
        }
        if (this.m_writablefiles.getValue().equals("skip")) {
            this.m_FailOnError = false;
            return "-GWS";
        }
        return "";
    }

    private int run(Commandline cmd) {
        try {
            Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
            if (this.m_serverPath != null) {
                String[] env = exe.getEnvironment();
                if (env == null) {
                    env = new String[]{};
                }
                String[] newEnv = new String[env.length + 1];
                int i = 0;
                while (i < env.length) {
                    newEnv[i] = env[i];
                    ++i;
                }
                newEnv[env.length] = "SSDIR=" + this.m_serverPath;
                exe.setEnvironment(newEnv);
            }
            exe.setAntRun(this.getProject());
            exe.setWorkingDirectory(this.getProject().getBaseDir());
            exe.setCommandline(cmd.getCommandline());
            exe.setVMLauncher(false);
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private String calcDate(String fromDate, int numDays) throws ParseException {
        String toDate = null;
        Date currdate = new Date();
        GregorianCalendar calend = new GregorianCalendar();
        currdate = this.m_DateFormat.parse(fromDate);
        calend.setTime(currdate);
        ((Calendar)calend).add(5, numDays);
        toDate = this.m_DateFormat.format(calend.getTime());
        return toDate;
    }

    private String formatCommandLine(Commandline cmd) {
        StringBuffer sBuff = new StringBuffer(cmd.toString());
        int indexUser = sBuff.substring(0).indexOf("-Y");
        if (indexUser > 0) {
            int indexPass = sBuff.substring(0).indexOf(",", indexUser);
            int indexAfterPass = sBuff.substring(0).indexOf(" ", indexPass);
            int i = indexPass + 1;
            while (i < indexAfterPass) {
                sBuff.setCharAt(i, '*');
                ++i;
            }
        }
        return sBuff.toString();
    }

    public static class WritableFiles
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"replace", "skip", "fail"};
        }
    }

    public static class CurrentModUpdated
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"current", "modified", "updated"};
        }
    }
}

