/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermission;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermissionCollection;

final class BundlePermissions
extends BundlePermissionCollection {
    private Hashtable collections = new Hashtable(8);
    private PermissionCollection allPermission;
    private PackageAdminImpl packageAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$UnresolvedPermission;

    BundlePermissions(PackageAdminImpl packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        PermissionCollection collection;
        if (this.isReadOnly()) {
            throw new SecurityException();
        }
        Hashtable hashtable = this.collections;
        synchronized (hashtable) {
            collection = this.findCollection(permission);
            if (collection == null) {
                collection = this.newPermissionCollection(permission);
            }
        }
        if (permission instanceof AllPermission) {
            this.allPermission = collection;
        }
        collection.add(permission);
    }

    public Enumeration elements() {
        return new Enumeration(){
            Enumeration enumMap;
            PermissionCollection c;
            Enumeration enumC;
            Permission next;
            {
                this.enumMap = BundlePermissions.this.collections.elements();
                this.next = this.findNextPermission();
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            public Object nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Permission answer = this.next;
                this.next = this.findNextPermission();
                return answer;
            }

            private Permission findNextPermission() {
                while (this.c == null && this.enumMap.hasMoreElements()) {
                    this.c = (PermissionCollection)this.enumMap.nextElement();
                    this.enumC = this.c.elements();
                    if (this.enumC.hasMoreElements()) continue;
                    this.c = null;
                }
                if (this.c == null) {
                    return null;
                }
                Permission answer = (Permission)this.enumC.nextElement();
                if (!this.enumC.hasMoreElements()) {
                    this.c = null;
                }
                return answer;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection findCollection(Permission permission) {
        Class<?> clazz = permission.getClass();
        PermissionCollection collection = (PermissionCollection)this.collections.get(clazz);
        if (collection == null) {
            Hashtable hashtable = this.collections;
            synchronized (hashtable) {
                collection = (PermissionCollection)this.collections.get(clazz);
                if (collection == null) {
                    collection = this.resolvePermissions(permission);
                }
            }
        }
        return collection;
    }

    private PermissionCollection resolvePermissions(Permission permission) {
        String name;
        Vector permissions;
        UnresolvedPermissionCollection unresolvedCollection = (UnresolvedPermissionCollection)this.collections.get(class$org$eclipse$osgi$framework$internal$core$UnresolvedPermission == null ? (class$org$eclipse$osgi$framework$internal$core$UnresolvedPermission = BundlePermissions.class$("org.eclipse.osgi.framework.internal.core.UnresolvedPermission")) : class$org$eclipse$osgi$framework$internal$core$UnresolvedPermission);
        if (unresolvedCollection != null && (permissions = unresolvedCollection.getPermissions(name = permission.getClass().getName())) != null) {
            PermissionCollection collection = null;
            Class clazz = this.packageAdmin.loadServiceClass(name, null);
            if (clazz == null) {
                return null;
            }
            Enumeration enumeration = permissions.elements();
            while (enumeration.hasMoreElements()) {
                Permission resolved = ((UnresolvedPermission)enumeration.nextElement()).resolve(clazz);
                if (resolved == null) continue;
                if (collection == null) {
                    collection = this.newPermissionCollection(resolved);
                }
                collection.add(resolved);
            }
            return collection;
        }
        return null;
    }

    private PermissionCollection newPermissionCollection(Permission permission) {
        PermissionCollection collection = permission.newPermissionCollection();
        if (collection == null) {
            collection = new PermissionsHash();
        }
        this.collections.put(permission.getClass(), collection);
        return collection;
    }

    public boolean implies(Permission perm) {
        if (this.allPermission != null && this.allPermission.implies(perm)) {
            return true;
        }
        PermissionCollection collection = this.findCollection(perm);
        if (collection == null) {
            return false;
        }
        return collection.implies(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions(Hashtable unresolvedPackages) {
        Hashtable hashtable = this.collections;
        synchronized (hashtable) {
            int i;
            int size = this.collections.size();
            Class[] clazzes = new Class[size];
            Enumeration enumeration = this.collections.keys();
            for (i = 0; i < size; ++i) {
                clazzes[i] = (Class)enumeration.nextElement();
            }
            for (i = 0; i < size; ++i) {
                Class clazz = clazzes[i];
                String name = clazz.getName();
                int index = name.lastIndexOf(46);
                if (index <= 0 || unresolvedPackages.get(name.substring(0, index)) == null) continue;
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("  Unresolving permission class " + name);
                }
                this.collections.remove(clazz);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

