//**************************************************************************************************
//                                        PrcNetLstr.hpp                                           *
//                                       ----------------                                          *
// Description : Provides a programatic interface to the utility gnetlist which is used to         *
//               generate netlist file from various schematic editor formats.                      *
// Started     : 2004-01-29                                                                        *
// Last Update : 2020-10-28                                                                        *
// Copyright   : (C) 2004-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PRCNETLSTR_HPP
#define PRCNETLSTR_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "Config.hpp"
#include "SysScan.hpp"
#include "base/PrcBase.hpp"

// wxWidgets Includes

#include <wx/regex.h>

// Local Constant Declarations

#define  PRCNETLST_LOG_FILE    "gspiceui.log"    // Default log file name
#define  PRCNETLST_GUILE_PROC  "spice-msw"       // Default Guile procedure
#define  PRCNETLST_USE_SCHEM   "use-schem-name"  // Use schematic name for to create netlist name
#define  PRCNETLST_CUR_PROC    1000              // A value greater than the no. of Guile proc's

//**************************************************************************************************

class PrcNetLstr : public PrcBase
{
  private :

            size_t         m_szGuileProc;     // The Guile procedure offset into m_oasGuileProcs[ ]
    static  wxArrayString  m_oasGuileProcs;   // Array of all possible Guile procedures
            ArrayFileName  m_oaNameSchems;    // The full names of the schematic file/s
            wxFileName     m_ofnNameNetList;  // The full name  of the list file

    void  InitGuileProcs( void );

  public :

          PrcNetLstr( void );
         ~PrcNetLstr( );

    bool  bClear( void );

    bool  bSetEdaToolSuite(       eTypeEDA           eEDA_TS    );
    bool  bSetGuileProc   ( const wxString      &  rosGProc     );
    bool  bSetSchemFiles  ( const wxString      &  rosFileNames );
    bool  bSetSchemFiles  ( const wxArrayString & roasFileNames );
    bool  bSetNetLstFile  ( const wxString      &  rosFileName=PRCNETLST_USE_SCHEM );

                 eTypeEDA           eGetEdaToolSuite( void );
    static const wxArrayString & roasGetGuileProcs  ( void ) { return( m_oasGuileProcs ); }
           const wxString      &  rosGetGuileProc   ( size_t szIndex=PRCNETLST_CUR_PROC );
           const ArrayFileName &  roaGetSchemFiles  ( void ) { return( m_oaNameSchems  ); }
           const wxFileName    & rofnGetSchemFile   ( size_t szIndex=0 );
           const wxFileName    & rofnGetNetLstFile  ( void ) { return( m_ofnNameNetList  ); }

    virtual  bool  bExec( void );

    // The following function is intended for debugging
    void  Print( const wxString & rosPrefix="  " ) override;
};

//**************************************************************************************************

#endif // PRCNETLSTR_HPP
