//
//  CLTimelineWindow.m
//  Timeline
//
//  Created by Alex Clarke on 5/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLTimelineWindow.h"


@implementation CLTimelineWindow


- (IBAction) setWidth:(id)sender {
	
	float newWidth = [sender floatValue];
	[self setFloatWidth:newWidth];
}

- (void) setFloatWidth:(float)width {
	
	NSPoint origin = [self frame].origin;
	NSSize oldSize = [self frame].size;
	float height = oldSize.height;
	
	NSRect newFrame = NSMakeRect(origin.x, origin.y, width, height);
	[self setFrame:newFrame display:YES];	
}



//  In Interface Builder we set CLTimelineWindow to be the class for our window, so our own initializer is called here.
- (id)initWithContentRect:(NSRect)contentRect styleMask:(unsigned int)aStyle backing:(NSBackingStoreType)bufferingType defer:(BOOL)flag {

	NSWindow* result = [super initWithContentRect:contentRect styleMask:NSBorderlessWindowMask backing:NSBackingStoreBuffered defer:NO];

	[result setBackgroundColor: [NSColor clearColor]];
	[result setAlphaValue:1.0];
	[result setOpaque:NO];
	[result setHasShadow:NO];
	
	return result;
}

// Custom windows that use the NSBorderlessWindowMask can't become key by default.  Therefore, controls in such windows
// won't ever be enabled by default.  Thus, we override this method to change that.
- (BOOL) canBecomeKeyWindow
{
    return YES;
}

//Once the user starts dragging the mouse, we move the window with it. We do this because the window has no title
//bar for the user to drag (so we have to implement dragging ourselves)
- (void)mouseDragged:(NSEvent *)theEvent
{
   NSPoint currentLocation;
   NSPoint newOrigin;
   NSRect  screenFrame = [[NSScreen mainScreen] frame];
   NSRect  windowFrame = [self frame];

   
   //grab the current global mouse location; we could just as easily get the mouse location 
   //in the same way as we do in -mouseDown:
    currentLocation = [self convertBaseToScreen:[self mouseLocationOutsideOfEventStream]];
    newOrigin.x = currentLocation.x - initialLocation.x;
    newOrigin.y = currentLocation.y - initialLocation.y;
    
    // Don't let window get dragged up under the menu bar
    if( (newOrigin.y+windowFrame.size.height) > (screenFrame.origin.y+screenFrame.size.height) ){
	newOrigin.y=screenFrame.origin.y + (screenFrame.size.height-windowFrame.size.height);
    }
    
    //go ahead and move the window to the new location
    [self setFrameOrigin:newOrigin];
}

//We start tracking the a drag operation here when the user first clicks the mouse,
//to establish the initial location.
- (void)mouseDown:(NSEvent *)theEvent
{    
    NSRect  windowFrame = [self frame];

    //grab the mouse location in global coordinates
   initialLocation = [self convertBaseToScreen:[theEvent locationInWindow]];
   initialLocation.x -= windowFrame.origin.x;
   initialLocation.y -= windowFrame.origin.y;
}


@end
