//
//  CodexFab
//
// XMAppDelegate+Licensing.m
//
//  App delegate extension for licensing methods.
//  Pay attention to the TODO: comments below.
//
//  Licensed under CC Attribution License 3.0 <http://creativecommons.org/licenses/by/3.0/>
//
// Designed to work with CocoaFob by Gleb Dolgich
// <http://github.com/gbd/cocoafob/tree/master>
//
//  Created by Alex Clarke on 10/06/09.
//  Copyright 2009 MachineCodex Software Australia. All rights reserved.


#import "DateLineAppDelegate.h"
#import "XMLicensingWindowController.h"
#import "XMArgumentKeys.h"
#import "CFobLicVerifier.h"


@implementation DateLineAppDelegate (Licensing)


- (XMLicensingWindowController *)sharedLicensingWindowController {
	
	return [XMLicensingWindowController sharedLicensingWindowController];
}

- (IBAction)showLicensingWindow:(id)sender {
		
	[[[self sharedLicensingWindowController] window] makeKeyAndOrderFront:self];
}

- (void) launchCheck {
	
	if ([self verifyLicense]) {
		
		NSLog(@"Application is registered.");
		[self sharedLicensingWindowController].isLicensed= YES;
	}
	else {
		
		NSLog(@"Application not registered.");
		[self sharedLicensingWindowController].isLicensed= NO;

		// Perform trial timeout check
	}
}

- (BOOL) verifyLicense {
		
	NSUserDefaults * defaults = [NSUserDefaults standardUserDefaults];
	NSString * regCode = [defaults valueForKey:kXMRegCode];
	NSString * name = [defaults valueForKey:kXMRegName];
	
	// Here we match CocoaFob's licensekey.rb "productname,username" format
	NSString * regName = [NSString stringWithFormat:@"%@,%@", kXMProductCode, name];
	
	// TODO: Obfuscated public key inspired by AquaticPrime: break up your pubkey.pem and insert it below.
	// Do not use this actual key in your app: it was generated specifically for LicenseExample.app.
	// Don't insert the header or footer text, just the key itself. 
	// Add a "\n" token to represent each pubkey.pem newline.
	NSMutableString *pubKeyBase64 = [NSMutableString string];
	[pubKeyBase64 appendString:@"MIHxMIGoBgcqhkjOOAQBMIGcAkEAwwERbGhwJmWzBD"];
	[pubKeyBase64 appendString:@"w17PCne8Mzv/NOPoFHw4uB\n"];
	[pubKeyBase64 appendString:@"a2/f2jfBr3+t0FCWwws80T3pklQJtm"];
	[pubKeyBase64 appendString:@"MvaK5WDKOoex5nAYhrlQIVAJJj6xryPhA3\n"];
	[pubKeyBase64 appendString:@"yPUVbdRzbtRLXcBHAkB2eRNPR1J1kczDNL1DnJiAe"];
	[pubKeyBase64 appendString:@"/TBaEdOrMXO2l1F7kF46ezj\n"];
	[pubKeyBase64 appendString:@"Wrao35TwYhb5f63+O+KXQmM8R9NZlxp"];
	[pubKeyBase64 appendString:@"+/jXkTXZAA0QAAkEArU/"];
	[pubKeyBase64 appendString:@"3akyq0njVP6Kh\n"];
	[pubKeyBase64 appendString:@"0vyocUJgPwRFHabLZisrvlQ9vI/A"];
	[pubKeyBase64 appendString:@"+kkwWyDJ2x6BPjNzqFGH1vvfdwEtHnFMbAu2\n"];
	[pubKeyBase64 appendString:@"icETcw==\n"];
	
	NSString *publicKey = [CFobLicVerifier completePublicKeyPEM:pubKeyBase64];

	CFobLicVerifier * verifier = [CFobLicVerifier verifierWithPublicKey:publicKey];

	verifier.regName = regName;
	verifier.regCode = regCode;
	NSLog(@"publicKey %@ \n regCode: %@ regName: %@", publicKey, verifier.regCode, verifier.regName);
	 
	if ([verifier verify]) {

		NSLog(@"Yes %@", verifier);
		return YES;
	}
		 
	NSLog(@"No %@", verifier);
	return NO;
}
	 
- (void) registrationChanged:(NSNotification *)notification {
	
	NSLog(@"registrationChanged");
		
	XMLicensingWindowController * licenseWindowController = [self sharedLicensingWindowController];
	[self showLicensingWindow:self];
	
	BOOL isValidLicense = [self verifyLicense];
	
	[licenseWindowController showLicensedStatus:isValidLicense];
}

@end
